/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types.display;

import ch.e2e.ant.gui.configuration.ConfigurationParseException;
import ch.e2e.ant.gui.configuration.types.AbstractGuiElement;
import ch.e2e.io.FileUtilities;
import ch.e2e.swing.MultiLineLabel;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Message
extends AbstractGuiElement {
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String CENTER = "center";
    private static final String TOP = "left";
    private static final String BOTTOM = "right";
    private static final String MIDDLE = "center";
    private String text;
    private String filename;
    private String hAlign = "left";
    private String vAlign = "center";
    private MultiLineLabel label = null;
    private JTextArea textArea = null;
    private JComponent component;
    private int width = -1;

    public void setText(String text) {
        if (this.filename != null) {
            throw new ConfigurationParseException("Only one text or filename attribute allowed for a message.");
        }
        this.text = text;
    }

    public void addText(String text) {
        if (this.filename != null) {
            throw new ConfigurationParseException("Only one text or filename attribute allowed for a message.");
        }
        if (this.text != null) {
            throw new ConfigurationParseException("Only one text attribute or element allowed for a message.");
        }
        this.text = text;
    }

    public void sethAlign(String hAlign) {
        this.hAlign = hAlign;
    }

    public void setvAlign(String vAlign) {
        this.vAlign = vAlign;
    }

    public void updateText(String text) {
        if (!this.text.equals(text)) {
            this.text = text;
            this.label.setText(text);
        }
    }

    public void setFilename(String filename) {
        if (this.text != null) {
            throw new ConfigurationParseException("Only one text attribute or element allowed for a message.");
        }
        this.filename = filename;
    }

    public void updateFilename(String filename) {
        if (!this.filename.equals(filename)) {
            this.filename = filename;
            String text = this.createTextFromFile();
            this.textArea.setText(text);
        }
    }

    @Override
    public JComponent getGuiElement() {
        if (this.component == null) {
            if (this.text == null && this.filename == null) {
                throw new ConfigurationParseException("text or file element must be specified for a message.");
            }
            if (this.filename == null) {
                this.label = new MultiLineLabel(this.text);
                this.setAlignment();
                this.component = this.label;
                if (this.width > -1) {
                    this.label.setMaximumLineWidth(this.width);
                }
            } else {
                String text = this.createTextFromFile();
                this.textArea = new JTextArea(text);
                this.textArea.setEditable(false);
                this.textArea.setLineWrap(true);
                this.textArea.setWrapStyleWord(true);
                this.component = new JScrollPane(this.textArea, 20, 30);
                this.setFill("both");
            }
        }
        return this.component;
    }

    @Override
    public String getFillDefault() {
        return "horizontal";
    }

    public void setWidth(int width) {
        this.width = width;
    }

    private void setAlignment() {
        if (this.hAlign.equalsIgnoreCase("left")) {
            this.label.setHorizontalAlignment(2);
        } else if (this.hAlign.equalsIgnoreCase("right")) {
            this.label.setHorizontalAlignment(4);
        } else if (this.hAlign.equalsIgnoreCase("center")) {
            this.label.setHorizontalAlignment(0);
        }
        if (this.vAlign.equalsIgnoreCase("left")) {
            this.label.setVerticalAlignment(1);
        } else if (this.vAlign.equalsIgnoreCase("right")) {
            this.label.setVerticalAlignment(3);
        } else if (this.vAlign.equalsIgnoreCase("center")) {
            this.label.setVerticalAlignment(0);
        }
    }

    private String createTextFromFile() {
        String text;
        StringWriter writer = new StringWriter();
        try {
            FileUtilities.copyFromClasspath((String)this.filename, (Writer)writer);
            text = writer.toString();
        }
        catch (Exception ex) {
            text = this.filename + " not found.";
        }
        return text;
    }
}

