/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase.response;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class TestcaseUniqueIdService {
    private static final HashMap<String, TestcaseUniqueIdService> services = new HashMap();
    private HashMap<String, String> uniqueIds = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestcaseUniqueIdService getService(String projectName) {
        TestcaseUniqueIdService service = services.get(projectName);
        if (service == null) {
            HashMap<String, TestcaseUniqueIdService> hashMap = services;
            synchronized (hashMap) {
                service = services.get(projectName);
                if (service == null) {
                    service = new TestcaseUniqueIdService();
                    services.put(projectName, service);
                }
            }
        }
        return service;
    }

    private TestcaseUniqueIdService() {
    }

    public String createUniqueId(String originalString, Map<String, String> uniqueIds) {
        String uniqueId = UniqueIdService.createUniqueId((String)originalString, uniqueIds);
        uniqueIds.put(originalString, uniqueId);
        return uniqueId;
    }

    public Map<String, String> loadUniqueIds(File idFile) throws WrongIDFileVersionException {
        HashMap uniqueIds = UniqueIdService.loadUniqueIds((File)idFile);
        this.uniqueIds.putAll(uniqueIds);
        return uniqueIds;
    }

    public void saveIds(Map<String, String> uniqueIds, File idFile) {
        UniqueIdService.saveIds(uniqueIds, (File)idFile);
    }
}

