/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.execute.rest;

import ch.e2e.builder.base.message.SendStatusEvent;
import ch.e2e.builder.trace.request.BearerTokenCredentials;
import ch.e2e.builder.trace.request.RequestException;
import ch.e2e.builder.trace.testcase.LogFile;
import ch.e2e.builder.traceviewer.execute.rest.AsyncRequest;
import ch.e2e.builder.traceviewer.execute.rest.LoggingFilter;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.secure.TrustAllManager;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.glassfish.jersey.client.ClientConfig;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RequestExecutor {
    public static final String HTTP_02 = "HTTP_02";
    public static final String HTTP_03 = "HTTP_03";
    public static final String HTTP_04 = "HTTP_04";
    public static final String HTTP_05 = "HTTP_05";
    public static final String HTTP_09 = "HTTP_09";
    private static final String UNKNOWN_ERROR = "UNKNOWN ERROR";
    private static final int READ_TIMEOUT_MS = 180000;
    private final Client client;

    public RequestExecutor(LogFile requestLog, LogFile responseLog) {
        this(RequestExecutor.newClient(requestLog, responseLog));
    }

    RequestExecutor(Client client) {
        this.client = client;
    }

    private static Client newClient(LogFile requestLog, LogFile responseLog) {
        return ClientBuilder.newBuilder().withConfig((Configuration)RequestExecutor.newClientConfig(requestLog, responseLog)).sslContext(RequestExecutor.getTrustAllSslContext()).hostnameVerifier((hostname, session) -> true).build();
    }

    private static ClientConfig newClientConfig(LogFile requestLog, LogFile responseLog) {
        return new ClientConfig().register((Object)new LoggingFilter(requestLog, responseLog)).register(ObjectMapperContextResolver.class).register(DocumentMessageBodyReader.class).property("jersey.config.client.readTimeout", (Object)180000).property("jersey.config.client.followRedirects", (Object)false);
    }

    public <R> R execute(AsyncRequest<R> request) throws RequestException {
        return this.execute(request, request.getResponseType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R execute(AsyncRequest<R> request, Class<R> responseType) throws RequestException {
        try (Response response = this.doRequest(request);){
            if (response.getMediaType() == null || response.getMediaType().isCompatible(request.getAcceptedMediaType())) {
                Object object = response.readEntity(responseType);
                return (R)object;
            }
            if (request.isIgnoredStatusCode(response.getStatus())) {
                throw RequestExecutor.exceptionForErrorCode(response, request.getUri());
            }
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.response.processing.error", "request.transaction.error.dialog.subtitle.content.not.acceptable");
            String message = String.format("Unexpected content type (%s <> %s)", response.getMediaType(), request.getAcceptedMediaType());
            throw new RequestException(request.getUri().toString(), HTTP_04, message, info);
        }
        catch (ProcessingException e) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.response.processing.error", "request.transaction.error.dialog.subtitle.response.processing.error");
            String msg = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
            throw new RequestException(request.getUri().toString(), HTTP_09, msg, info);
        }
    }

    private Response doRequest(AsyncRequest<?> request) throws RequestException {
        URI target = request.getUri();
        Invocation.Builder invocationBuilder = this.client.target(target).request().accept(new MediaType[]{request.getAcceptedMediaType()}).header("X-Bridge", (Object)"NoErrorReturn");
        if (request.getCredentials() instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials basic = (UsernamePasswordCredentials)request.getCredentials();
            invocationBuilder.header("Authorization", (Object)("Basic " + Base64.getEncoder().encodeToString(basic.toString().getBytes(StandardCharsets.UTF_8))));
        } else if (request.getCredentials() instanceof BearerTokenCredentials) {
            BearerTokenCredentials bearer = (BearerTokenCredentials)request.getCredentials();
            invocationBuilder.header("Authorization", (Object)bearer.requestAuthorizationValue());
        }
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        replaceMap.put("url", request.getUri().toString());
        EventController.fire((EventObject)new SendStatusEvent((Object)this, "http.client.status.connecting", replaceMap));
        Entity entity = Entity.entity((Object)request.getBody(), (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Response response = invocationBuilder.method(request.getMethod(), entity);
        int code = response.getStatus();
        if (code > 199 && code < 205 || request.isIgnoredStatusCode(code)) {
            return response;
        }
        throw RequestExecutor.exceptionForErrorCode(response, target);
    }

    private static RequestException exceptionForErrorCode(Response response, URI target) {
        int code = response.getStatus();
        String message = String.format("%d: %s", code, RequestExecutor.getStatusReason(response));
        if (code == 401) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.request.processing.error", "request.transaction.error.dialog.subtitle.authentication.failed");
            return new RequestException(target.toString(), HTTP_04, message, info);
        }
        if (code == 403) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.request.processing.error", "request.transaction.error.dialog.subtitle.authorization.failed");
            return new RequestException(target.toString(), HTTP_04, message, info);
        }
        if (code == 404) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.connect.error", "request.transaction.error.dialog.subtitle.resource.not.found");
            return new RequestException(target.toString(), HTTP_04, message, info);
        }
        if (code == 500) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.connect.error", "request.transaction.error.dialog.subtitle.connect.error");
            return new RequestException(target.toString(), HTTP_05, message, info);
        }
        if (code > 204 && code < 306) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.unhandled.request", "request.transaction.error.dialog.subtitle.unhandled.request");
            return new RequestException(target.toString(), HTTP_02, message, info);
        }
        if (code > 399 && code < 506) {
            RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.unhandled.request", "request.transaction.error.dialog.subtitle.unhandled.request");
            return new RequestException(target.toString(), HTTP_03, message, info);
        }
        RequestException.Info info = new RequestException.Info("request.transaction.error.dialog.internal.title.unknown.error", "request.transaction.error.dialog.subtitle.unknown.error");
        return new RequestException(target.toString(), HTTP_04, UNKNOWN_ERROR, info);
    }

    private static String getStatusReason(Response response) {
        String reason = null;
        if (MediaType.TEXT_PLAIN_TYPE.isCompatible(response.getMediaType())) {
            try {
                reason = (String)response.readEntity(String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (reason == null || reason.isEmpty()) {
            reason = response.getStatusInfo().getReasonPhrase();
        }
        return reason;
    }

    private static SSLContext getTrustAllSslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{new TrustAllManager()}, null);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static class DocumentMessageBodyReader
    implements MessageBodyReader<Document> {
        private DocumentMessageBodyReader() {
        }

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return type.equals(Document.class);
        }

        public Document readFrom(Class<Document> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            try {
                return DomUtilities.parse((InputStream)entityStream, (boolean)false, (boolean)false, (boolean)true);
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new IOException(e);
            }
        }
    }

    private static class ObjectMapperContextResolver
    implements ContextResolver<ObjectMapper> {
        private final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

        private ObjectMapperContextResolver() {
        }

        public ObjectMapper getContext(Class<?> type) {
            return this.mapper;
        }
    }
}

