/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.model;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class EnumComboBoxModel<E extends Enum<E>>
extends AbstractListModel
implements ComboBoxModel {
    private final Class<E> enumClass;
    private final E[] enumConstants;
    private E selectedItem;

    public EnumComboBoxModel(Class<E> enumClass) {
        this.enumClass = enumClass;
        this.enumConstants = (Enum[])enumClass.getEnumConstants();
        if (this.getSize() > 0) {
            this.selectedItem = this.enumConstants[0];
        }
    }

    @Override
    public int getSize() {
        return this.enumConstants.length;
    }

    @Override
    public Object getElementAt(int index) {
        return this.enumConstants[index];
    }

    @Override
    public void setSelectedItem(Object anItem) {
        try {
            this.selectedItem = this.enumClass.isInstance(anItem) ? (Enum)anItem : Enum.valueOf(this.enumClass, String.valueOf(anItem));
            this.fireContentsChanged(this, 0, this.getSize());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }
}

