/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.model;

import ch.e2e.swing.model.Directory;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class DirectoryComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel {
    private ArrayList directories = new ArrayList();
    private Directory selectedDir;

    public DirectoryComboBoxModel() {
        Directory root = Directory.getRoot();
        this.directories.add(root);
        this.directories.addAll(root.getSubdirs());
    }

    @Override
    public int getSize() {
        return this.directories.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.directories.get(index);
    }

    @Override
    public void setSelectedItem(Object selectedItem) {
        if (this.selectedDir == null || !selectedItem.equals(this.selectedDir.getDir())) {
            this.removeUntilRootFolder(this.selectedDir);
            this.selectedDir = (Directory)selectedItem;
            Directory[] path = this.selectedDir.getPathToRoot();
            if (path.length > 2) {
                Directory root = path[1];
                path = Directory.getRoot().getPath(this.selectedDir);
                int index = this.directories.indexOf(root);
                for (int i = 1; i < path.length; ++i) {
                    this.directories.add(index + i, path[i]);
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedDir;
    }

    @Override
    public void removeElementAt(int index) {
        this.directories.remove(index);
        this.fireContentsChanged(this, -1, -1);
    }

    public void insertElementAt(Object directory, int index) {
        this.directories.add(index, directory);
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public void removeElement(Object directory) {
        this.directories.remove(directory);
        this.fireContentsChanged(this, -1, -1);
    }

    public void removeAllElements() {
        this.directories.clear();
        this.fireContentsChanged(this, -1, -1);
    }

    public void addElement(Object directory) {
        this.directories.add(directory);
        this.fireContentsChanged(this, -1, -1);
    }

    private void removeUntilRootFolder(Directory directory) {
        if (directory != null && directory.getParent() != null) {
            Directory parent = directory;
            while (parent.getParent().getDir() != null) {
                this.directories.remove(parent);
                parent = parent.getParent();
            }
        }
    }
}

