/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.document;

import java.awt.Toolkit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RegexFieldDocument
extends PlainDocument {
    private Pattern pattern;
    private int maxLength = -1;

    public RegexFieldDocument(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void insertString(int offset, String insert, AttributeSet attributes) throws BadLocationException {
        if (this.maxLength > -1 && this.getLength() + insert.length() > this.maxLength) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            StringBuffer text = new StringBuffer(this.getText(0, this.getLength()));
            text.insert(offset, insert);
            Matcher matcher = this.pattern.matcher(text);
            if (matcher.matches()) {
                super.insertString(offset, insert, attributes);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public void setPattern(String pattern) throws PatternSyntaxException {
        this.pattern = Pattern.compile(pattern);
        try {
            Matcher matcher;
            String text = this.getText(0, this.getLength());
            if (text.length() > 0 && !(matcher = this.pattern.matcher(text)).matches()) {
                super.remove(0, this.getLength());
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

