/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class MouseOverList
extends JList {
    private int mouseOverIndex = -1;

    public MouseOverList() {
        this.setupMouseListeners();
    }

    public MouseOverList(ListModel dataModel) {
        super(dataModel);
        this.setupMouseListeners();
    }

    public MouseOverList(Object[] listData) {
        super(listData);
        this.setupMouseListeners();
    }

    public MouseOverList(Vector<?> listData) {
        super(listData);
        this.setupMouseListeners();
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        ListCellRenderer cr = this.getCellRenderer();
        if (cr instanceof MouseOverListCellRenderer) {
            ((MouseOverListCellRenderer)cr).setDelegate(cellRenderer);
        } else {
            super.setCellRenderer(new MouseOverListCellRenderer(cellRenderer));
        }
    }

    private void setupMouseListeners() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = MouseOverList.this.locationToIndex(e.getPoint());
                if (index != MouseOverList.this.mouseOverIndex) {
                    Rectangle r = MouseOverList.this.getCellBounds(index, MouseOverList.this.mouseOverIndex == -1 ? index : MouseOverList.this.mouseOverIndex);
                    MouseOverList.this.mouseOverIndex = index;
                    MouseOverList.this.repaint(r);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Rectangle r = MouseOverList.this.getCellBounds(MouseOverList.this.mouseOverIndex, MouseOverList.this.mouseOverIndex);
                MouseOverList.this.mouseOverIndex = -1;
                MouseOverList.this.repaint(r);
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    private class MouseOverListCellRenderer
    extends DefaultListCellRenderer {
        private ListCellRenderer delegate;

        private MouseOverListCellRenderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        public void setDelegate(ListCellRenderer cellRenderer) {
            this.delegate = cellRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.delegate.getListCellRendererComponent(list, value, index, MouseOverList.this.mouseOverIndex == index, cellHasFocus);
        }
    }
}

