/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing;

import ch.e2e.swing.Message;
import ch.e2e.swing.Tree;
import ch.e2e.swing.event.MessageActionListener;
import ch.e2e.swing.model.MessageTextPaneModel;
import java.awt.Color;
import java.awt.event.MouseListener;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class MessageTextPane
extends JScrollPane {
    private MessageTextPaneModel model = new MessageTextPaneModel();
    private Tree tree = new Tree(this.model);

    public MessageTextPane(String name, MouseListener mouseListener) {
        this(name);
        this.tree.addMouseListener(mouseListener);
    }

    public MessageTextPane(String name) {
        super(20, 30);
        this.setViewportView(this.tree);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.setName(name);
    }

    public void addMessageActionListener(MessageActionListener messageListener) {
        this.model.addMessageActionListener(messageListener);
    }

    public void removeMessageActionListener(MessageActionListener messageListener) {
        this.model.removeMessageActionListener(messageListener);
    }

    @Override
    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        if (this.tree != null) {
            this.tree.setOpaque(opaque);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.tree != null) {
            this.tree.setBackground(bg);
        }
    }

    public void clear() {
        this.model.clear();
        this.tree.refresh();
    }

    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    public void appendMessage(Message message) {
        TreePath messagePath = this.model.appendMessage(message);
        this.tree.refresh();
        this.tree.expandPath(messagePath);
        this.tree.setSelectionPath(messagePath);
        this.tree.scrollPathToVisible(messagePath);
    }
}

