/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.serialize;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class NamespaceSorter
extends ProxyReceiver
implements Sortable {
    private List<NamespaceBinding> namespaces = new ArrayList<NamespaceBinding>();

    public NamespaceSorter(Receiver next) {
        super(next);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.namespaces.clear();
        super.startElement(elemName, typeCode, location, properties);
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        for (NamespaceBinding binding : namespaceBindings) {
            this.namespaces.add(binding);
        }
    }

    @Override
    public void startContent() throws XPathException {
        if (this.namespaces.size() > 1) {
            GenericSorter.quickSort(0, this.namespaces.size(), this);
        }
        for (NamespaceBinding binding : this.namespaces) {
            this.nextReceiver.namespace(binding, 0);
        }
        super.startContent();
    }

    @Override
    public int compare(int a, int b) {
        String p1 = this.namespaces.get(a).getPrefix();
        String p2 = this.namespaces.get(b).getPrefix();
        return p1.compareTo(p2);
    }

    @Override
    public void swap(int a, int b) {
        NamespaceBinding temp = this.namespaces.get(a);
        this.namespaces.set(a, this.namespaces.get(b));
        this.namespaces.set(b, temp);
    }
}

