/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.util.TreeMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.RangeKey;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyIndex;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;

public class KeyMap
extends SystemFunction {
    @Override
    public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue keyName = (StringValue)arguments[0].head();
        NodeInfo doc = (NodeInfo)arguments[1].head();
        StringValue min = (StringValue)arguments[2].head();
        StringValue max = (StringValue)arguments[3].head();
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        String lex = keyName.getStringValue();
        StructuredQName keyQName = StructuredQName.fromLexicalQName(lex, false, true, this.getRetainedStaticContext());
        KeyManager keyManager = this.getRetainedStaticContext().getPackageData().getKeyManager();
        KeyDefinitionSet kds = keyManager.getKeyDefinitionSet(keyQName);
        if (kds == null) {
            throw new XPathException("Key definition " + keyName.getStringValue() + " not found");
        }
        KeyMap.checkKeyDefinition(th, kds, keyName.getStringValue());
        String minS = min == null ? null : min.getStringValue();
        String maxS = max == null ? null : max.getStringValue();
        KeyIndex index = keyManager.obtainIndex(kds, doc.getTreeInfo(), context);
        return new RangeKey(minS, maxS, (TreeMap)index.getUnderlyingMap());
    }

    private static void checkKeyDefinition(TypeHierarchy th, KeyDefinitionSet kds, String keyName) throws XPathException {
        if (kds.getCollationName() != null && !kds.getCollationName().equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new XPathException("Key definition " + keyName + " does not use codepoint collation");
        }
        if (!kds.isRangeKey()) {
            throw new XPathException("Key definition " + keyName + " is not defined as a range key");
        }
        for (KeyDefinition def : kds.getKeyDefinitions()) {
            ItemType it = def.getUse().getItemType();
            if (it == BuiltInAtomicType.UNTYPED_ATOMIC || it == BuiltInAtomicType.STRING || th.isSubType(it, BuiltInAtomicType.STRING)) continue;
            throw new XPathException("Key definition " + keyName + " has non-string key values");
        }
    }
}

