/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.IntPredicate;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Query;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.One;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ZeroOrMore;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.serialize.SerializationParamsHandler;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.TextLinesIterator;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public class EXPathFile {
    public static final BigDecimalValue VERSION = new BigDecimalValue(new BigDecimal("0.1"));
    public static final String NAMESPACE = "http://expath.org/ns/file";
    public static final String PREFIX = "file";
    public static final String ERROR_NAMESPACE = "http://expath.org/ns/file";
    public static final String ERROR_PREFIX = "file";
    private static final String ERROR_PATH_NOT_EXIST = "not-found";
    private static final String ERROR_PATH_EXISTS = "exists";
    private static final String ERROR_PATH_NOT_DIRECTORY = "no-dir";
    private static final String ERROR_PATH_IS_DIRECTORY = "is-dir";
    private static final String ERROR_UNKNOWN_ENCODING = "unknown-encoding";
    public static final String ERROR_INDEX_OUT_OF_BOUNDS = "out-of-range";
    public static final String ERROR_IO = "io-error";
    private static final One<StringValue> UTF8 = new One<StringValue>(new StringValue("UTF-8"));
    public static final String NEWLINE = System.getProperty("line.separator");

    public static BigDecimalValue version() {
        return VERSION;
    }

    public static One<BooleanValue> exists(One<StringValue> path) throws XPathException {
        File file = EXPathFile.toFile(((StringValue)path.head()).getStringValue());
        return One.bool(file.exists());
    }

    public static One<BooleanValue> isDir(One<StringValue> path) throws XPathException {
        File file = EXPathFile.toFile(((StringValue)path.head()).getStringValue());
        return One.bool(file.exists() && file.isDirectory());
    }

    public static One<BooleanValue> isFile(One<StringValue> path) throws XPathException {
        File file = EXPathFile.toFile(((StringValue)path.head()).getStringValue());
        return One.bool(file.exists() && file.isFile());
    }

    public static One<DateTimeValue> lastModified(One<StringValue> path) throws XPathException {
        File file = EXPathFile.toFile(((StringValue)path.head()).getStringValue());
        if (!file.exists()) {
            EXPathFile.error("File " + path + " does not exist", ERROR_PATH_NOT_EXIST);
        }
        long dt = file.lastModified();
        return new One<DateTimeValue>(DateTimeValue.EPOCH.add(DayTimeDurationValue.fromMilliseconds(dt)));
    }

    public static One<IntegerValue> size(One<StringValue> path) throws XPathException {
        File file = EXPathFile.toExistingFile(((StringValue)path.head()).getStringValue());
        return One.integer(file.isDirectory() ? 0L : file.length());
    }

    public static void append(XPathContext context, One<StringValue> file, ZeroOrMore<Item<?>> contents) throws XPathException {
        Properties props = new Properties();
        props.setProperty("method", "xml");
        EXPathFile.serialize(context, ((StringValue)file.head()).getStringValue(), true, contents, new SerializationProperties(props));
    }

    public static void append(XPathContext context, One<StringValue> file, ZeroOrMore<Item<?>> contents, One<NodeInfo> params) throws XPathException {
        SerializationParamsHandler sph = new SerializationParamsHandler();
        sph.setSerializationParams((NodeInfo)params.head());
        SerializationProperties props = sph.getSerializationProperties();
        EXPathFile.serialize(context, ((StringValue)file.head()).getStringValue(), true, contents, props);
    }

    private static void serialize(XPathContext context, String path, boolean append, ZeroOrMore<Item<?>> contents, SerializationProperties properties) throws XPathException {
        SerializerFactory factory = context.getConfiguration().getSerializerFactory();
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        pipe.setXPathContext(context);
        File file = EXPathFile.toFile(path);
        if (file.isDirectory()) {
            EXPathFile.error("Path " + path + " is a directory", ERROR_PATH_IS_DIRECTORY);
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException e) {
            EXPathFile.error("Failed to write to file " + path, e, ERROR_UNKNOWN_ENCODING);
        }
        StreamResult result = new StreamResult(stream);
        Receiver sr = factory.getReceiver((Result)result, properties, pipe);
        sr.open();
        sr.startDocument(0);
        for (Item item : contents) {
            sr.append(item);
        }
        sr.endDocument();
        sr.close();
        try {
            if (stream != null) {
                ((OutputStream)stream).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void appendText(One<StringValue> path, One<StringValue> contents) throws XPathException {
        EXPathFile.appendText(path, contents, UTF8);
    }

    public static void appendText(One<StringValue> path, One<StringValue> contents, One<StringValue> encoding) throws XPathException {
        File file = null;
        try {
            file = EXPathFile.toFile(((StringValue)path.head()).getStringValue());
            if (file.isDirectory()) {
                EXPathFile.error("Path " + path + " is a directory", ERROR_PATH_IS_DIRECTORY);
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), ((StringValue)encoding.head()).getStringValue());
            writer.write(((StringValue)contents.head()).getStringValue());
            ((Writer)writer).close();
        }
        catch (UnsupportedEncodingException e) {
            EXPathFile.error("Unsupported encoding " + encoding, ERROR_UNKNOWN_ENCODING);
        }
        catch (FileNotFoundException e) {
            EXPathFile.error("Failed to create file", e, ERROR_PATH_NOT_DIRECTORY);
        }
        catch (IOException e) {
            EXPathFile.error("Failed to write to file " + file.getAbsolutePath(), e, ERROR_IO);
        }
    }

    public static void appendTextLines(One<StringValue> path, ZeroOrMore<StringValue> contents) throws XPathException {
        EXPathFile.appendTextLines(path, contents, UTF8);
    }

    public static void appendTextLines(One<StringValue> path, ZeroOrMore<StringValue> contents, One<StringValue> encoding) throws XPathException {
        File file = null;
        try {
            file = EXPathFile.toFile(((StringValue)path.head()).getStringValue());
            if (file.isDirectory()) {
                EXPathFile.error("Path " + path + " is a directory", ERROR_PATH_IS_DIRECTORY);
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), ((StringValue)encoding.head()).getStringValue());
            for (StringValue sv : contents) {
                writer.write(sv.getStringValue());
                writer.write(NEWLINE);
            }
        }
        catch (UnsupportedEncodingException e) {
            EXPathFile.error("Unsupported encoding " + encoding, ERROR_UNKNOWN_ENCODING);
        }
        catch (FileNotFoundException e) {
            EXPathFile.error("Failed to create file", e, ERROR_PATH_NOT_DIRECTORY);
        }
        catch (IOException e) {
            EXPathFile.error("Failed to write to file " + (file == null ? path : file.getAbsolutePath()), e, ERROR_IO);
        }
    }

    public static void appendBinary(One<StringValue> path, ZeroOrMore<Base64BinaryValue> contents) throws XPathException {
        try {
            File file = EXPathFile.toFile(((StringValue)path.head()).getStringValue());
            if (file.isDirectory()) {
                EXPathFile.error("Path " + path + " is a directory", ERROR_PATH_IS_DIRECTORY);
            }
            FileOutputStream stream = new FileOutputStream(file, true);
            for (Base64BinaryValue b64 : contents) {
                stream.write(b64.getBinaryValue());
            }
            stream.close();
        }
        catch (FileNotFoundException e) {
            EXPathFile.error("Failed to create file", e, ERROR_PATH_NOT_DIRECTORY);
        }
        catch (IOException e) {
            EXPathFile.error("Failed to write to file " + path, e, ERROR_IO);
        }
    }

    public static void copy(One<StringValue> source, One<StringValue> target) throws XPathException {
        File from = EXPathFile.toFile(((StringValue)source.head()).getStringValue());
        if (from.exists() && from.isDirectory()) {
            File to = EXPathFile.toFile(((StringValue)target.head()).getStringValue());
            if (to.exists()) {
                if (to.isDirectory()) {
                    to = new File(to, from.getName());
                    to.mkdir();
                    EXPathFile.copyDirectory(from, to);
                } else {
                    EXPathFile.error("Source is a directory but target is a file", ERROR_PATH_EXISTS);
                }
            } else {
                to.mkdir();
                EXPathFile.copyDirectory(from, to);
            }
        } else {
            File to = EXPathFile.toFile(((StringValue)target.head()).getStringValue());
            if (to.exists()) {
                if (to.isDirectory()) {
                    to = new File(to, from.getName());
                    EXPathFile.copyFile(from, to);
                } else {
                    EXPathFile.copyFile(from, to);
                }
            } else {
                EXPathFile.copyFile(from, to);
            }
        }
    }

    private static void copyDirectory(File from, File to) throws XPathException {
        for (File child : from.listFiles()) {
            File target = new File(to, child.getName());
            if (child.isDirectory()) {
                if (target.exists()) {
                    if (target.isDirectory()) {
                        EXPathFile.copyDirectory(child, target);
                        continue;
                    }
                    target.delete();
                    target.mkdir();
                    EXPathFile.copyDirectory(child, target);
                    continue;
                }
                target.mkdir();
                EXPathFile.copyDirectory(child, target);
                continue;
            }
            if (target.exists() && target.isDirectory()) {
                EXPathFile.error("Cannot copy " + child.getAbsolutePath() + " because directory " + target.getAbsolutePath() + " is in the way", ERROR_PATH_IS_DIRECTORY);
                continue;
            }
            EXPathFile.copyFile(child, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws XPathException {
        try {
            Query.createFileIfNecessary(destFile);
            FileChannel source = null;
            AbstractInterruptibleChannel destination = null;
            try {
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                ((FileChannel)destination).transferFrom(source, 0L, source.size());
            }
            finally {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
            }
        }
        catch (IOException e) {
            EXPathFile.error("Failed to copy file " + sourceFile + " to " + destFile, e, ERROR_IO);
        }
    }

    public static void createDir(One<StringValue> dir) throws XPathException {
        File file = EXPathFile.toFile(((StringValue)dir.head()).getStringValue());
        if (file.exists()) {
            if (!file.isDirectory()) {
                EXPathFile.error("Path " + dir + " already exists and is not a directory", ERROR_PATH_EXISTS);
            }
        } else {
            boolean result = file.mkdirs();
            if (!result) {
                EXPathFile.error("Failed to create directory " + dir, ERROR_PATH_EXISTS);
            }
        }
    }

    private static void deleteTempFile(XPathContext context, File temp) {
        Boolean d = context.getConfiguration().getConfigurationProperty(Feature.EXPATH_FILE_DELETE_TEMPORARY_FILES);
        if (d.booleanValue()) {
            temp.deleteOnExit();
        }
    }

    public static One<StringValue> createTempDir(XPathContext context, One<StringValue> prefix, One<StringValue> suffix) throws XPathException, IOException {
        File test = File.createTempFile(((StringValue)prefix.head()).getStringValue(), ((StringValue)suffix.head()).getStringValue());
        String path = test.getCanonicalPath();
        test.delete();
        File temp = new File(path);
        temp.mkdirs();
        EXPathFile.deleteTempFile(context, temp);
        return One.string(temp.getCanonicalPath());
    }

    public static One<StringValue> createTempDir(XPathContext context, One<StringValue> prefix, One<StringValue> suffix, One<StringValue> dir) throws XPathException, IOException {
        File file = EXPathFile.toFile(((StringValue)dir.head()).getStringValue());
        File test = File.createTempFile(((StringValue)prefix.head()).getStringValue(), ((StringValue)suffix.head()).getStringValue(), file);
        String path = test.getCanonicalPath();
        test.delete();
        File temp = new File(path);
        temp.mkdirs();
        EXPathFile.deleteTempFile(context, temp);
        return One.string(temp.getCanonicalPath());
    }

    public static One<StringValue> createTempFile(XPathContext context, One<StringValue> prefix, One<StringValue> suffix) throws XPathException, IOException {
        File temp = File.createTempFile(((StringValue)prefix.head()).getStringValue(), ((StringValue)suffix.head()).getStringValue());
        EXPathFile.deleteTempFile(context, temp);
        return One.string(temp.getCanonicalPath());
    }

    public static One<StringValue> createTempFile(XPathContext context, One<StringValue> prefix, One<StringValue> suffix, One<StringValue> dir) throws XPathException, IOException {
        File file = EXPathFile.toFile(((StringValue)dir.head()).getStringValue());
        File temp = File.createTempFile(((StringValue)prefix.head()).getStringValue(), ((StringValue)suffix.head()).getStringValue(), file);
        EXPathFile.deleteTempFile(context, temp);
        return One.string(temp.getCanonicalPath());
    }

    public static void delete(One<StringValue> path) throws XPathException {
        boolean result;
        File file = EXPathFile.toExistingFile(((StringValue)path.head()).getStringValue());
        if (file.isDirectory() && file.list().length != 0) {
            EXPathFile.error("Cannot delete non-empty directory " + file.getAbsolutePath(), ERROR_PATH_IS_DIRECTORY);
        }
        if (!(result = file.delete())) {
            EXPathFile.error("Failed to delete file " + file.getAbsolutePath(), ERROR_IO);
        }
    }

    public static void delete(One<StringValue> path, boolean recurse) throws XPathException {
        if (!recurse) {
            EXPathFile.delete(path);
        } else {
            File file = EXPathFile.toExistingFile(((StringValue)path.head()).getStringValue());
            try {
                EXPathFile.deleteRecursive(file);
            }
            catch (IOException e) {
                EXPathFile.error("Failed to delete " + path, e, ERROR_IO);
            }
        }
    }

    private static void deleteRecursive(File file) throws IOException {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                EXPathFile.deleteRecursive(child);
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    public static ZeroOrMore<StringValue> list(One<StringValue> dir) throws XPathException {
        return EXPathFile.list(dir, new One<BooleanValue>(BooleanValue.FALSE));
    }

    public static ZeroOrMore<StringValue> list(One<StringValue> dir, One<BooleanValue> recursive) throws XPathException {
        File file = EXPathFile.toExistingDirectory(((StringValue)dir.head()).getStringValue());
        if (!file.isDirectory()) {
            EXPathFile.error("File " + dir + " is not a directory", ERROR_PATH_NOT_DIRECTORY);
        }
        FilenameFilter all = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        };
        ArrayList<StringValue> result = new ArrayList<StringValue>();
        EXPathFile.gatherDirectoryContents(file, "", ((BooleanValue)recursive.head()).getBooleanValue(), all, result);
        return new ZeroOrMore<StringValue>(result);
    }

    public static ZeroOrMore<StringValue> list(One<StringValue> dir, One<BooleanValue> recursive, One<StringValue> pattern) throws XPathException {
        File file = EXPathFile.toExistingDirectory(((StringValue)dir.head()).getStringValue());
        if (!file.isDirectory()) {
            EXPathFile.error("File " + dir + " is not a directory", ERROR_PATH_NOT_DIRECTORY);
        }
        ArrayList<StringValue> result = new ArrayList<StringValue>();
        FilenameFilter filter = URIQueryParameters.makeGlobFilter(((StringValue)pattern.head()).getStringValue());
        EXPathFile.gatherDirectoryContents(file, "", ((BooleanValue)recursive.head()).getBooleanValue(), filter, result);
        return new ZeroOrMore<StringValue>(result);
    }

    private static void gatherDirectoryContents(File dir, String prefix, boolean recurse, FilenameFilter filter, List<StringValue> result) {
        String name;
        URIQueryParameters.RegexFilter filter2 = filter instanceof URIQueryParameters.RegexFilter ? (URIQueryParameters.RegexFilter)filter : null;
        for (File file : dir.listFiles(filter)) {
            if (filter2 != null && file.isDirectory() && !filter2.matches(file.getName())) continue;
            String string = name = prefix.isEmpty() ? file.getName() : prefix + File.separator + file.getName();
            if (file.isDirectory()) {
                name = name + File.separator;
            }
            result.add(new StringValue(name));
        }
        if (recurse) {
            for (File file : dir.listFiles()) {
                if (!file.isDirectory()) continue;
                name = prefix.isEmpty() ? file.getName() : prefix + File.separator + file.getName();
                EXPathFile.gatherDirectoryContents(file, name, recurse, filter, result);
            }
        }
    }

    public static void move(One<StringValue> source, One<StringValue> target) throws XPathException {
        File from = EXPathFile.toExistingFile(((StringValue)source.head()).getStringValue());
        File to = EXPathFile.toFile(((StringValue)target.head()).getStringValue());
        if (from.isDirectory()) {
            if (to.exists()) {
                if (to.isDirectory()) {
                    from.renameTo(new File(to, from.getName()));
                } else {
                    EXPathFile.error("Target of directory move exists and is not a directory", ERROR_PATH_EXISTS);
                }
            } else {
                to.mkdirs();
                for (File f : from.listFiles()) {
                    f.renameTo(new File(to, f.getName()));
                }
            }
        } else {
            boolean result;
            if (to.isDirectory()) {
                to = new File(to, from.getName());
            }
            if (to.exists()) {
                to.delete();
            }
            if (!(result = from.renameTo(to))) {
                throw new XPathException("Renaming " + source + " to " + target + " failed");
            }
        }
    }

    private static File checkReadSource(String path) throws XPathException {
        File file = EXPathFile.toExistingFile(path);
        if (file.isDirectory()) {
            EXPathFile.error("Path " + path + " is a directory", ERROR_PATH_IS_DIRECTORY);
        }
        if (!file.exists()) {
            EXPathFile.error("File not found: " + path, ERROR_PATH_NOT_EXIST);
        }
        return file;
    }

    public static One<Base64BinaryValue> readBinary(One<StringValue> path) throws XPathException {
        File file = EXPathFile.checkReadSource(((StringValue)path.head()).getStringValue());
        return new One<Base64BinaryValue>(EXPathFile.readBinary(file, ((StringValue)path.head()).getStringValue(), 0L, (int)file.length()));
    }

    public static One<Base64BinaryValue> readBinary(One<StringValue> path, One<IntegerValue> offset) throws XPathException {
        File file = EXPathFile.checkReadSource(((StringValue)path.head()).getStringValue());
        return new One<Base64BinaryValue>(EXPathFile.readBinary(file, ((StringValue)path.head()).getStringValue(), ((IntegerValue)offset.head()).longValue(), file.length() - ((IntegerValue)offset.head()).longValue()));
    }

    public static One<Base64BinaryValue> readBinary(One<StringValue> path, One<IntegerValue> offset, One<IntegerValue> length) throws XPathException {
        File file = EXPathFile.checkReadSource(((StringValue)path.head()).getStringValue());
        return new One<Base64BinaryValue>(EXPathFile.readBinary(file, ((StringValue)path.head()).getStringValue(), ((IntegerValue)offset.head()).longValue(), ((IntegerValue)length.head()).longValue()));
    }

    public static One<StringValue> readText(XPathContext context, One<StringValue> file) throws XPathException {
        return EXPathFile.readText(context, file, UTF8);
    }

    public static One<StringValue> readText(XPathContext context, One<StringValue> path, One<StringValue> encoding) throws XPathException {
        File file = EXPathFile.checkReadSource(((StringValue)path.head()).getStringValue());
        Reader reader = EXPathFile.getInputStreamReader(file, ((StringValue)encoding.head()).getStringValue());
        try {
            String result = UnparsedTextFunction.readFile(context.getConfiguration().getValidCharacterChecker(), reader).toString();
            reader.close();
            return One.string(result);
        }
        catch (XPathException e) {
            try {
                reader.close();
            }
            catch (IOException e1) {
                EXPathFile.error("Failed to close file " + file.getAbsolutePath(), e, ERROR_IO);
            }
            EXPathFile.error(e.getMessage(), ERROR_IO);
        }
        catch (IOException e) {
            try {
                reader.close();
            }
            catch (IOException e1) {
                EXPathFile.error("Failed to close file " + file.getAbsolutePath(), e, ERROR_IO);
            }
            EXPathFile.error("Failed to read file " + path, e, ERROR_IO);
        }
        return null;
    }

    private static Reader getInputStreamReader(File file, String encoding) throws XPathException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            CharsetDecoder decoder = Charset.forName(encoding).newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            return new InputStreamReader((InputStream)in, decoder);
        }
        catch (FileNotFoundException e) {
            EXPathFile.error("File not found: " + file.getAbsolutePath(), ERROR_PATH_NOT_EXIST);
        }
        catch (UnsupportedCharsetException e) {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e1) {
                    EXPathFile.error("Failed to close file " + file.getAbsolutePath(), e, ERROR_IO);
                }
            }
            EXPathFile.error("Unsupported encoding " + encoding, ERROR_UNKNOWN_ENCODING);
        }
        catch (IllegalCharsetNameException e) {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e1) {
                    EXPathFile.error("Failed to close file " + file.getAbsolutePath(), e, ERROR_IO);
                }
            }
            EXPathFile.error("Invalid encoding name " + encoding, ERROR_UNKNOWN_ENCODING);
        }
        return null;
    }

    public static ZeroOrMore<StringValue> readTextLines(One<StringValue> path) throws XPathException {
        return EXPathFile.readTextLines(path, UTF8);
    }

    public static ZeroOrMore<StringValue> readTextLines(One<StringValue> path, One<StringValue> encoding) throws XPathException {
        File file = EXPathFile.checkReadSource(((StringValue)path.head()).getStringValue());
        return new ZeroOrMore<StringValue>(new TextFileLinesIterator(file, ((StringValue)encoding.head()).getStringValue()));
    }

    public static Base64BinaryValue readBinary(File file, String path, long offset, long length) throws XPathException {
        try {
            int bytes;
            long skipped;
            long fileLength = file.length();
            if (offset < 0L) {
                EXPathFile.error("Negative offset in binary read:" + offset, ERROR_INDEX_OUT_OF_BOUNDS);
            }
            if (length < 0L) {
                EXPathFile.error("Negative length in binary read:" + length, ERROR_INDEX_OUT_OF_BOUNDS);
            }
            if (offset + length > fileLength) {
                EXPathFile.error("Length exceeds file length in binary read:" + (offset + length), ERROR_INDEX_OUT_OF_BOUNDS);
            }
            byte[] content = new byte[(int)length];
            FileInputStream in = new FileInputStream(file);
            if (offset > 0L && (skipped = in.skip(offset)) != offset) {
                EXPathFile.error("Error skipping content at start of binary: " + skipped + " bytes skipped, but requested " + offset, ERROR_IO);
            }
            if ((bytes = in.read(content, 0, (int)length)) != content.length) {
                in.close();
                EXPathFile.error("Number of bytes read does not match file length", ERROR_IO);
            }
            in.close();
            return new Base64BinaryValue(content);
        }
        catch (IOException e) {
            EXPathFile.error("Failed to read file " + path, e, ERROR_IO);
            return null;
        }
    }

    public static void write(XPathContext context, One<StringValue> file, ZeroOrMore<Item<?>> contents) throws XPathException {
        EXPathFile.serialize(context, ((StringValue)file.head()).getStringValue(), false, contents, context.getConfiguration().obtainDefaultSerializationProperties());
    }

    public static void write(XPathContext context, One<StringValue> file, ZeroOrMore<Item<?>> contents, One<NodeInfo> params) throws XPathException {
        SerializationParamsHandler sph = new SerializationParamsHandler();
        sph.setSerializationParams((NodeInfo)params.head());
        SerializationProperties props = sph.getSerializationProperties();
        EXPathFile.serialize(context, ((StringValue)file.head()).getStringValue(), false, contents, props);
    }

    private static File checkWriteDestination(String path) throws XPathException {
        File file = EXPathFile.toFile(path);
        if (file.isDirectory()) {
            EXPathFile.error("Path " + path + " is a directory", ERROR_PATH_IS_DIRECTORY);
        }
        if (!file.getParentFile().exists()) {
            EXPathFile.error("Parent directory does not exist: " + path, ERROR_PATH_NOT_DIRECTORY);
        }
        return file;
    }

    public static void writeBinary(One<StringValue> path, One<Base64BinaryValue> contents) throws XPathException {
        try {
            File file = EXPathFile.checkWriteDestination(((StringValue)path.head()).getStringValue());
            FileOutputStream stream = new FileOutputStream(file);
            stream.write(((Base64BinaryValue)contents.head()).getBinaryValue());
            stream.close();
        }
        catch (IOException e) {
            EXPathFile.error("Failed to write to file " + path, e, ERROR_IO);
        }
    }

    public static void writeBinary(One<StringValue> path, One<Base64BinaryValue> contents, One<IntegerValue> offset) throws XPathException {
        try {
            byte[] data;
            File file = EXPathFile.checkWriteDestination(((StringValue)path.head()).getStringValue());
            long offset0 = ((IntegerValue)offset.head()).longValue();
            if (offset0 < 0L) {
                EXPathFile.error("Negative offset in binary write:" + offset, ERROR_INDEX_OUT_OF_BOUNDS);
            }
            int lb = ((Base64BinaryValue)contents.head()).getLengthInOctets();
            if (file.exists() && offset0 > 0L) {
                FileInputStream in;
                int bytes;
                long fileLength = file.length();
                if (offset0 > fileLength) {
                    EXPathFile.error("Offset exceeds file length in binary write:" + offset, ERROR_INDEX_OUT_OF_BOUNDS);
                }
                if ((long)(bytes = (in = new FileInputStream(file)).read(data = new byte[Math.max((int)fileLength, (int)offset0 + lb)])) != fileLength) {
                    in.close();
                    EXPathFile.error("Number of bytes read does not match file length", ERROR_IO);
                }
                in.close();
            } else {
                data = new byte[(int)offset0 + lb];
            }
            System.arraycopy(((Base64BinaryValue)contents.head()).getBinaryValue(), 0, data, (int)offset0, lb);
            FileOutputStream stream = new FileOutputStream(file);
            stream.write(data);
            stream.close();
        }
        catch (IOException e) {
            EXPathFile.error("Failed to write to file " + path, e, ERROR_IO);
        }
    }

    public static void writeText(One<StringValue> path, One<StringValue> contents) throws XPathException {
        EXPathFile.writeText(path, contents, UTF8);
    }

    public static void writeText(One<StringValue> path, One<StringValue> contents, One<StringValue> encoding) throws XPathException {
        File file = null;
        try {
            file = EXPathFile.checkWriteDestination(((StringValue)path.head()).getStringValue());
            FileOutputStream stream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, ((StringValue)encoding.head()).getStringValue());
            writer.write(((StringValue)contents.head()).getStringValue());
            ((Writer)writer).close();
        }
        catch (UnsupportedEncodingException e) {
            EXPathFile.error("Unsupported encoding " + encoding, ERROR_UNKNOWN_ENCODING);
        }
        catch (FileNotFoundException e) {
            EXPathFile.error("Failed to create file", e, ERROR_PATH_NOT_DIRECTORY);
        }
        catch (IOException e) {
            EXPathFile.error("Failed to write to file " + file.getAbsolutePath(), e, ERROR_IO);
        }
    }

    public static void writeTextLines(One<StringValue> path, ZeroOrMore<StringValue> contents) throws XPathException {
        EXPathFile.writeTextLines(path, contents, UTF8);
    }

    public static void writeTextLines(One<StringValue> path, ZeroOrMore<StringValue> contents, One<StringValue> encoding) throws XPathException {
        File file = null;
        try {
            file = EXPathFile.checkWriteDestination(((StringValue)path.head()).getStringValue());
            FileOutputStream stream = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, ((StringValue)encoding.head()).getStringValue());
            SequenceIterator ui = contents.iterate();
            Object i = ui.next();
            while (i != null) {
                writer.write(i.getStringValue() + NEWLINE);
                i = ui.next();
            }
            ((Writer)writer).close();
        }
        catch (UnsupportedEncodingException e) {
            EXPathFile.error("Unsupported encoding " + encoding, ERROR_UNKNOWN_ENCODING);
        }
        catch (FileNotFoundException e) {
            EXPathFile.error("Failed to create file", e, ERROR_PATH_NOT_DIRECTORY);
        }
        catch (IOException e) {
            EXPathFile.error("Failed to write to file " + file.getAbsolutePath(), e, ERROR_IO);
        }
    }

    public static One<StringValue> name(String path) throws XPathException {
        if (path.equals("/") || path.equals("")) {
            return One.string("");
        }
        File file = EXPathFile.toFile(path);
        return One.string(file.getName());
    }

    public static ZeroOrOne<StringValue> parent(String path) throws XPathException {
        String p = EXPathFile._parent(path);
        return new ZeroOrOne<StringValue>(p == null ? null : new StringValue(p));
    }

    public static String _parent(String path) throws XPathException {
        if (path.equals("/")) {
            return null;
        }
        File file = EXPathFile.toFile(path);
        try {
            File parent = new File(file.getParent());
            return parent.getCanonicalPath() + File.separatorChar;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ZeroOrMore<StringValue> children(One<StringValue> dir) throws XPathException {
        ArrayList<StringValue> result = new ArrayList<StringValue>();
        File fd = EXPathFile.toExistingDirectory(((StringValue)dir.head()).getStringValue());
        if (!fd.isDirectory()) {
            EXPathFile.error("File " + dir + " is not a directory", ERROR_PATH_NOT_DIRECTORY);
        }
        for (File file : fd.listFiles()) {
            result.add(new StringValue(file.getAbsolutePath() + (file.isDirectory() ? File.separator : "")));
        }
        return new ZeroOrMore<StringValue>(result);
    }

    public static One<StringValue> pathToNative(One<StringValue> path) throws XPathException {
        File file = EXPathFile.toFile(((StringValue)path.head()).getStringValue());
        try {
            if (!file.exists()) {
                EXPathFile.error("Path does not exist:" + file.getAbsolutePath(), ERROR_PATH_NOT_EXIST);
            }
            return One.string(file.getCanonicalPath());
        }
        catch (IOException e) {
            EXPathFile.error("Failed to get canonical path", e, ERROR_IO);
            return null;
        }
    }

    public static One<AnyURIValue> pathToUri(One<StringValue> path) throws XPathException {
        String filePath = ((StringValue)path.head()).getStringValue();
        URI uri = null;
        uri = File.separator.equals("\\") && (filePath.startsWith("\\\\") || filePath.startsWith("//")) ? new File(filePath).toPath().toUri() : EXPathFile.toFile(filePath).toURI().normalize();
        return new One<AnyURIValue>(new AnyURIValue(uri.toString()));
    }

    public static One<StringValue> resolvePath(One<StringValue> path) throws XPathException {
        File file = EXPathFile.toFile(((StringValue)path.head()).getStringValue());
        return One.string(file.getAbsolutePath() + (file.isDirectory() ? File.separator : ""));
    }

    public static One<StringValue> dirSeparator() {
        return One.string(File.separator);
    }

    public static One<StringValue> lineSeparator() {
        return One.string(NEWLINE);
    }

    public static One<StringValue> pathSeparator() {
        return One.string(File.pathSeparator);
    }

    public static One<StringValue> tempDir() {
        return One.string(System.getProperty("java.io.tmpdir"));
    }

    public static One<StringValue> currentDir() throws XPathException {
        File file = EXPathFile.toFile(".");
        return One.string(file.getAbsolutePath() + (file.isDirectory() ? File.separator : ""));
    }

    private static File toFile(String path) throws XPathException {
        try {
            File file = new File(path);
            if (file.isAbsolute()) {
                return file;
            }
            boolean maybeURI = path.startsWith("file:");
            if (maybeURI) {
                URI uri = new URI(path.replaceAll("\\\\", "/"));
                return new File(uri.getPath());
            }
            String dir = System.getProperty("expath.base.directory");
            if (dir != null) {
                return new File(dir, path).getCanonicalFile();
            }
            return file.getCanonicalFile();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new XPathException("URISyntax error in file path:" + path);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new XPathException("IO error in file path:" + path);
        }
    }

    private static File toExistingFile(String path) throws XPathException {
        File file = EXPathFile.toFile(path);
        if (!file.exists()) {
            EXPathFile.error("No file exists at " + path, ERROR_PATH_NOT_EXIST);
        }
        return file;
    }

    private static File toExistingDirectory(String path) throws XPathException {
        File file = EXPathFile.toFile(path);
        if (!file.exists()) {
            EXPathFile.error("No directory exists at " + path, ERROR_PATH_NOT_DIRECTORY);
        }
        return file;
    }

    public static void error(String message, String code) throws XPathException {
        XPathException e = new XPathException(message);
        e.setErrorCodeQName(new StructuredQName("file", "http://expath.org/ns/file", code));
        throw e;
    }

    public static void error(String message, Exception cause, String code) throws XPathException {
        XPathException e = new XPathException(message, cause);
        e.setErrorCodeQName(new StructuredQName("file", "http://expath.org/ns/file", code));
        throw e;
    }

    private static class TextFileLinesIterator
    extends TextLinesIterator {
        File file;
        String encoding;

        public TextFileLinesIterator(File file, String encoding) throws XPathException {
            this.encoding = encoding;
            this.file = file;
            this.reader = new LineNumberReader(EXPathFile.getInputStreamReader(file, encoding));
            this.uri = file.toURI();
            this.checker = new IntPredicate(){

                @Override
                public boolean test(int value) {
                    return XMLCharacterData.isValid11(value);
                }
            };
        }

        @Override
        public StringValue next() throws XPathException {
            StringValue result = null;
            try {
                result = super.next();
            }
            catch (XPathException e) {
                EXPathFile.error("Error in reading text lines", e, EXPathFile.ERROR_IO);
            }
            return result;
        }
    }
}

