/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config.pe;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import com.saxonica.config.ICULibrary;
import com.saxonica.config.pe.ICUNumbererEnUnhyphenated;
import com.saxonica.config.pe.ICUNumberer_de;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.number.AbstractNumberer;

public class ICUNumbererPE
extends AbstractNumberer {
    private static final String spelloutCardinalPattern = "%spellout-cardinal";
    private static final String spelloutOrdinalPattern = "%spellout-ordinal";
    private static final String spelloutNumberingPattern = "%spellout-numbering";
    private static final String numberOrdinalPattern = "%digits-ordinal";
    private String useCardinal;
    private String useOrdinal;
    private String useNumberOrdinal;
    private Map<String, String> ordinalParamIndex = new ConcurrentHashMap<String, String>();
    ArrayList<String> spelloutCardinalRulesets = new ArrayList();
    ArrayList<String> spelloutOrdinalRulesets = new ArrayList();
    ArrayList<String> spelloutNumberingRulesets = new ArrayList();
    ArrayList<String> numberOrdinalRulesets = new ArrayList();
    private Locale locale;
    private Locale defaultedLocale;
    private static final String DAY_FULL = "EEEE";
    private static final String DAY_SHORT = "EEE";
    private static final String DAY_NARROW = "EEEEE";
    private static final String DAY_SHORT2 = "EEEEEE";
    private static final String MONTH_FULL = "MMMM";
    private static final String MONTH_SHORT = "MMM";
    private static final String MONTH_NARROW = "MMMMM";
    private static String[] preferences = new String[]{"-verbose", "", "-native", "-neuter", "-feminine", "-masculine"};
    private static String[] formats = new String[]{"MMMM", "MMM", "MMMMM", "EEEE", "EEE", "EEEEE", "EEEEEE"};
    private RuleBasedNumberFormat rbnf = null;
    private RuleBasedNumberFormat rbnfNumber = null;
    private ThreadLocal<HashMap<String, SimpleDateFormat>> simpleDateFormats = new ThreadLocal();
    private static HashMap<String, String> schemeCodes = new HashMap();

    private synchronized DateFormat getDateFormat(String pattern) {
        SimpleDateFormat s;
        HashMap<String, Object> map = this.simpleDateFormats.get();
        if (map == null) {
            map = new HashMap();
            this.simpleDateFormats.set(map);
        }
        if ((s = map.get(pattern)) == null) {
            s = new SimpleDateFormat(pattern, this.locale);
            map.put(pattern, s);
        }
        return s;
    }

    public static synchronized ICUNumbererPE getNumberer(Locale locale, String privateUseExtension, Configuration config) {
        boolean sansHyphen;
        ICUNumbererPE n = new ICUNumbererPE();
        String[] extensions = privateUseExtension == null ? new String[]{} : privateUseExtension.split("-");
        ArrayList<String> extensionList = new ArrayList<String>(Arrays.asList(extensions));
        boolean withHyphen = extensionList.contains("hyphen");
        if (withHyphen) {
            extensionList.remove("hyphen");
        }
        if (sansHyphen = extensionList.contains("nohyphen")) {
            extensionList.remove("nohyphen");
        }
        String ext = String.join((CharSequence)"-", extensionList);
        if (locale.getLanguage().equals("en") && !withHyphen) {
            n = new ICUNumbererEnUnhyphenated();
        } else if (locale.getLanguage().equals("de")) {
            n = new ICUNumberer_de();
        }
        n.config(locale, ext, config);
        return n;
    }

    protected synchronized void config(Locale locale, String privateUseExtension, Configuration config) {
        String scheme;
        String n;
        String[] rules;
        this.rbnf = new RuleBasedNumberFormat(locale, 1);
        if (!this.rbnf.getLocale(ULocale.ACTUAL_LOCALE).getLanguage().equals(locale.getLanguage())) {
            this.defaultedLocale = locale = new Locale(config.getDefaultLanguage());
            this.rbnf = new RuleBasedNumberFormat(locale, 1);
        }
        this.rbnfNumber = new RuleBasedNumberFormat(locale, 2);
        this.locale = locale;
        for (String s : rules = this.rbnf.getRuleSetNames()) {
            if (s.startsWith(spelloutCardinalPattern)) {
                this.spelloutCardinalRulesets.add(s);
            }
            if (s.startsWith(spelloutOrdinalPattern)) {
                this.spelloutOrdinalRulesets.add(s);
                this.ordinalParamIndex.put(s, s);
            }
            if (!s.startsWith(spelloutNumberingPattern)) continue;
            this.spelloutNumberingRulesets.add(s);
        }
        for (String s : rules = this.rbnfNumber.getRuleSetNames()) {
            if (!s.startsWith(numberOrdinalPattern)) continue;
            this.numberOrdinalRulesets.add(s);
        }
        for (String p : preferences) {
            n = spelloutOrdinalPattern + p;
            if (!this.spelloutOrdinalRulesets.contains(n)) continue;
            this.useOrdinal = n;
            break;
        }
        if (this.useOrdinal == null && this.spelloutOrdinalRulesets.size() > 0) {
            this.useOrdinal = this.spelloutOrdinalRulesets.get(0);
        }
        for (String p : preferences) {
            n = spelloutCardinalPattern + p;
            if (!this.spelloutCardinalRulesets.contains(n)) continue;
            this.useCardinal = n;
            break;
        }
        if (this.useCardinal == null && this.spelloutCardinalRulesets.size() > 0) {
            this.useCardinal = this.spelloutCardinalRulesets.get(0);
        }
        for (String p : preferences) {
            n = numberOrdinalPattern + p;
            if (!this.numberOrdinalRulesets.contains(n)) continue;
            this.useNumberOrdinal = n;
            break;
        }
        if (this.useNumberOrdinal == null && this.numberOrdinalRulesets.size() > 0) {
            this.useNumberOrdinal = this.numberOrdinalRulesets.get(0);
        }
        if (this.useOrdinal == null) {
            this.useOrdinal = this.useCardinal;
        }
        if (!spelloutOrdinalPattern.equals(this.useOrdinal)) {
            // empty if block
        }
        if (privateUseExtension != null && (scheme = schemeCodes.get(privateUseExtension)) != null) {
            if (this.spelloutCardinalRulesets.contains(scheme) || this.spelloutOrdinalRulesets.contains(scheme) || this.spelloutNumberingRulesets.contains(scheme) || this.numberOrdinalRulesets.contains(scheme)) {
                this.setScheme(scheme);
            } else if (config.isTiming()) {
                config.getLogger().info("No ICU ruleset" + scheme + " for " + locale.getLanguage());
            }
        }
    }

    @Override
    public Locale defaultedLocale() {
        return this.defaultedLocale;
    }

    private void setScheme(String s) {
        this.useCardinal = s;
        this.useOrdinal = s;
    }

    public static String[] getLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        for (Locale l : RuleBasedCollator.getAvailableLocales()) {
            locales.add(ICULibrary.getLanguageTag(l) + ";" + l.getDisplayName());
        }
        return locales.toArray(new String[locales.size()]);
    }

    public static String[] getPreferences() {
        return preferences;
    }

    public static String[] availableSpelloutNumberings(String loc) {
        RuleBasedNumberFormat temp = new RuleBasedNumberFormat(new Locale(loc), 1);
        return temp.getRuleSetNames();
    }

    public static String[] availableOrdinalNumberings(String loc) {
        RuleBasedNumberFormat temp = new RuleBasedNumberFormat(new Locale(loc), 2);
        return temp.getRuleSetNames();
    }

    public static String realLocale(String loc) {
        RuleBasedNumberFormat temp = new RuleBasedNumberFormat(new Locale(loc), 1);
        return temp.getLocale(ULocale.ACTUAL_LOCALE).getLanguage();
    }

    public static String getICUVersion() {
        VersionInfo icu = VersionInfo.ICU_VERSION;
        return Integer.toString(icu.getMajor()) + "." + Integer.toString(icu.getMinor()) + "." + Integer.toString(icu.getMilli()) + "." + Integer.toString(icu.getMicro());
    }

    @Override
    public String ordinalSuffix(String ordinalParam, long number) {
        if (this.rbnfNumber != null) {
            String r = this.useNumberOrdinal != null ? this.rbnfNumber.format(number, this.useNumberOrdinal) : "";
            return r.replaceAll("^[,\\d]*\\d", "");
        }
        return "UNKNOWN";
    }

    @Override
    public String toWords(long number) {
        if (this.rbnf != null) {
            String s = this.useCardinal != null ? this.rbnf.format(number, this.useCardinal) : this.rbnf.format(number);
            return this.postProcess(s);
        }
        return null;
    }

    @Override
    public String toWords(long number, int wordCase) {
        return this.postProcess(this.wordCase(this.toWords(number), wordCase));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        if (this.rbnf != null) {
            String word;
            if (ordinalParam == null) {
                word = this.rbnf.format(number);
            } else {
                String rule = this.ordinalParamIndex.get(ordinalParam);
                if (rule == null) {
                    ICUNumbererPE iCUNumbererPE = this;
                    synchronized (iCUNumbererPE) {
                        if (ordinalParam.startsWith("-") && ordinalParam.length() >= 2) {
                            String suffix = ordinalParam.substring(1);
                            for (String ruleSet : this.spelloutOrdinalRulesets) {
                                String two = this.rbnf.format(2L, ruleSet);
                                if (!two.endsWith(suffix)) continue;
                                rule = ruleSet;
                                this.ordinalParamIndex.put(ordinalParam, rule);
                                break;
                            }
                        } else if (ordinalParam.startsWith("2=") && ordinalParam.length() >= 3) {
                            for (String ruleSet : this.spelloutOrdinalRulesets) {
                                String required = ordinalParam.substring(2);
                                String two = this.rbnf.format(2L, ruleSet);
                                if (!two.equalsIgnoreCase(required)) continue;
                                rule = ruleSet;
                                this.ordinalParamIndex.put(ordinalParam, rule);
                                break;
                            }
                        }
                    }
                }
                if (rule == null) {
                    rule = this.useOrdinal;
                }
                word = this.rbnf.format(number, rule);
            }
            return this.postProcessOrdinal(this.postProcess(this.wordCase(word, wordCase)), ordinalParam);
        }
        return null;
    }

    public String postProcess(String result) {
        return result;
    }

    public String postProcessOrdinal(String result, String ordinalParam) {
        return result;
    }

    private String wordCase(String s, int wordCase) {
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        if (wordCase == 2) {
            if (s.length() > 1 && Character.isUpperCase(s.charAt(0)) && Character.isLowerCase(s.charAt(1))) {
                return s;
            }
            String result = "";
            boolean precedingLetter = false;
            for (char c : s.toCharArray()) {
                boolean isLetter = Character.isLetter(c);
                result = result + (isLetter ? (precedingLetter ? Character.toLowerCase(c) : Character.toUpperCase(c)) : c);
                precedingLetter = isLetter;
            }
            String lang = this.locale.getLanguage();
            if (lang.equals("en")) {
                result = result.replaceAll("And", "and");
            } else if (lang.equals("de")) {
                result = result.replaceAll("Und", "und");
            } else if (lang.equals("nl")) {
                result = result.replaceAll("\u00c3\u2039n", "\u00c3\u00abn");
            } else if (lang.equals("af")) {
                result = result.replaceAll("En", "en");
            } else if (lang.equals("da") || lang.equals("fo") || lang.equals("is") || lang.equals("nb") || lang.equals("nn")) {
                result = result.replaceAll("Og", "og");
            } else if (lang.equals("ga")) {
                result = result.replaceAll("A ", "a ");
            } else if (lang.equals("hr") || lang.equals("ca")) {
                result = result.replaceAll("I", "i");
            } else if (lang.equals("bg") || lang.equals("mk") || lang.equals("sr")) {
                result = result.replaceAll("\u00d0\u02dc ", "\u00d0\u00b8 ");
            } else if (lang.equals("mt")) {
                result = result.replaceAll("U", "u");
            } else if (lang.equals("pt") || lang.equals("sq")) {
                result = result.replaceAll("E", "e");
            } else if (lang.equals("ro")) {
                result = result.replaceAll("\u00c5\u017ei", "\u00c5\u0178i");
            } else if (lang.equals("ee")) {
                result = result.replaceAll("V\u00c9\u201d", "v\u00c9\u201d");
            } else if (lang.equals("fi")) {
                result = result.replaceAll("At", "at");
            }
            return result;
        }
        return s;
    }

    @Override
    public String monthName(int month, int minWidth, int maxWidth) {
        GregorianCalendar cal = new GregorianCalendar(this.locale);
        cal.set(1900, month - 1, 1);
        Date d = cal.getTime();
        String result = this.getDateFormat(MONTH_FULL).format(d);
        if (result.length() > maxWidth) {
            result = this.getDateFormat(MONTH_SHORT).format(d);
        }
        if (result.length() > maxWidth) {
            result = this.getDateFormat(MONTH_NARROW).format(d);
        }
        return this.wordCase(result, 2);
    }

    @Override
    public String dayName(int day, int minWidth, int maxWidth) {
        GregorianCalendar cal = new GregorianCalendar(this.locale);
        cal.set(1900, 0, day);
        Date d = cal.getTime();
        String result = this.getDateFormat(DAY_FULL).format(d);
        if (result.length() > maxWidth) {
            result = this.getDateFormat(DAY_SHORT).format(d);
        }
        if (result.length() > maxWidth) {
            result = this.getDateFormat(DAY_SHORT2).format(d);
        }
        if (result.length() > maxWidth) {
            result = this.getDateFormat(DAY_NARROW).format(d);
        }
        return this.wordCase(result, 2);
    }

    static {
        schemeCodes.put("do", numberOrdinalPattern);
        schemeCodes.put("dof", "%digits-ordinal-feminine");
        schemeCodes.put("dom", "%digits-ordinal-masculine");
        schemeCodes.put("doma", "%digits-ordinal-masculine-adjective");
        schemeCodes.put("don", "%digits-ordinal-neuter");
        schemeCodes.put("dor", "%digits-ordinal-reale");
        schemeCodes.put("sc", spelloutCardinalPattern);
        schemeCodes.put("sca", "%spellout-cardinal-alternate2");
        schemeCodes.put("scf", "%spellout-cardinal-feminine");
        schemeCodes.put("scfbc", "%spellout-cardinal-feminine-before-consonant");
        schemeCodes.put("scfi", "%spellout-cardinal-financial");
        schemeCodes.put("scm", "%spellout-cardinal-masculine");
        schemeCodes.put("scmbc", "%spellout-cardinal-masculine-before-consonant");
        schemeCodes.put("scn", "%spellout-cardinal-native");
        schemeCodes.put("scna", "%spellout-cardinal-native-attributive");
        schemeCodes.put("scne", "%spellout-cardinal-neuter");
        schemeCodes.put("scr", "%spellout-cardinal-reale");
        schemeCodes.put("scs", "%spellout-cardinal-sinokorean");
        schemeCodes.put("scv", "%spellout-cardinal-verbose");
        schemeCodes.put("sn", spelloutNumberingPattern);
        schemeCodes.put("snd", "%spellout-numbering-days");
        schemeCodes.put("snv", "%spellout-numbering-verbose");
        schemeCodes.put("sny", "%spellout-numbering-year");
        schemeCodes.put("so", spelloutOrdinalPattern);
        schemeCodes.put("sof", "%spellout-ordinal-feminine");
        schemeCodes.put("sofp", "%spellout-ordinal-feminine-plural");
        schemeCodes.put("som", "%spellout-ordinal-masculine");
        schemeCodes.put("soma", "%spellout-ordinal-masculine-adjective");
        schemeCodes.put("somp", "%spellout-ordinal-masculine-plural");
        schemeCodes.put("son", "%spellout-ordinal-native");
        schemeCodes.put("sonc", "%spellout-ordinal-native-count");
        schemeCodes.put("sone", "%spellout-ordinal-neuter");
        schemeCodes.put("sor", "%spellout-ordinal-reale");
        schemeCodes.put("sos", "%spellout-ordinal-sinokorean");
        schemeCodes.put("sosc", "%spellout-ordinal-sinokorean-count");
        schemeCodes.put("sov", "%spellout-ordinal-verbose");
    }
}

