/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.pe.ICUNumbererPE;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.lib.LocalizerFactory;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;

public class JavaLocalizerFactory
extends LocalizerFactory {
    private Configuration config;
    private HashMap<String, String> numbererClassNames = new HashMap(10);
    private HashMap<String, Numberer> numberers = new HashMap(10);

    public JavaLocalizerFactory(Configuration config) {
        this.config = config;
    }

    @Override
    public void setLanguageProperties(String lang, Properties properties) {
        String className = properties.getProperty("class");
        if (className != null) {
            this.setLocalizationClass(lang, className);
        }
    }

    public void setLocalizationClass(String language, String className) {
        this.numbererClassNames.put(language.toLowerCase(), className);
    }

    @Override
    public Numberer getNumberer(String language, String country) {
        String key;
        Numberer numberer;
        ConversionResult cr;
        if (language != null && (cr = StringConverter.StringToLanguage.INSTANCE.convertString(language)) instanceof ValidationFailure) {
            language = null;
        }
        if (language == null) {
            language = this.config.getDefaultLanguage();
        }
        if (country == null) {
            country = this.config.getDefaultCountry();
        }
        if ((numberer = this.numberers.get(key = (language + "|" + country).toLowerCase())) == null && Version.platform.hasICUNumberer() && this.config.isLicensedFeature(8)) {
            String[] parts = language.split("-x-");
            String[] langRegion = parts[0].split("-");
            String privateKeys = null;
            if (parts.length == 2) {
                privateKeys = parts[1];
            }
            String baseLang = langRegion[0].toLowerCase();
            Locale loc = langRegion.length == 2 ? new Locale(baseLang, langRegion[1].toUpperCase()) : new Locale(baseLang);
            numberer = ICUNumbererPE.getNumberer(loc, privateKeys, this.config);
            this.numberers.put(key, numberer);
        }
        if (numberer == null) {
            language = language.replaceAll("-x-.+$", "");
            String[] candidates = new String[]{language, this.config.getDefaultLanguage()};
            String className = null;
            block2: for (int i = 0; i < 2; ++i) {
                String lang = candidates[i].toLowerCase();
                while ((className = this.numbererClassNames.get(lang)) == null) {
                    if ("en".equals(lang)) {
                        className = "net.sf.saxon.expr.number.Numberer_en";
                        break block2;
                    }
                    int hyphen = lang.indexOf("-");
                    if (hyphen < 0) continue block2;
                    lang = lang.substring(0, hyphen);
                }
                break block2;
            }
            if (className == null) {
                className = "net.sf.saxon.expr.number.Numberer_en";
            }
            try {
                numberer = (Numberer)this.config.getInstance(className, null);
            }
            catch (XPathException err) {
                numberer = new Numberer_en();
            }
            numberer.setCountry(country);
            this.numberers.put(key, numberer);
        }
        return numberer;
    }

    @Override
    public JavaLocalizerFactory copy() {
        JavaLocalizerFactory f = new JavaLocalizerFactory(this.config);
        f.numbererClassNames = new HashMap<String, String>(this.numbererClassNames);
        f.numberers = new HashMap(10);
        return f;
    }
}

