/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.substitutor;

import ch.e2e.util.StringTools;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutor;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutorException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlPlaceholderSubstitutor
implements PlaceholderSubstitutor {
    private static final String YAML_SUFFIX = ".yaml";

    @Override
    public boolean canProcess(String filePath) {
        return filePath.endsWith(YAML_SUFFIX);
    }

    @Override
    public void applySubstitutions(Reader reader, Writer writer, Map<String, String> substitutions) throws PlaceholderSubstitutorException {
        Yaml yaml = new Yaml();
        Map deserializedYaml = (Map)yaml.load(reader);
        this.applySubstitutions(deserializedYaml, substitutions);
        String serializedYaml = yaml.dumpAsMap((Object)deserializedYaml);
        try {
            writer.write(serializedYaml);
        }
        catch (IOException e) {
            throw new PlaceholderSubstitutorException(e);
        }
    }

    private void applySubstitutions(Map<Object, Object> yamlAsMap, Map<String, String> substitutions) {
        for (Map.Entry<Object, Object> entry : yamlAsMap.entrySet()) {
            this.applySubstitutions(entry, substitutions);
        }
    }

    private void applySubstitutions(Map.Entry entry, Map<String, String> substitutions) {
        Object value = entry.getValue();
        if (value instanceof Map) {
            this.applySubstitutions((Map)value, substitutions);
        } else if (value instanceof String) {
            this.applySubstitutions((String)value, entry, substitutions);
        }
    }

    private void applySubstitutions(String value, Map.Entry entry, Map<String, String> substitutions) {
        String replacedValue = StringTools.replaceProperties((String)value, substitutions);
        if (!value.equals(replacedValue)) {
            entry.setValue(replacedValue);
        }
    }
}

