/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.depend;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.optional.depend.DependScanner;

public class ClassfileSet
extends FileSet {
    private Vector rootClasses = new Vector();
    private Vector rootFileSets = new Vector();

    public ClassfileSet() {
    }

    public void addRootFileset(FileSet rootFileSet) {
        this.rootFileSets.addElement(rootFileSet);
    }

    protected ClassfileSet(ClassfileSet s) {
        super(s);
        this.rootClasses = (Vector)s.rootClasses.clone();
    }

    public void setRootClass(String rootClass) {
        this.rootClasses.addElement(rootClass);
    }

    public DirectoryScanner getDirectoryScanner(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getDirectoryScanner(p);
        }
        Vector allRootClasses = (Vector)this.rootClasses.clone();
        Enumeration e = this.rootFileSets.elements();
        while (e.hasMoreElements()) {
            FileSet additionalRootSet = (FileSet)e.nextElement();
            DirectoryScanner additionalScanner = additionalRootSet.getDirectoryScanner(p);
            String[] files = additionalScanner.getIncludedFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    String classFilePath = files[i].substring(0, files[i].length() - 6);
                    String className = classFilePath.replace('/', '.').replace('\\', '.');
                    allRootClasses.addElement(className);
                }
                ++i;
            }
        }
        DirectoryScanner parentScanner = super.getDirectoryScanner(p);
        DependScanner scanner = new DependScanner(parentScanner);
        scanner.setBasedir(this.getDir(p));
        scanner.setRootClasses(allRootClasses);
        scanner.scan();
        return scanner;
    }

    public void addConfiguredRoot(ClassRoot root) {
        this.rootClasses.addElement(root.getClassname());
    }

    public Object clone() {
        if (this.isReference()) {
            return new ClassfileSet((ClassfileSet)this.getRef(this.getProject()));
        }
        return new ClassfileSet(this);
    }

    public static class ClassRoot {
        private String rootClass;

        public void setClassname(String name) {
            this.rootClass = name;
        }

        public String getClassname() {
            return this.rootClass;
        }
    }
}

