/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.starteam;

import com.starbase.starteam.BuildNumber;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.TypeNames;
import com.starbase.starteam.User;
import com.starbase.starteam.View;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class StarTeamTask
extends Task {
    private String userName;
    private String password;
    private String servername;
    private String serverport;
    private String projectname;
    private String viewname;
    private Server server = null;

    private void logStarteamVersion() {
        this.log("StarTeam version: " + BuildNumber.getDisplayString(), 3);
    }

    public final void setServername(String servername) {
        this.servername = servername;
    }

    public final String getServername() {
        return this.servername;
    }

    public final void setServerport(String serverport) {
        this.serverport = serverport;
    }

    public final String getServerport() {
        return this.serverport;
    }

    public final void setProjectname(String projectname) {
        this.projectname = projectname;
    }

    public final String getProjectname() {
        return this.projectname;
    }

    public final void setViewname(String viewname) {
        this.viewname = viewname;
    }

    public final String getViewname() {
        return this.viewname;
    }

    public final void setURL(String url) {
        String unpw;
        int pos;
        StringTokenizer t = new StringTokenizer(url, "/");
        if (t.hasMoreTokens() && (pos = (unpw = t.nextToken()).indexOf(":")) > 0) {
            this.servername = unpw.substring(0, pos);
            this.serverport = unpw.substring(pos + 1);
            if (t.hasMoreTokens()) {
                this.projectname = t.nextToken();
                if (t.hasMoreTokens()) {
                    this.viewname = t.nextToken();
                }
            }
        }
    }

    public final String getURL() {
        return this.servername + ":" + this.serverport + "/" + this.projectname + "/" + (null == this.viewname ? "" : this.viewname);
    }

    protected final String getViewURL() {
        return this.getUserName() + ":" + this.getPassword() + "@" + this.getURL();
    }

    public final void setUserName(String userName) {
        this.userName = userName;
    }

    public final String getUserName() {
        return this.userName;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final String getPassword() {
        return this.password;
    }

    protected final Server getServer() {
        return this.server;
    }

    protected final void disconnectFromServer() {
        if (null != this.server) {
            this.server.disconnect();
            this.log("successful disconnect from StarTeam Server " + this.servername, 3);
        }
    }

    protected final TypeNames getTypeNames() {
        return this.server.getTypeNames();
    }

    protected abstract View createSnapshotView(View var1) throws BuildException;

    protected View openView() throws BuildException {
        this.logStarteamVersion();
        View view = null;
        try {
            view = StarTeamFinder.openView((String)this.getViewURL());
        }
        catch (Exception e) {
            throw new BuildException("Failed to connect to " + this.getURL(), e);
        }
        if (null == view) {
            throw new BuildException("Cannot find view" + this.getURL() + " in repository()");
        }
        View snapshot = this.createSnapshotView(view);
        this.log("Connected to StarTeam view " + this.getURL(), 3);
        this.server = snapshot.getServer();
        return snapshot;
    }

    protected final String getUserName(int userID) {
        User u = this.server.getUser(userID);
        if (null == u) {
            return "";
        }
        return u.getName();
    }
}

