/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net;

import ch.e2e.builder.compiler.net.BridgeServiceCommandAction;
import ch.e2e.builder.compiler.net.VariableStore;
import ch.e2e.io.FileUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.test.CompareFile;
import ch.e2e.test.E2ETest;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.XMLCompare;
import ch.e2e.test.options.CompareFileOption;
import ch.e2e.test.options.FileOption;
import ch.e2e.test.options.IntegerOption;
import ch.e2e.test.options.Option;
import ch.e2e.test.options.StringOption;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceCommand
extends E2ETest {
    public static final String KEY_OPTION_HOST = "service.command.url.host";
    private static final String KEY_OPTION_LOGFILE = "service.command.logfile";
    private static final String KEY_OPTION_SERVICE = "service.command.service";
    private static final String KEY_OPTION_PROTOCOL = "service.command.url.protocol";
    private static final String KEY_OPTION_PORT = "service.command.url.port";
    private static final String KEY_OPTION_URL_PATH = "service.command.url.path";
    private static final String KEY_OPTION_METHOD = "service.command.method";
    private static final String KEY_OPTION_XPATH = "service.command.var.xpath";
    private static final String KEY_OPTION_VARIABLE_NAME = "service.command.var.name";
    private static final String KEY_OPTION_VARIABLE_STORE = "service.command.var.store";
    private static final String KEY_OPTION_REQUEST_FILE = "service.command.request.file";
    private static final String KEY_OPTION_HEADER_FILE = "service.command.header.file";

    public void doTest() throws Exception {
        String protocol = (String)((StringOption)this.getOption(KEY_OPTION_PROTOCOL)).getValue();
        if (protocol == null) {
            protocol = "http";
        }
        StringOption hostOption = (StringOption)this.getOption(KEY_OPTION_HOST);
        String host = (String)hostOption.getValue();
        IntegerOption portOption = (IntegerOption)this.getOption(KEY_OPTION_PORT);
        Integer port = (Integer)portOption.getValue();
        StringOption urlPathOption = (StringOption)this.getOption(KEY_OPTION_URL_PATH);
        String urlPath = (String)urlPathOption.getValue();
        FileOption requestOption = (FileOption)this.getOption(KEY_OPTION_REQUEST_FILE);
        File requestFile = (File)requestOption.getValue();
        FileOption varStoreOption = (FileOption)this.getOption(KEY_OPTION_VARIABLE_STORE);
        VariableStore variableStore = new VariableStore((File)varStoreOption.getValue());
        String method = (String)((StringOption)this.getOption(KEY_OPTION_METHOD)).getValue();
        if (method == null) {
            method = "POST";
        }
        File additionalHeadersFile = (File)((FileOption)this.getOption(KEY_OPTION_HEADER_FILE)).getValue();
        String request = null;
        if (requestFile != null) {
            StringWriter requestWriter = new StringWriter();
            FileUtilities.copy((Reader)new InputStreamReader((InputStream)new FileInputStream(requestFile), StandardCharsets.UTF_8), (Writer)requestWriter);
            request = variableStore.expandVariables(requestWriter.toString());
            String requestFilename = requestFile.getName();
            int lastPeriodPos = requestFilename.lastIndexOf(46);
            String headerFilename = lastPeriodPos <= 0 ? requestFilename : requestFilename.substring(0, lastPeriodPos);
            if (additionalHeadersFile == null) {
                additionalHeadersFile = new File(requestFile.getParent(), headerFilename + ".httpheader");
            }
        }
        Properties additionalHeaders = additionalHeadersFile != null && additionalHeadersFile.exists() ? new Properties(additionalHeadersFile) : new Properties();
        BridgeServiceCommandAction action = new BridgeServiceCommandAction();
        InputStream rawResult = action.configureService(method, protocol, host, port, urlPath, request, (Map)additionalHeaders);
        BufferedInputStream result = new BufferedInputStream(rawResult);
        result.mark(1000000);
        FileOption logfileOption = (FileOption)this.getOption(KEY_OPTION_LOGFILE);
        File logfile = logfileOption.getValue() == null ? (File)logfileOption.getDefaultValue() : (File)logfileOption.getValue();
        logfile.delete();
        logfile.getParentFile().mkdirs();
        ServiceCommand.copyWithoutClosingInput(result, new FileOutputStream(logfile));
        StringOption xPathOption = (StringOption)this.getOption(KEY_OPTION_XPATH);
        String xPathString = (String)xPathOption.getValue();
        StringOption variableNameOption = (StringOption)this.getOption(KEY_OPTION_VARIABLE_NAME);
        String variableName = (String)variableNameOption.getValue();
        result.reset();
        variableStore.extractVariableValue(xPathString, variableName, result);
    }

    public String getRecommendedCompareType() {
        return "XmlCompare";
    }

    public void setSourceFolder(File testFolder) {
        super.setTestFolder(testFolder);
    }

    public void setTestFolder(File testFolder) {
        super.setTestFolder(testFolder);
        FileOption logfile = (FileOption)this.getOptions().get(KEY_OPTION_LOGFILE);
        File defaultValue = new File(testFolder, "${service.command.service}/${service.command.url.host}.${key.option.test.name}.log");
        logfile.setDependencyString(defaultValue.getAbsolutePath());
        logfile.setDefaultValue((Object)defaultValue);
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                if (!(compare instanceof XMLCompare)) continue;
                CompareFileOption testFile = (CompareFileOption)compare.getOptions().get("xml.compare.test.file");
                testFile.setDependencyString("${service.command.logfile}");
                testFile.setDefaultValue((Object)new CompareFile(new File("${service.command.logfile}")));
            }
        }
    }

    public void setReferenceFolder(File referenceFolder) {
        super.setReferenceFolder(referenceFolder);
        if (this.getResult() != null) {
            for (ResultCompare compare : this.getResult().getResultCompares()) {
                if (!(compare instanceof XMLCompare)) continue;
                CompareFileOption referenceFile = (CompareFileOption)compare.getOptions().get("xml.compare.reference.file");
                File defaultValue = new File(referenceFolder, "${service.command.service}/${service.command.url.host}.${key.option.test.name}.log");
                referenceFile.setDependencyString(defaultValue.getAbsolutePath());
                referenceFile.setDefaultValue((Object)new CompareFile(defaultValue));
            }
        }
    }

    public void readSources(NodeList sources, boolean inherited) {
        int length = sources.getLength();
        for (int i = 0; i < length; ++i) {
            Option option;
            Element source = (Element)sources.item(i);
            String name = source.getAttribute("name");
            String valueStr = source.getAttribute("value");
            switch (name) {
                case "service.command.url.port": {
                    option = this.initializePort(valueStr);
                    break;
                }
                case "service.command.service": 
                case "instance": {
                    option = this.initializeStringOption(KEY_OPTION_SERVICE, valueStr);
                    break;
                }
                case "service.command.logfile": 
                case "logfile": {
                    option = this.initializeFileOption(KEY_OPTION_LOGFILE, valueStr);
                    break;
                }
                case "service.command.var.store": {
                    option = this.initializeFileOption(KEY_OPTION_VARIABLE_STORE, valueStr);
                    break;
                }
                case "service.command.request.file": {
                    option = this.initializeFileOption(KEY_OPTION_REQUEST_FILE, valueStr);
                    break;
                }
                default: {
                    option = this.initializeStringOption(name, valueStr);
                }
            }
            if (option == null) continue;
            option.setInherited(inherited);
        }
    }

    private Option initializeFileOption(String optionKey, String valueStr) {
        FileOption fileOption = (FileOption)this.getOption(optionKey);
        File value = fileOption.createValue(valueStr);
        fileOption.setValue((Object)value);
        return fileOption;
    }

    private Option initializeStringOption(String optionKey, String valueStr) {
        StringOption stringOption = (StringOption)this.getOption(optionKey);
        String value = stringOption.createValue(valueStr);
        stringOption.setValue((Object)value);
        return stringOption;
    }

    private Option initializePort(String valueStr) {
        IntegerOption portOption = (IntegerOption)this.getOption(KEY_OPTION_PORT);
        Integer value = portOption.createValue(valueStr);
        portOption.setValue((Object)value);
        return portOption;
    }

    protected void createOptions() {
        StringOption service = new StringOption("E2E Service", KEY_OPTION_SERVICE, "undefined", -200);
        service.setRequired(true);
        this.addOption(KEY_OPTION_SERVICE, (Option)service);
        int i = 0;
        StringOption protocol = new StringOption("Protocol", KEY_OPTION_PROTOCOL, "http", ++i);
        protocol.setRequired(true);
        this.addOption(KEY_OPTION_PROTOCOL, (Option)protocol);
        StringOption host = new StringOption("Host", KEY_OPTION_HOST, "localhost", ++i);
        host.setRequired(true);
        this.addOption(KEY_OPTION_HOST, (Option)host);
        IntegerOption port = new IntegerOption("Port", KEY_OPTION_PORT, Integer.valueOf(24700), ++i);
        port.setMaxValue(99999);
        port.setMinValue(1);
        port.setRequired(true);
        this.addOption(KEY_OPTION_PORT, (Option)port);
        StringOption urlPath = new StringOption("URL Path", KEY_OPTION_URL_PATH, null, ++i);
        urlPath.setRequired(false);
        this.addOption(KEY_OPTION_URL_PATH, (Option)urlPath);
        FileOption requestFile = new FileOption("Request File", KEY_OPTION_REQUEST_FILE, ++i);
        requestFile.addFileExtension("xml", "XML Request");
        this.addOption(KEY_OPTION_REQUEST_FILE, (Option)requestFile);
        FileOption headerFile = new FileOption("HTTP Header File", KEY_OPTION_HEADER_FILE, ++i);
        headerFile.addFileExtension("httpheader", "Property file with HTTP headers");
        this.addOption(KEY_OPTION_HEADER_FILE, (Option)headerFile);
        StringOption method = new StringOption("Method", KEY_OPTION_METHOD, "POST", ++i);
        method.setRequired(true);
        this.addOption(KEY_OPTION_METHOD, (Option)method);
        this.addOption(KEY_OPTION_VARIABLE_STORE, (Option)new FileOption("Variable Store", KEY_OPTION_VARIABLE_STORE, ++i));
        this.addOption(KEY_OPTION_VARIABLE_NAME, (Option)new StringOption("Variable name", KEY_OPTION_VARIABLE_NAME, ++i));
        this.addOption(KEY_OPTION_XPATH, (Option)new StringOption("Variable XPath Expression", KEY_OPTION_XPATH, ++i));
        FileOption logfile = new FileOption("Logfile", KEY_OPTION_LOGFILE, new File("${service.command.service}/${service.command.url.host}.${key.option.test.name}.log"), ++i);
        logfile.addDependency(KEY_OPTION_HOST);
        logfile.addDependency(KEY_OPTION_SERVICE);
        logfile.addDependency("key.option.test.name");
        logfile.setDependencyString("${service.command.service}/${service.command.url.host}.${key.option.test.name}.log");
        logfile.setRequired(true);
        logfile.addFileExtension("log", "Logfile");
        this.addOption(KEY_OPTION_LOGFILE, (Option)logfile);
    }

    public void prepareCompareType(ResultCompare compare) {
        if (compare instanceof XMLCompare) {
            CompareFileOption testFile = (CompareFileOption)compare.getOptions().get("xml.compare.test.file");
            testFile.addDependency(KEY_OPTION_LOGFILE);
            testFile.setDependencyString("${service.command.logfile}");
            testFile.setDefaultValue((Object)new CompareFile(new File("${service.command.logfile}")));
            CompareFileOption referenceFile = (CompareFileOption)compare.getOptions().get("xml.compare.reference.file");
            File defaultValue = new File(this.getReferenceFolder(), "${service.command.service}/${service.command.url.host}.${key.option.test.name}.log");
            referenceFile.addDependency(KEY_OPTION_HOST);
            referenceFile.addDependency(KEY_OPTION_SERVICE);
            referenceFile.addDependency("key.option.test.name");
            referenceFile.setDependencyString(defaultValue.getAbsolutePath());
            referenceFile.setDefaultValue((Object)new CompareFile(defaultValue));
            StringOption nameOption = (StringOption)compare.getOptions().get("key.option.result.compare.name");
            String defaultName = "Compare ${service.command.service} response.log";
            nameOption.addDependency(KEY_OPTION_SERVICE);
            nameOption.setDependencyString(defaultName);
            nameOption.setDefaultValue((Object)defaultName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyWithoutClosingInput(InputStream from, OutputStream to) throws IOException {
        byte[] buffer = new byte[10000];
        try {
            int amountRead;
            while ((amountRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, amountRead);
            }
        }
        finally {
            try {
                to.close();
            }
            catch (Exception exception) {}
        }
    }
}

