/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.test;

import ch.e2e.builder.compiler.build.DeployTest;
import ch.e2e.builder.compiler.build.test.BuildRepositoryCreateDialog;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.Properties;
import ch.e2e.swing.InputPasswordField;
import ch.e2e.swing.InputTextField;
import ch.e2e.swing.IntegerSpinner;
import ch.e2e.swing.ModalDialog;
import ch.e2e.swing.RegexTextField;
import ch.e2e.test.TypeFactory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class DeployRepositoryCreateDialog
extends ModalDialog {
    private static final Icon E2EBUILDER_LOGO = ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/test/images/Y-32x32.png", (boolean)true, (ClassLoader)BuildRepositoryCreateDialog.class.getClassLoader());
    private static DeployRepositoryCreateDialog dlg;
    private Frame owner;
    private RegexTextField repositoryField;
    private InputTextField hostField;
    private IntegerSpinner portField;
    private InputTextField userField;
    private InputPasswordField passwordField;
    private File lastFolderSelection;

    private DeployRepositoryCreateDialog(Frame owner) {
        super(owner, "Create a new Deploy Repository Test", "Create a new Deploy Repository Test", "", E2EBUILDER_LOGO, 3, false);
        this.owner = owner;
        String projectHome = System.getProperty("ch.e2e.builder.base.home");
        this.lastFolderSelection = new File(projectHome == null ? "" : projectHome);
        this.createGui();
    }

    public static DeployTest createTest(Frame owner) {
        if (dlg == null) {
            dlg = new DeployRepositoryCreateDialog(owner);
        }
        return dlg.create();
    }

    public DeployTest create() {
        this.setOkButtonEnabled(false);
        DeployTest result = null;
        if (this.showDialog() == 1) {
            try {
                result = (DeployTest)TypeFactory.getInstance().getType("DeployRepository").newInstance();
                result.setOption("repository.deploy.file", this.repositoryField.getText());
                if (!this.userField.getText().isEmpty()) {
                    result.setOption("repository.deploy.auth.user", this.userField.getText());
                }
                if (!String.valueOf(this.passwordField.getPassword()).isEmpty()) {
                    result.setOption("repository.deploy.auth.password", String.valueOf(this.passwordField.getPassword()));
                }
                if (!this.hostField.getText().isEmpty()) {
                    result.setOption("repository.deploy.url.host", this.hostField.getText());
                }
                if (this.portField.getContent() != null) {
                    result.setOption("repository.deploy.url.port", String.valueOf(this.portField.getContent()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void createGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridwidth = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(3, 11, 1, 7);
        JLabel repositoryLabel = new JLabel("Repository");
        this.add(repositoryLabel, c);
        Properties properties = new Properties("ch.e2e.swing.swing");
        this.repositoryField = new RegexTextField(properties.getString("absolutepath.pattern"));
        c.gridwidth = 1;
        c.insets = new Insets(2, 10, 5, 7);
        this.add((Component)this.repositoryField, c);
        this.repositoryField.addInputFieldListener(new InputFieldListener(){

            public void inputFieldChanged(InputFieldEvent e) {
                DeployRepositoryCreateDialog.this.inputChanged();
            }
        });
        this.repositoryField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String text = DeployRepositoryCreateDialog.this.userField.getText();
                return text.isEmpty() || new File(text).isFile();
            }
        });
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 5, 10);
        c.gridwidth = 0;
        JButton repositoryBrowseButton = new JButton("...");
        repositoryBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeployRepositoryCreateDialog.this.browseRepository();
            }
        });
        this.add(repositoryBrowseButton, c);
        JLabel hostLabel = new JLabel("Host");
        c.insets = new Insets(3, 11, 1, 7);
        c.weightx = 1.0;
        this.add(hostLabel, c);
        c.insets = new Insets(2, 10, 5, 7);
        this.hostField = new InputTextField("localhost");
        this.add((Component)this.hostField, c);
        JLabel portLabel = new JLabel("Port");
        c.insets = new Insets(3, 11, 1, 7);
        c.weightx = 1.0;
        this.add(portLabel, c);
        c.insets = new Insets(2, 10, 5, 7);
        SpinnerNumberModel inputModel = new SpinnerNumberModel(8080, 1000, 999999, 1);
        this.portField = new IntegerSpinner(inputModel);
        this.portField.setContent((Object)8080);
        this.add((Component)this.portField, c);
        JLabel nameLabel = new JLabel("User");
        c.insets = new Insets(3, 11, 1, 7);
        c.weightx = 1.0;
        this.add(nameLabel, c);
        c.insets = new Insets(2, 10, 5, 7);
        this.userField = new InputTextField();
        this.add((Component)this.userField, c);
        JLabel projectFolderLabel = new JLabel("Password");
        c.insets = new Insets(5, 11, 1, 7);
        this.add(projectFolderLabel, c);
        this.passwordField = new InputPasswordField();
        c.insets = new Insets(2, 10, 5, 7);
        this.add((Component)this.passwordField, c);
    }

    private void browseRepository() {
        JFileChooser fileChooser = new JFileChooser(this.lastFolderSelection);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("E2E Bridge Repository (*.rep)", "rep"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Java repository (*.jar)", "jar"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Node.js repository (*.zip)", "zip"));
        if (fileChooser.showOpenDialog(this.owner) == 0) {
            this.lastFolderSelection = fileChooser.getCurrentDirectory();
            this.repositoryField.setText(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void inputChanged() {
        this.setOkButtonEnabled(!this.repositoryField.getText().isEmpty());
    }
}

