/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;

public class ListSelectionLayout
implements LayoutManager2 {
    public static final String LEFT_LIST = "leftList";
    public static final String BUTTONS = "buttons";
    public static final String RIGHT_LIST = "rightList";
    private Component leftList;
    private Component rightList;
    private Component buttons;

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp.equals(this.buttons)) {
            this.buttons = null;
        } else if (comp.equals(this.rightList)) {
            this.rightList = null;
        } else if (comp.equals(this.leftList)) {
            this.leftList = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int height = 0;
        int width = 0;
        int listWidth = 0;
        if (this.buttons != null) {
            height = this.buttons.getPreferredSize().height;
            width = this.buttons.getPreferredSize().width;
        }
        if (this.leftList != null) {
            height = Math.max(height, this.leftList.getPreferredSize().height);
            listWidth = this.leftList.getPreferredSize().width;
        }
        if (this.rightList != null) {
            height = Math.max(height, this.rightList.getPreferredSize().height);
            listWidth = Math.max(listWidth, this.rightList.getPreferredSize().width);
        }
        return new Dimension(width + 2 * listWidth, height);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int height = 0;
        int width = 0;
        int listWidth = 0;
        if (this.buttons != null) {
            height = this.buttons.getMinimumSize().height;
            width = this.buttons.getMinimumSize().width;
        }
        if (this.leftList != null) {
            height = Math.max(height, this.leftList.getMinimumSize().height);
            listWidth = this.leftList.getMinimumSize().width;
        }
        if (this.rightList != null) {
            height = Math.max(height, this.rightList.getMinimumSize().height);
            listWidth = Math.max(listWidth, this.rightList.getMinimumSize().width);
        }
        return new Dimension(width + 2 * listWidth, height);
    }

    @Override
    public void layoutContainer(Container parent) {
        int width = parent.getSize().width;
        int height = parent.getSize().height;
        int buttonsWidth = this.buttons.getPreferredSize().width;
        int listWidth = (width - buttonsWidth) / 2 - (width - buttonsWidth) % 2;
        this.leftList.setBounds(0, 0, listWidth, height);
        buttonsWidth = width - 2 * listWidth;
        this.buttons.setBounds(listWidth, 0, buttonsWidth, height);
        this.rightList.setBounds(listWidth + buttonsWidth, 0, listWidth, height);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints.equals(LEFT_LIST)) {
            this.leftList = comp;
        } else if (constraints.equals(RIGHT_LIST)) {
            this.rightList = comp;
        } else if (constraints.equals(BUTTONS)) {
            this.buttons = comp;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        int height = 0;
        int width = 0;
        int listWidth = 0;
        if (this.buttons != null) {
            height = this.buttons.getMaximumSize().height;
            width = this.buttons.getMaximumSize().width;
        }
        if (this.leftList != null) {
            height = Math.max(height, this.leftList.getMaximumSize().height);
            listWidth = this.leftList.getMaximumSize().width;
        }
        if (this.rightList != null) {
            height = Math.max(height, this.rightList.getMaximumSize().height);
            listWidth = Math.max(listWidth, this.rightList.getMaximumSize().width);
        }
        return new Dimension(width + 2 * listWidth, height);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

