/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.session;

import ch.e2e.bridge.server.session.Session;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public enum SessionPool {
    INSTANCE;

    private final ConcurrentMap<String, Session> sessionMap = new ConcurrentHashMap<String, Session>();

    public static SessionPool getInstance() {
        return INSTANCE;
    }

    public Session createSession() {
        Session session;
        String sessionId = this.createSessionId();
        if (this.sessionMap.putIfAbsent(sessionId, session = new Session(sessionId)) != null) {
            throw new IllegalStateException("Duplicate session id " + sessionId);
        }
        return session;
    }

    public Session getSession(long nativeSession) {
        Session newSession;
        String key = Long.toString(nativeSession);
        Session session = (Session)this.sessionMap.get(key);
        if (session == null && (session = this.sessionMap.putIfAbsent(key, newSession = new Session(nativeSession))) == null) {
            session = newSession;
        }
        return session;
    }

    public void rollbackSession(String sessionId) {
        Session session = (Session)this.sessionMap.remove(sessionId);
        if (session != null) {
            session.rollback();
        }
    }

    public void commitSession(String sessionId) {
        Session session = (Session)this.sessionMap.remove(sessionId);
        if (session != null) {
            session.commit();
        }
    }

    public void rollbackSession(long nativeSession) {
        this.rollbackSession(Long.toString(nativeSession));
    }

    public void commitSession(long nativeSession) {
        this.commitSession(Long.toString(nativeSession));
    }

    private String createSessionId() {
        return UUID.randomUUID().toString();
    }
}

