/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.dataitem;

import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.dataitem.SimpleItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.io.FileUtilities;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;

public class BlobItem
extends SimpleItem {
    private static native long nativeCreate();

    private static native byte[] nativeGetContent(long var0);

    private static native void nativeSetContent(long var0, byte[] var2);

    private static native long nativeConvertToStringItem(long var0);

    BlobItem() {
        super(BlobItem.nativeCreate());
    }

    public BlobItem(long nativeItem) {
        super(nativeItem);
    }

    public void setValueFromByteArray(byte[] value) {
        BlobItem.nativeSetContent(this.getNativeItem(), value);
    }

    public StringItem convertToStringItem() {
        return new StringItem(BlobItem.nativeConvertToStringItem(this.getNativeItem()));
    }

    @Override
    public Byte[] getValueAsBytes() {
        byte[] bytes = BlobItem.nativeGetContent(this.getNativeItem());
        Byte[] result = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[i];
        }
        return result;
    }

    @Override
    public byte[] byteValues() {
        return BlobItem.nativeGetContent(this.getNativeItem());
    }

    @Override
    public InputStream getValueAsInputStream(Class inputStreamClass) {
        InputStream result;
        if (inputStreamClass.equals(InputStream.class)) {
            result = new BufferedInputStream(new ByteArrayInputStream(this.byteValues()));
        } else if (inputStreamClass.equals(ByteArrayInputStream.class)) {
            result = new ByteArrayInputStream(this.byteValues());
        } else if (InputStream.class.isAssignableFrom(inputStreamClass)) {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(this.byteValues());
            try {
                Constructor constructor = inputStreamClass.getConstructor(InputStream.class);
                result = (InputStream)constructor.newInstance(byteIn);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("Only InputStream constructors with one InputStream as parameter are supported.");
            }
            catch (Exception e) {
                throw new BridgeException("Exception when initializing " + inputStreamClass.getName(), e);
            }
        } else if (Reader.class.isAssignableFrom(inputStreamClass)) {
            StringItem stringItem = this.convertToStringItem();
            result = new ByteArrayInputStream(stringItem.getValueAsString().getBytes());
        } else {
            result = super.getValueAsInputStream(inputStreamClass);
        }
        return result;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof InputStream) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                if (((InputStream)value).markSupported()) {
                    ((InputStream)value).reset();
                }
                FileUtilities.copy((InputStream)((InputStream)value), (OutputStream)out);
                this.setValueFromByteArray(out.toByteArray());
            }
            catch (IOException e) {
                throw new BridgeException(String.format("Exception when copying from %s to %s", value.getClass().getName(), this.getClass().getName()), e);
            }
        } else if (value instanceof byte[]) {
            this.setValueFromByteArray((byte[])value);
        } else if (value instanceof Byte[]) {
            Byte[] values = (Byte[])value;
            byte[] bytes = new byte[values.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = values[i];
            }
            this.setValueFromByteArray(bytes);
        } else {
            super.setValue(value);
        }
    }
}

