/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.tools;

import ch.e2e.builder.trace.testcase.TestcaseTemplate;
import ch.e2e.dom.DomUtilities;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NamespacesManager {
    public static final String FILENAME = "namespaces.list";
    private static final String SOAP_NAMESPACE_PREFIX_EXPRESSION = "SOAPNamespacePrefix/text()";
    private static final String PREFIX = "ns";
    private int n = 0;
    private boolean changed = false;
    private final Map<String, String> builtinPrefix2uri = new HashMap<String, String>();
    private final Map<String, String> prefix2uri = new HashMap<String, String>();
    private final Map<String, String> uri2prefix = new HashMap<String, String>();
    private final TestcaseTemplate.SoapVersion soapVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespacesManager(File home, Element namespaces) {
        File file;
        this.soapVersion = namespaces != null && "soap12".equals(NamespacesManager.nodeValue(SOAP_NAMESPACE_PREFIX_EXPRESSION, namespaces)) ? TestcaseTemplate.SoapVersion.SOAP12 : TestcaseTemplate.SoapVersion.SOAP11;
        this.addBuiltinNamespaces();
        if (home != null && (file = NamespacesManager.namespacesFile(home)).canRead()) {
            try (XMLDecoder decoder = null;){
                decoder = new XMLDecoder(new FileInputStream(file));
                this.prefix2uri.putAll((Map)decoder.readObject());
                for (Map.Entry<String, String> entry : this.prefix2uri.entrySet()) {
                    this.uri2prefix.put(entry.getValue(), entry.getKey());
                }
            }
        }
    }

    public TestcaseTemplate.SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    public String getPrefix(String namespaceUri) {
        if (namespaceUri == null || namespaceUri.isEmpty()) {
            return null;
        }
        String prefix = this.uri2prefix.get(namespaceUri);
        if (prefix == null) {
            prefix = this.getUniquePrefix();
            this.addNamespace(prefix, namespaceUri);
        }
        return prefix;
    }

    public String getXmlnsPrefix(String namespaceUri) {
        return "xmlns:" + this.getPrefix(namespaceUri);
    }

    public String getSoapNamespaceUri() {
        return this.builtinPrefix2uri.get(this.getSoapNamespacePrefix());
    }

    public String getSoapEncodingNamespaceUri() {
        return this.builtinPrefix2uri.get(this.getSoapEncodingNamespacePrefix());
    }

    public String getSoapEnvelopeNamespaceUri() {
        return this.builtinPrefix2uri.get(this.getSoapEnvelopeNamespacePrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File home) {
        if (this.changed) {
            this.changed = false;
            try (XMLEncoder encoder = null;){
                encoder = new XMLEncoder(new FileOutputStream(NamespacesManager.namespacesFile(home)));
                encoder.writeObject(this.prefix2uri);
            }
        }
    }

    private static File namespacesFile(File home) {
        return new File(home, FILENAME);
    }

    private String getSoapNamespacePrefix() {
        return this.soapVersion == TestcaseTemplate.SoapVersion.SOAP12 ? "soap12" : "soap12";
    }

    private String getSoapEncodingNamespacePrefix() {
        return "soapenc";
    }

    private String getSoapEnvelopeNamespacePrefix() {
        return "env";
    }

    private String getUniquePrefix() {
        String prefix;
        while (this.prefix2uri.containsKey(prefix = PREFIX + this.n++)) {
        }
        return prefix;
    }

    private void addNamespace(String prefix, String namespaceUri) {
        this.changed = true;
        this.prefix2uri.put(prefix, namespaceUri);
        this.uri2prefix.put(namespaceUri, prefix);
    }

    private void addBuiltinNamespaces() {
        this.uri2prefix.put("http://e2e.ch/bridge", "bridge");
        this.builtinPrefix2uri.put("bridge", "http://e2e.ch/bridge");
        this.uri2prefix.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        this.builtinPrefix2uri.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.uri2prefix.put("http://schema.omg.org/spec/XMI/2.1", "xmi");
        this.builtinPrefix2uri.put("xmi", "http://schema.omg.org/spec/XMI/2.1");
        this.uri2prefix.put("http://www.w3.org/2001/XMLSchema", "xsd");
        this.builtinPrefix2uri.put("xsd", "http://www.w3.org/2001/XMLSchema");
        this.uri2prefix.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        this.builtinPrefix2uri.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        switch (this.soapVersion) {
            case SOAP11: {
                this.uri2prefix.put("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
                this.builtinPrefix2uri.put("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
                this.uri2prefix.put("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
                this.builtinPrefix2uri.put("soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
                this.uri2prefix.put("http://schemas.xmlsoap.org/soap/envelope/", "env");
                this.builtinPrefix2uri.put("env", "http://schemas.xmlsoap.org/soap/envelope/");
                break;
            }
            case SOAP12: {
                this.uri2prefix.put("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
                this.builtinPrefix2uri.put("soap12", "http://schemas.xmlsoap.org/wsdl/soap12/");
                this.uri2prefix.put("http://www.w3.org/2003/05/soap-encoding", "soapenc");
                this.builtinPrefix2uri.put("soapenc", "http://www.w3.org/2003/05/soap-encoding");
                this.uri2prefix.put("http://www.w3.org/2003/05/soap-envelope", "env");
                this.builtinPrefix2uri.put("env", "http://www.w3.org/2003/05/soap-envelope");
            }
        }
    }

    private static String nodeValue(String expression, Node node) {
        try {
            return ((Node)DomUtilities.newXPath().evaluate(expression, node, XPathConstants.NODE)).getNodeValue();
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }
}

