/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.DataContainer;
import ch.e2e.builder.trace.testcase.uml.Flow;
import ch.e2e.builder.trace.testcase.uml.GenericFlow;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import java.io.File;
import org.w3c.dom.Element;

public abstract class Processor
extends Flow {
    private Flow realFlow;

    public Processor(Element element, File documentFolder) {
        super(element.getAttribute("name"));
        this.realFlow = new GenericFlow(element, documentFolder);
    }

    public Processor(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
    }

    public Flow getRealFlow() {
        return this.realFlow;
    }

    @Override
    public boolean isLeaf() {
        return this.realFlow.isLeaf();
    }

    @Override
    public String getName() {
        return this.realFlow.getName();
    }

    @Override
    public int getChildCount() {
        return this.realFlow.getChildCount();
    }

    @Override
    public Object getChild(int index) {
        return this.realFlow.getChild(index);
    }

    @Override
    public DataContainer getInput() {
        return this.realFlow.getInput();
    }

    @Override
    public DataContainer getOutput() {
        return this.realFlow.getOutput();
    }

    @Override
    public long getRuntime() {
        return this.realFlow.getRuntime();
    }

    public boolean yieldsError() {
        return Boolean.parseBoolean(this.realFlow.getAttribute("error"));
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        if (child.getNodeName().equals("genericFlow")) {
            this.realFlow = new GenericFlow(child, traceContainer, false);
            traceContainer.addIterationElement(this, child);
        } else {
            super.addChild(child, traceContainer);
        }
    }

    @Override
    public UmlObject findChild(String originalName) {
        return this.realFlow.findChild(originalName);
    }

    @Override
    void setParent(UmlObject parent) {
        super.setParent(parent);
        this.realFlow.setParent(parent);
    }
}

