/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.uml;

import ch.e2e.builder.trace.testcase.response.TraceContainer;
import ch.e2e.builder.trace.testcase.uml.Data;
import ch.e2e.builder.trace.testcase.uml.DataContainer;
import ch.e2e.builder.trace.testcase.uml.Input;
import ch.e2e.builder.trace.testcase.uml.InputPin;
import ch.e2e.builder.trace.testcase.uml.Output;
import ch.e2e.builder.trace.testcase.uml.OutputPin;
import ch.e2e.builder.trace.testcase.uml.Pin;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.builder.trace.testcase.uml.ValuePin;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

public abstract class IOUmlObject
extends UmlObject {
    private long startTime;
    private long stopTime;
    private DataContainer input;
    private DataContainer output;
    private List<InputPin> inputPins;
    private List<OutputPin> outputPins;
    private List<ValuePin> valuePins;
    private List<Element> adapterIOs;

    public IOUmlObject(String name) {
        super(name);
    }

    public IOUmlObject(Element element, File documentFolder) {
        super(element, documentFolder);
    }

    public IOUmlObject(Element element, TraceContainer traceContainer) {
        super(element, traceContainer);
        element.setAttribute("runtime", String.valueOf(this.stopTime - this.startTime + "ms"));
    }

    public DataContainer getInput() {
        return this.input;
    }

    protected void setInput(DataContainer input) {
        this.input = input;
    }

    public DataContainer getOutput() {
        return this.output;
    }

    protected void setOutput(DataContainer output) {
        this.output = output;
    }

    public List<InputPin> getInputPins() {
        if (this.inputPins == null) {
            this.inputPins = this.getPins(InputPin.class);
            for (InputPin pin : this.inputPins) {
                Data data = (Data)this.getInput().findChild(pin.getName());
                if (data == null) continue;
                pin.setInternalIOKey(data.getValue());
            }
        }
        return this.inputPins;
    }

    public List<OutputPin> getOutputPins() {
        if (this.outputPins == null) {
            this.outputPins = this.getPins(OutputPin.class);
            for (OutputPin pin : this.outputPins) {
                Data data = (Data)this.getOutput().findChild(pin.getName());
                if (data == null) continue;
                pin.setInternalIOKey(data.getValue());
            }
        }
        return this.outputPins;
    }

    public List<ValuePin> getValuePins() {
        if (this.valuePins == null) {
            this.valuePins = this.getPins(ValuePin.class);
            for (ValuePin pin : this.valuePins) {
                Data data = (Data)this.getInput().findChild(pin.getName());
                if (data == null) continue;
                pin.setInternalIOKey(data.getValue());
            }
        }
        return this.valuePins;
    }

    private <T extends Pin> List<T> getPins(Class<T> type) {
        ArrayList<T> pins;
        if (this.parent != null) {
            int nChildren = this.parent.getChildCount();
            pins = nChildren == 0 ? Collections.emptyList() : new ArrayList<T>();
            for (int i = 0; i < nChildren; ++i) {
                Object child = this.parent.getChild(i);
                if (!type.isInstance(child)) continue;
                pins.add(type.cast(child));
            }
        } else {
            pins = Collections.emptyList();
        }
        return pins;
    }

    public long getRuntime() {
        return this.stopTime - this.startTime;
    }

    @Override
    public Object getChild(int index) {
        Object result;
        switch (index) {
            case 0: {
                if (this.input != null && this.input.getChildCount() > 0) {
                    result = this.input;
                    break;
                }
                if (this.output != null && this.output.getChildCount() > 0) {
                    result = this.output;
                    break;
                }
                result = super.getChild(this.getChildIndex(index));
                break;
            }
            case 1: {
                if (this.input != null && this.input.getChildCount() > 0 && this.output != null && this.output.getChildCount() > 0) {
                    result = this.output;
                    break;
                }
                result = super.getChild(this.getChildIndex(index));
                break;
            }
            default: {
                result = super.getChild(this.getChildIndex(index));
            }
        }
        return result;
    }

    private int getChildIndex(int index) {
        if (this.input != null && this.input.getChildCount() > 0) {
            --index;
        }
        if (this.output != null && this.output.getChildCount() > 0) {
            --index;
        }
        return index;
    }

    @Override
    public int getChildCount() {
        int childCount = super.getChildCount();
        if (this.input != null && this.input.getChildCount() > 0) {
            ++childCount;
        }
        if (this.output != null && this.output.getChildCount() > 0) {
            ++childCount;
        }
        return childCount;
    }

    @Override
    void read(Element element, File documentFolder) {
        this.adapterIOs = new ArrayList<Element>();
        super.read(element, documentFolder);
        for (Element adapterIO : this.adapterIOs) {
            super.addChild(adapterIO, documentFolder);
        }
        this.adapterIOs.clear();
    }

    @Override
    void read(Element element, TraceContainer traceContainer) {
        this.adapterIOs = new ArrayList<Element>();
        super.read(element, traceContainer);
        for (Element adapterIO : this.adapterIOs) {
            super.addChild(adapterIO, traceContainer);
        }
        this.adapterIOs.clear();
    }

    @Override
    protected void addChild(Element child, File documentFolder) {
        String nodeName = child.getNodeName();
        if (nodeName.equals("startTime")) {
            this.startTime = Long.parseLong(child.getAttribute("value"));
        } else if (nodeName.equals("stopTime")) {
            this.stopTime = Long.parseLong(child.getAttribute("value"));
        } else if (nodeName.equals("input")) {
            this.input = new Input(this, child);
        } else if (nodeName.equals("output")) {
            this.output = new Output(this, child);
        } else if (nodeName.equals("adapterIO")) {
            this.adapterIOs.add(child);
        } else {
            super.addChild(child, documentFolder);
        }
    }

    @Override
    protected void addChild(Element child, TraceContainer traceContainer) {
        String nodeName = child.getNodeName();
        if (nodeName.equals("startTime")) {
            this.startTime = Long.parseLong(child.getAttribute("value"));
        } else if (nodeName.equals("stopTime")) {
            this.stopTime = Long.parseLong(child.getAttribute("value"));
        } else if (nodeName.equals("input")) {
            this.input = new Input(this, child, traceContainer);
        } else if (nodeName.equals("output")) {
            this.output = new Output(this, child, traceContainer);
        } else if (nodeName.equals("adapterIO")) {
            this.adapterIOs.add(child);
        } else {
            this.ioObjectAddChild(child, traceContainer);
        }
    }

    protected void ioObjectAddChild(Element child, TraceContainer traceContainer) {
        super.addChild(child, traceContainer);
    }
}

