/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.parameter.SimpleTypeParameter;
import ch.e2e.io.Base64Tools;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;

public class ParameterTransferHandler
extends TransferHandler {
    public static final DataFlavor blobFlavor = new DataFlavor("application/binary;class=\"[B\"", "blob");
    public static final DataFlavor base64Flavor = new DataFlavor("application/base64;class=" + String.class.getName(), "base64 encoded blob");
    private JTextComponent source;
    private Position p0;
    private Position p1;
    boolean shouldRemove;
    private TestcaseParameter parameter;

    public ParameterTransferHandler(SimpleTypeParameter parameter) {
        this.parameter = parameter;
    }

    public ParameterTransferHandler() {
    }

    public void setParameter(TestcaseParameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] transferFlavors) {
        return !(!(c instanceof JTree) && !(c instanceof JTextComponent) || !this.hasStringFlavour(transferFlavors) && !this.hasFileFlavour(transferFlavors) && !this.hasBlobFlavour(transferFlavors) && !this.hasBase64Flavour(transferFlavors));
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        boolean imported = false;
        try {
            if (this.parameter != null) {
                imported = this.parameter.importData(t);
            } else if (c instanceof JTree) {
                Object obj;
                TreePath path = ((JTree)c).getSelectionPath();
                if (path != null && ((JTree)c).getSelectionCount() == 1 && (obj = path.getLastPathComponent()) instanceof TestcaseParameter) {
                    imported = ((TestcaseParameter)obj).importData(t);
                }
            } else if (c instanceof JTextComponent) {
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    JTextComponent textComp = (JTextComponent)c;
                    List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (files.size() == 1) {
                        DataInputStream input = new DataInputStream(new FileInputStream((File)files.get(0)));
                        byte[] data = new byte[input.available()];
                        input.readFully(data);
                        input.close();
                        textComp.replaceSelection(new String(data));
                    }
                    imported = true;
                } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    JTextComponent textComp = (JTextComponent)c;
                    if (textComp.equals(this.source) && textComp.getCaretPosition() >= this.p0.getOffset() && textComp.getCaretPosition() <= this.p1.getOffset()) {
                        this.shouldRemove = false;
                    } else {
                        String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                        textComp.replaceSelection(s);
                    }
                    imported = true;
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            System.out.println("importData: unsupported data flavor");
        }
        catch (IOException e) {
            System.out.println("importData: I/O exception");
        }
        return imported;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        Transferable t = null;
        if (this.parameter != null) {
            t = this.parameter.createTransferable();
        } else if (c instanceof JTree) {
            Object obj;
            TreePath path = ((JTree)c).getSelectionPath();
            if (path != null && ((JTree)c).getSelectionCount() == 1 && (obj = path.getLastPathComponent()) instanceof TestcaseParameter) {
                t = ((TestcaseParameter)obj).createTransferable();
            }
        } else if (c instanceof JTextComponent) {
            this.source = (JTextComponent)c;
            Document doc = this.source.getDocument();
            int start = this.source.getSelectionStart();
            int end = this.source.getSelectionEnd();
            String text = this.source.getSelectedText();
            if (start != end) {
                try {
                    this.p0 = doc.createPosition(start);
                    this.p1 = doc.createPosition(end);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.shouldRemove = true;
            if (text != null && text.length() > 0) {
                t = new StringSelection(text);
            }
        }
        return t;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (c instanceof JTextComponent && this.shouldRemove && action == 2 && this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
            JTextComponent textComp = (JTextComponent)c;
            try {
                textComp.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.source = null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return c instanceof JTextComponent ? 3 : 1;
    }

    private boolean hasBlobFlavour(DataFlavor[] transferFlavors) {
        return Arrays.asList(transferFlavors).contains(blobFlavor);
    }

    private boolean hasBase64Flavour(DataFlavor[] transferFlavors) {
        return Arrays.asList(transferFlavors).contains(base64Flavor);
    }

    private boolean hasStringFlavour(DataFlavor[] transferFlavors) {
        return Arrays.asList(transferFlavors).contains(DataFlavor.stringFlavor);
    }

    private boolean hasFileFlavour(DataFlavor[] transferFlavors) {
        return Arrays.asList(transferFlavors).contains(DataFlavor.javaFileListFlavor);
    }

    public static class BlobTransferable
    implements Transferable,
    ClipboardOwner {
        private static final DataFlavor[] flavors = new DataFlavor[]{blobFlavor, base64Flavor, DataFlavor.stringFlavor};
        private byte[] data;

        public BlobTransferable(String base64Data) {
            this(base64Data, true);
        }

        public BlobTransferable(String data, boolean base64Encoded) {
            try {
                this.data = base64Encoded ? Base64Tools.decodeToBytes((String)data) : data.getBytes(Charset.defaultCharset().name());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        public BlobTransferable(byte[] data) {
            this.data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return (DataFlavor[])flavors.clone();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return Arrays.asList(flavors).contains(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (blobFlavor.equals(flavor)) {
                return this.data;
            }
            if (base64Flavor.equals(flavor)) {
                return Base64Tools.encodeToStringChunked((byte[])this.data);
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return new String(this.data);
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

