/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.parameter.ArrayParameter;
import ch.e2e.builder.trace.testcase.parameter.BigDecimalParameter;
import ch.e2e.builder.trace.testcase.parameter.BigIntegerParameter;
import ch.e2e.builder.trace.testcase.parameter.BlobParameter;
import ch.e2e.builder.trace.testcase.parameter.BooleanParameter;
import ch.e2e.builder.trace.testcase.parameter.ComplexParameter;
import ch.e2e.builder.trace.testcase.parameter.DateTimeParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import ch.e2e.builder.trace.testcase.parameter.RecordParameter;
import ch.e2e.builder.trace.testcase.parameter.SimpleTypeParameter;
import ch.e2e.builder.trace.testcase.parameter.StringParameter;
import ch.e2e.dom.DomUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterFactory {
    private ParameterFactory() {
    }

    public static TestcaseParameter createParameter(Element parameterElement, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        Parameter result = null;
        int type = ParameterFactory.mapType(parameterElement.getAttribute("type"));
        switch (type) {
            case 10004: {
                result = new ArrayParameter(parameterElement, type, parent, definitionHolder);
                break;
            }
            case 10005: {
                result = new BlobParameter(parameterElement, type, arrayItem, parent, definitionHolder);
                break;
            }
            case 10006: {
                result = new BooleanParameter(parameterElement, arrayItem, type, parent, definitionHolder);
                break;
            }
            case 10010: {
                result = new DateTimeParameter(parameterElement, type, arrayItem, parent, definitionHolder);
                break;
            }
            case 10011: {
                result = new BigDecimalParameter(parameterElement, type, arrayItem, parent, definitionHolder);
                break;
            }
            case 10014: {
                result = new BigIntegerParameter(parameterElement, type, arrayItem, parent, definitionHolder);
                break;
            }
            case 10019: {
                result = new StringParameter(parameterElement, arrayItem, type, parent, definitionHolder);
                break;
            }
            case 10009: {
                result = new ComplexParameter(parameterElement, type, arrayItem, parent, definitionHolder);
            }
        }
        return result;
    }

    public static TestcaseParameter createParameter(Element parameterElement, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        TestcaseParameter result = null;
        if (namespaceAware) {
            int type = ParameterFactory.mapType(parameterElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type"));
            switch (type) {
                case 10004: {
                    result = new ArrayParameter(parameterElement, type, parent, definitionHolder, true);
                    break;
                }
                case 10005: {
                    result = new BlobParameter(parameterElement, type, arrayItem, parent, definitionHolder, true);
                    break;
                }
                case 10006: {
                    result = new BooleanParameter(parameterElement, type, arrayItem, parent, definitionHolder, true);
                    break;
                }
                case 10010: {
                    result = new DateTimeParameter(parameterElement, type, arrayItem, parent, definitionHolder, true);
                    break;
                }
                case 10011: {
                    result = new BigDecimalParameter(parameterElement, type, arrayItem, parent, definitionHolder, true);
                    break;
                }
                case 10014: {
                    result = new BigIntegerParameter(parameterElement, type, arrayItem, parent, definitionHolder, true);
                    break;
                }
                case 10019: {
                    result = new StringParameter(parameterElement, type, arrayItem, parent, definitionHolder, true);
                    break;
                }
                case 10009: {
                    result = new ComplexParameter(parameterElement, type, arrayItem, parent, definitionHolder, true);
                }
            }
        } else {
            result = ParameterFactory.createParameter(parameterElement, arrayItem, parent, definitionHolder);
        }
        return result;
    }

    public static void createParameter(NodeList children, Collection items, Collection<String> names, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        Iterator elements = DomUtilities.elementIterator((NodeList)children);
        while (elements.hasNext()) {
            TestcaseParameter newParameter = ParameterFactory.createParameter((Element)elements.next(), arrayItem, parent, definitionHolder);
            items.add(newParameter);
            names.add(newParameter.getName());
        }
    }

    public static void createParameter(NodeList children, Collection items, Collection<String> names, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        Iterator elements = DomUtilities.elementIterator((NodeList)children);
        while (elements.hasNext()) {
            TestcaseParameter newParameter = ParameterFactory.createParameter((Element)elements.next(), arrayItem, parent, definitionHolder, namespaceAware);
            items.add(newParameter);
            names.add(newParameter.getName());
        }
    }

    public static void setupParameter(Element rootElement, Element element, Parameter parameter) {
        if (element.hasAttribute("href")) {
            ParameterFactory.resolveHref(rootElement, element);
        }
        if (parameter instanceof ComplexParameter) {
            ComplexParameter complexParameter = (ComplexParameter)parameter;
            complexParameter.create();
            Iterator children = DomUtilities.elementIterator((NodeList)element.getChildNodes());
            while (children.hasNext()) {
                Element child = (Element)children.next();
                ParameterFactory.setupParameter(rootElement, child, complexParameter.getParameter(child.getNodeName()));
            }
        } else if (parameter instanceof ArrayParameter) {
            ArrayParameter arrayParameter = (ArrayParameter)parameter;
            Iterator children = DomUtilities.elementIterator((NodeList)element.getChildNodes());
            int i = 0;
            while (children.hasNext()) {
                arrayParameter.addItem();
                ParameterFactory.setupParameter(rootElement, (Element)children.next(), (Parameter)arrayParameter.getChild(i));
                ++i;
            }
        } else if (parameter instanceof SimpleTypeParameter) {
            parameter.setValue(Boolean.parseBoolean(element.getAttribute("xsi:nil")) ? null : ((SimpleTypeParameter)parameter).createValue(element));
        }
    }

    private static void resolveHref(Element rootElement, Element element) {
        String href = element.getAttribute("href").substring(1);
        Element referrencedElement = ParameterFactory.findElement(rootElement.getChildNodes(), "id", href);
        ArrayList nodes = new ArrayList();
        Iterator children = DomUtilities.elementIterator((NodeList)referrencedElement.getChildNodes());
        while (children.hasNext()) {
            nodes.add(children.next());
        }
        for (Node node : nodes) {
            element.appendChild(node);
        }
    }

    private static Element findElement(NodeList nodes, String attributeName, String attributeValue) {
        Element element = null;
        Iterator elements = DomUtilities.elementIterator((NodeList)nodes);
        while (element == null && elements.hasNext()) {
            Element next = (Element)elements.next();
            if (!attributeValue.equals(next.getAttribute(attributeName))) continue;
            element = next;
        }
        return element;
    }

    public static void appendSOAPChilds(List children, Element request, Document document) {
        for (Object aChildren : children) {
            Parameter parameter = (Parameter)aChildren;
            if (parameter.isNull()) {
                if (!parameter.isArrayItem()) continue;
                request.appendChild(parameter.createEmptySOAPParameter(document));
                continue;
            }
            request.appendChild(parameter.createSOAPParameter(document));
        }
    }

    private static int mapType(String typeName) {
        int type = typeName.equals("Base Types.Array") ? 10004 : (typeName.equals("Base Types.Blob") ? 10005 : (typeName.equals("Base Types.Boolean") ? 10006 : (typeName.equals("Base Types.DateTime") ? 10010 : (typeName.equals("Base Types.Float") ? 10011 : (typeName.equals("Base Types.Integer") ? 10014 : (typeName.equals("Base Types.String") ? 10019 : (typeName.endsWith("]") ? 10004 : 10009)))))));
        return type;
    }
}

