/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.importer;

import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.base.error.BuilderWarning;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.base.error.XSLTWarning;
import ch.e2e.builder.base.message.SendErrorEvent;
import ch.e2e.builder.base.message.SendFatalErrorEvent;
import ch.e2e.builder.base.message.SendWarningEvent;
import ch.e2e.builder.base.xsltinterface.XSLTInput;
import ch.e2e.builder.base.xsltinterface.XSLTOutput;
import ch.e2e.builder.trace.importer.Logging;
import ch.e2e.builder.trace.importer.WSDLImportTarget;
import ch.e2e.builder.trace.testcase.AbstractAsynchronousTestcaseRoot;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcaseRoot;
import ch.e2e.builder.trace.testcase.AbstractWSDLFolder;
import ch.e2e.builder.trace.testcase.TestcaseTemplate;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import ch.e2e.io.ZipUtilities;
import ch.e2e.transformer.TransformerLoadException;
import ch.e2e.transformer.TransformerLoader;
import ch.e2e.xuml.settings.Settings;
import ch.e2e.xuml.settings.SettingsException;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutor;
import ch.e2e.xuml.substitutor.PlaceholderSubstitutorException;
import ch.e2e.xuml.substitutor.XmlPlaceholderSubstitutor;
import ch.e2e.xuml.template.FileTemplate;
import ch.e2e.xuml.template.Template;
import ch.e2e.xuml.template.TemplateProcessingException;
import ch.e2e.xuml.template.TemplateProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLImport {
    public static final String WSDL_IMPORT_ERROR_REPOSITORY_NOT_VALID_MESSAGE = "wsdl.import.error.repository.not.valid.message";
    public static final String WSDL_IMPORT_ERROR_CAN_NOT_CREATE_DIRECTORY = "wsdl.import.error.can.not.create.directory";
    public static final String ASYNC_IMPORT_INFO_NO_ASYNCHRONOUS_ENTRY = "async.import.info.no.asynchronous.entry";
    public static final int MAX_NESTING_LEVEL_DEFAULT = 8;
    private static final String DEPLOYMENT_ENTRY = "deploy.xml";
    private static final String TEMPLATES_FOLDER_PATH = "templates/wsdl";
    private static final String WSDL_FOLDER_PATH = "wsdl";
    private static final String SCRIPT_NAME = "ch/e2e/builder/trace/xslt/wsdl2soap/wsdl2soap";
    private static final String WSDL_EXT = ".wsdl";
    private static final String xmlPath = System.getProperty("ch.e2e.builder.trace.xmlpath");
    private static final TransformerLoader transformerLoader = new TransformerLoader(xmlPath, WSDLImport.class.getClassLoader());
    private static Transformer transformer;

    private WSDLImport() {
    }

    public static void importWSDLFiles(ImportSource importSource, InputStream adapterTemplates, InputStream inspections, AbstractWSDLFolder container, boolean merge, int nestingLevel) throws TransformerException, IOException, XSLTErrorException {
        XSLTInput.setTracerWsdlImportNestingLevel((int)nestingLevel);
        XSLTOutput.setXsltAction(null);
        try {
            Document testcases = importSource.createTestcasesDocument();
            container.setTestcases(testcases, adapterTemplates, inspections, merge);
        }
        catch (XSLTErrorException e) {
            if (!merge) {
                try {
                    container.getParent().delete(container);
                }
                catch (FilesNotDeletedException e1) {
                    Logging.logger.severe(e1.getMessage());
                }
            }
            throw e;
        }
    }

    public static void importSyncFromRepository(File file, AbstractWSDLFolder wsdlFolder, boolean merge, int nestingLevel) throws IOException, ParserConfigurationException, SAXException, TransformerException, ImportError, XSLTErrorException, TemplateProcessingException, PlaceholderSubstitutorException, SettingsException {
        WSDLImport.importSyncFromRepository(file, wsdlFolder, merge, nestingLevel, null, Settings.createFromRepositoryWithChangedSettings((File)file));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void importSyncFromRepository(File file, AbstractWSDLFolder wsdlFolder, boolean merge, int nestingLevel, String host, Settings settings) throws IOException, ParserConfigurationException, SAXException, TransformerException, ImportError, XSLTErrorException, TemplateProcessingException, PlaceholderSubstitutorException {
        File tmpDir = null;
        try {
            try (ZipFile zipFile = new ZipFile(file);){
                tmpDir = new File(System.getProperty("java.io.tmpdir"), "repositoryImport_" + System.nanoTime());
                ZipUtilities.extract((ZipFile)zipFile, (String)TEMPLATES_FOLDER_PATH, (boolean)true, (File)tmpDir);
                ZipUtilities.extract((ZipFile)zipFile, (String)WSDL_FOLDER_PATH, (boolean)true, (File)tmpDir);
                InputStream stream = WSDLImport.getSubstitutedStream(zipFile.getInputStream(zipFile.getEntry(DEPLOYMENT_ENTRY)), settings.getSubstitutions(DEPLOYMENT_ENTRY));
                Document deploymentDocument = DomUtilities.parse((InputStream)stream, (boolean)false, (boolean)false);
                Element configuration = (Element)deploymentDocument.getElementsByTagName("BridgeConfiguration").item(0);
                if (host != null) {
                    configuration.setAttribute("host", host);
                }
                wsdlFolder.setControlUrl("http://" + configuration.getAttribute("host") + ":" + configuration.getAttribute("control"));
                File[] templateFiles = FileUtilities.getFileList((File)new File(tmpDir, TEMPLATES_FOLDER_PATH), (FileFilter)new WSDLFileFilter());
                File[] wsdlFiles = new File[templateFiles.length];
                for (int i = 0; i < templateFiles.length; ++i) {
                    wsdlFiles[i] = new File(new File(tmpDir, WSDL_FOLDER_PATH), templateFiles[i].getName());
                    WSDLImport.createWSDLFromTemplate(templateFiles[i], wsdlFiles[i], deploymentDocument, settings, file.getName());
                }
                WSDLImport.importWSDLFiles(new FileImportSource(wsdlFiles), WSDLImport.getAdapterTemplates(zipFile), WSDLImport.getInspections(zipFile), wsdlFolder, merge, nestingLevel);
            }
            if (tmpDir == null) return;
        }
        catch (ZipException e) {
            try {
                throw new ImportError(WSDL_IMPORT_ERROR_REPOSITORY_NOT_VALID_MESSAGE, file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                if (tmpDir == null) throw throwable;
                FileUtilities.deleteDirectory(tmpDir);
                throw throwable;
            }
        }
        FileUtilities.deleteDirectory((File)tmpDir);
        return;
    }

    public static void importAsyncFromRepository(File file, AbstractAsynchronousTestcaseRoot asynchronousRoot, String projectName, String host, Settings settings) throws ParserConfigurationException, SAXException, IOException, TransformerException, ImportWarning, PlaceholderSubstitutorException {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry entry = zipFile.getEntry("asynchronous.trace");
            if (entry == null) {
                throw new ImportWarning(ASYNC_IMPORT_INFO_NO_ASYNCHRONOUS_ENTRY, file.getAbsolutePath());
            }
            InputStream stream = WSDLImport.getSubstitutedStream(zipFile.getInputStream(entry), settings.getSubstitutions(DEPLOYMENT_ENTRY));
            Document document = DomUtilities.parse((InputStream)stream, (boolean)false, (boolean)false);
            if (host != null) {
                document.getDocumentElement().setAttribute("host", host);
            }
            asynchronousRoot.importTestcases(document, projectName, WSDLImport.getServiceName(file));
        }
    }

    private static InputStream getSubstitutedStream(InputStream stream, Map<String, String> substitutions) throws PlaceholderSubstitutorException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        new XmlPlaceholderSubstitutor(true).applySubstitutions((Reader)new InputStreamReader(stream), (Writer)new OutputStreamWriter(result), substitutions);
        return new ByteArrayInputStream(result.toByteArray());
    }

    private static String getServiceName(File repository) throws IOException, ParserConfigurationException, SAXException {
        try (ZipFile zipFile = new ZipFile(repository);){
            Document deployment = DomUtilities.parse((InputStream)zipFile.getInputStream(zipFile.getEntry(DEPLOYMENT_ENTRY)), (boolean)false, (boolean)false, (boolean)false);
            String string = ((Element)deployment.getElementsByTagName("BridgeConfiguration").item(0)).getAttribute("name");
            return string;
        }
    }

    private static InputStream getAdapterTemplates(ZipFile zipFile) throws IOException {
        ZipEntry adapterTemplatesEntry = zipFile.getEntry("adapter.templates.zip");
        return adapterTemplatesEntry == null ? null : zipFile.getInputStream(adapterTemplatesEntry);
    }

    private static InputStream getInspections(ZipFile zipFile) throws IOException {
        ZipEntry inspectionListEntry = zipFile.getEntry("tabfiles/AddOns/Flows/inspectionList.tab");
        return inspectionListEntry == null ? null : zipFile.getInputStream(inspectionListEntry);
    }

    private static void createWSDLFromTemplate(File templateFile, File wsdlFile, Document deploymentDoc, Settings settings, String repository) throws ImportError, TemplateProcessingException {
        String host;
        NodeList configurations = deploymentDoc.getElementsByTagName("BridgeConfiguration");
        if (configurations != null && configurations.getLength() == 1) {
            Element configuration = (Element)configurations.item(0);
            host = configuration.getAttribute("host");
            File directory = wsdlFile.getParentFile();
            if (!directory.exists() && !directory.mkdirs()) {
                throw new ImportError(WSDL_IMPORT_ERROR_CAN_NOT_CREATE_DIRECTORY, directory.getAbsolutePath());
            }
        } else {
            throw new ImportError(WSDL_IMPORT_ERROR_REPOSITORY_NOT_VALID_MESSAGE, repository);
        }
        WSDLTemplate wsdlTemplate = new WSDLTemplate(templateFile, wsdlFile);
        Properties bridgeProperties = new Properties();
        bridgeProperties.setProperty("server_hostname", host);
        TemplateProcessor processor = new TemplateProcessor((Template)wsdlTemplate, settings.getSettings().values(), bridgeProperties);
        processor.processAndWrite();
    }

    private static Transformer getTransformer() throws TransformerLoadException {
        Transformer transformer = WSDLImport.transformer;
        if (transformer == null) {
            transformer = transformerLoader.getTransformer(SCRIPT_NAME);
            transformer.setErrorListener(new TransformerErrorListener());
            if (xmlPath == null) {
                WSDLImport.transformer = transformer;
            }
        } else {
            transformer.reset();
        }
        return transformer;
    }

    static {
        transformerLoader.setErrorListener((ErrorListener)new TransformerErrorListener());
    }

    private static class WSDLTemplate
    extends FileTemplate {
        private final String name;

        public WSDLTemplate(File wsdlTemplate, File targetFile) {
            super(wsdlTemplate, targetFile);
            String path = wsdlTemplate.getPath().replace('\\', '/');
            int index = path.indexOf("templates");
            this.name = index != -1 ? path.substring(index) : path;
        }

        public String getName() {
            return this.name;
        }

        public PlaceholderSubstitutor getPlaceholderSubstitutor() {
            return new XmlPlaceholderSubstitutor();
        }
    }

    public static class ImportWarning
    extends Exception {
        private final String repository;

        public ImportWarning(String key, String repository) {
            super(key);
            this.repository = repository;
        }

        public String getRepository() {
            return this.repository;
        }
    }

    public static class ImportError
    extends Exception {
        private final String repository;

        public ImportError(String key, String repository) {
            super(key);
            this.repository = repository;
        }

        public String getRepository() {
            return this.repository;
        }
    }

    private static class RepositoryNamespaceContext
    implements NamespaceContext {
        private final Map<String, String> prefix2uri = new HashMap<String, String>();
        private final Map<String, String> uri2prefix = new HashMap<String, String>();

        public RepositoryNamespaceContext(TestcaseTemplate.SoapVersion soapVersion) {
            this.prefix2uri.put(WSDLImport.WSDL_FOLDER_PATH, "http://schemas.xmlsoap.org/wsdl/");
            this.uri2prefix.put("http://schemas.xmlsoap.org/wsdl/", WSDLImport.WSDL_FOLDER_PATH);
            switch (soapVersion) {
                case SOAP11: {
                    this.prefix2uri.put("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
                    this.uri2prefix.put("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
                    this.prefix2uri.put("soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
                    this.uri2prefix.put("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
                    this.prefix2uri.put("env", "http://schemas.xmlsoap.org/soap/envelope/");
                    this.uri2prefix.put("http://schemas.xmlsoap.org/soap/envelope/", "env");
                    break;
                }
                case SOAP12: {
                    this.prefix2uri.put("soap12", "http://schemas.xmlsoap.org/wsdl/soap12/");
                    this.uri2prefix.put("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
                    this.prefix2uri.put("soapenc", "http://www.w3.org/2003/05/soap-encoding");
                    this.uri2prefix.put("http://www.w3.org/2003/05/soap-encoding", "soapenc");
                    this.prefix2uri.put("env", "http://www.w3.org/2003/05/soap-envelope");
                    this.uri2prefix.put("http://www.w3.org/2003/05/soap-envelope", "env");
                }
            }
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String namespaceURI = this.prefix2uri.get(prefix);
            return namespaceURI == null ? "" : namespaceURI;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.uri2prefix.get(namespaceURI);
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }

    public static class Data {
        private final WSDLImportTarget importTarget;
        private final String projectName;
        private final URL url;
        private final boolean merge;
        private final int nestingLevel;
        private final String host;

        public Data(WSDLImportTarget importTarget, String projectName, URL url, boolean merge, int nestingLevel, String host) {
            this.importTarget = importTarget;
            this.projectName = projectName;
            this.url = url;
            this.merge = merge;
            this.nestingLevel = nestingLevel;
            this.host = host;
        }

        public AbstractWSDLFolder getWsdlFolder() {
            return this.getSynchronousTestcaseRoot().exists(this.projectName) ? (AbstractWSDLFolder)this.getSynchronousTestcaseRoot().get(this.projectName) : this.getSynchronousTestcaseRoot().createWSDLFolder(this.projectName);
        }

        public String getProjectName() {
            return this.projectName;
        }

        public URL getUrl() {
            return this.url;
        }

        public AbstractSynchronousTestcaseRoot getSynchronousTestcaseRoot() {
            return this.importTarget.getSynchronousRoot();
        }

        public AbstractAsynchronousTestcaseRoot getAsynchronousTestcaseRoot() {
            return this.importTarget.getAsynchronousRoot();
        }

        public boolean isMerge() {
            return this.merge;
        }

        public int getNestingLevel() {
            return this.nestingLevel;
        }

        public String getHost() {
            return this.host;
        }
    }

    public static class URLImportSource
    implements ImportSource {
        private URL url;

        public URLImportSource(URL url) {
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Document createTestcasesDocument() throws IOException, XSLTErrorException {
            XSLTErrorHandler.getInstance().clear(true);
            DOMResult result = new DOMResult();
            InputStream in = this.url.openStream();
            try {
                WSDLImport.getTransformer().transform(new StreamSource(in, this.url.toString()), result);
            }
            catch (Exception e) {
                XSLTErrorHandler.getInstance().error((Throwable)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Logging.logger.warning("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                }
            }
            if (XSLTErrorHandler.getInstance().getErrorCount() > 0) {
                throw new XSLTErrorException(XSLTErrorHandler.getInstance().getErrors());
            }
            return (Document)result.getNode();
        }
    }

    public static class FileImportSource
    implements ImportSource {
        private final File[] wsdlFiles;

        public FileImportSource(File[] wsdlFiles) {
            this.wsdlFiles = wsdlFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Document createTestcasesDocument() throws IOException, XSLTErrorException {
            XSLTErrorHandler.getInstance().clear(true);
            Document testcases = DomUtilities.newDocument((String)"Testcases");
            for (File wsdlFile : this.wsdlFiles) {
                DOMResult result = new DOMResult();
                FileInputStream in = new FileInputStream(wsdlFile);
                try {
                    WSDLImport.getTransformer().transform(new StreamSource(in, wsdlFile.getAbsolutePath()), result);
                }
                catch (Exception e) {
                    XSLTErrorHandler.getInstance().error((Throwable)e);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        Logging.logger.warning("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    }
                }
                if (XSLTErrorHandler.getInstance().getErrorCount() == 0) {
                    NodeList nodeList = ((Document)result.getNode()).getElementsByTagName("Testcase");
                    int length = nodeList.getLength();
                    ArrayList<Node> testcaseList = new ArrayList<Node>();
                    for (int i = 0; i < length; ++i) {
                        testcaseList.add(nodeList.item(i));
                    }
                    for (Node testcase : testcaseList) {
                        DomUtilities.importAndAdd((Node)testcase, (Node)testcases.getDocumentElement());
                    }
                    continue;
                }
                throw new XSLTErrorException(XSLTErrorHandler.getInstance().getErrors());
            }
            return testcases;
        }
    }

    public static interface ImportSource {
        public Document createTestcasesDocument() throws IOException, XSLTErrorException;
    }

    public static class WSDLFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.getName().toLowerCase().endsWith(WSDLImport.WSDL_EXT);
        }
    }

    public static class XSLTErrorException
    extends Exception {
        private final List<? extends BuilderError> errorsAndWarnings;

        public XSLTErrorException(List<? extends BuilderError> errorsAndWarnings) {
            this.errorsAndWarnings = errorsAndWarnings;
        }

        public List<? extends BuilderError> getErrorsAndWarnings() {
            return this.errorsAndWarnings;
        }
    }

    private static class TransformerErrorListener
    implements ErrorListener {
        private TransformerErrorListener() {
        }

        @Override
        public void warning(TransformerException e) {
            Logging.logger.warning(e.getMessageAndLocation());
            XSLTErrorHandler.getInstance().warning((BuilderWarning)new XSLTWarning(e.getMessageAndLocation(), null, null));
            EventController.fire((EventObject)new SendWarningEvent((Object)this, e.getMessageAndLocation(), null, XSLTOutput.getModuleName(), XSLTOutput.getMessgeView()));
        }

        @Override
        public void error(TransformerException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessageAndLocation());
            XSLTErrorHandler.getInstance().error((Throwable)e);
            EventController.fire((EventObject)new SendErrorEvent((Object)this, e.getMessageAndLocation(), null, XSLTOutput.getModuleName(), XSLTOutput.getMessgeView()));
        }

        @Override
        public void fatalError(TransformerException e) {
            Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessageAndLocation());
            XSLTErrorHandler.getInstance().error((Throwable)e);
            EventController.fire((EventObject)new SendFatalErrorEvent((Object)this, e.getMessageAndLocation(), null, XSLTOutput.getModuleName(), XSLTOutput.getMessgeView()));
        }
    }
}

