//
// The following flags shall be shared among controllers. 
// Thus, they are global. 
//
function e2eInitGlobals(oFlags) {
	if (window.oE2EGlobals !== undefined) return;

	var oQuery = new E2E_Query();
	
	var sDefaultLanguage = oFlags.sDefaultLanguage || "en";
	var sLang = oQuery.getAsString("lang") || sDefaultLanguage;
	var bTest = oQuery.getAsBoolean("test", false);
	var bTrace = oQuery.getAsBoolean("trace", false);

	var bJSisMinimized = oFlags.bJSisMinimized || false;
	var bHasUnitTests = oFlags.bHasUnitTests || false;
	var bHasTables = oFlags.bHasTables || false;

	if (bJSisMinimized) {
		if (bTrace) {
			alert("Tracing (trace=true) is not supported if JavaScript has been optimized.");
			bTrace = false;
		}
		if (bTest) {
			alert("Unit testing (test=true) is not supported if JavaScript has been optimized.");
			bTest = false;
		}
	}

	if (bTest && !bHasUnitTests) {
		alert("Unit testing (test=true) is not possible because no tests have been defined.");
	}

	window.oE2EGlobals = {
		  oE2EQuery: oQuery,
		  bE2ETrace: bTrace,
		  bE2ETest: bTest,
			sE2ELang: sLang,
			oE2EDataTablesLanguage: {},
			bE2EIsInternalEvent: false,
			oE2EVisibleStates: new E2E_VisibilityStates(100) // history must be global because the backbutton applies to all loaded controllers
	}

	// After having the global language, we initilize the translations. The reason to do it here is Bug 9229
	// We use the date picker also to format labels, thus we load translations (including date formats) 
	// all the time - even if we have no date input fields.
	e2eLoadDatePickerTranslations('../libs/jquery/ui-1.8.2/minified/i18n/jquery.ui.datepicker-{tag}.min.js', sLang);
	
	e2eLoadValidationTranslations('../libs/jquery/validate-1.7/localization/messages_{tag}.js', sLang);

	if (bHasTables) {
		e2eLoadTableTranslations('../libs/jquery/dataTables-1.7.1/localization/dataTables-{tag}.txt', sLang);
	}
}

function e2eCreateController(sControllerName) {
	
	var oController = {
			oE2EErrorHandlers: {},
			oE2ERequest: {},
			oE2EMockups: {},
			oE2EDialogStack: [],
			oE2EServiceHandler: {},
			oE2ETimeoutHandler: {},
			oE2EControllerBindings: {},
			oE2ETimer: {},
			oE2ETables: {},
			oE2EDialogs: {},
			
			e2eSend: e2eSend,
			e2eReceive: e2eReceive,
			e2eSetCurrentDateSettings: e2eSetCurrentDateSettings,
			e2eSetTimer: e2eSetTimer,
			e2eClearTimeout: e2eClearTimeout,
			e2eHideModalDialog: e2eHideModalDialog,
			e2eCreateOrOpenModalDialog: e2eCreateOrOpenModalDialog,
			e2eOpenModalDialog: e2eOpenModalDialog,
			
			e2eRegisterService: e2eRegisterService,
			e2eCallService: e2eCallService,
	}
		
	return oController;
}

function e2eRegisterService(name, handler) {
	this.oE2EServiceHandler[name] = handler;
}

function e2eCallService(name, parameter) {
	this.oE2EServiceHandler[name].call(null, parameter);
}

function e2eInitTests(oController, fRun, sTestBlockId, sRunButtonId, sClearButtonId) {
	
	oTestBlock = $("#" + sTestBlockId);
	if (oE2EGlobals.bE2ETest) {
		var bUseDialog = oE2EGlobals.oE2EQuery.getAsBoolean("dialog", true);
		if (bUseDialog) {
			var oTestDialog = oTestBlock.dialog({ width: 500, title: "Unit Tests"});
			var sLinkId = "link" + sTestBlockId;
			$("body > *").first().before("<a id='" + sLinkId + "' href='' class='ui-icon ui-icon-newwin'>Open test dialog</a>");
			$("#" + sLinkId).bind("click", function (event) {
				event.preventDefault();
				oTestDialog.dialog("open");
			});
			var runButton = $("#" + sRunButtonId);
			runButton.button().css({"margin": "0.1em", "width": "100%"});
			runButton.bind("click", function () {
				fRun(oController);
			});
			var clearButton = $("#" + sClearButtonId);
			clearButton.button().css({"margin": "0.1em", "width": "100%"});
			clearButton.bind("click", function () {
				$("#qunit-tests > li").remove();
			});
		} else {
			fRun(oController);
		}
	} else {
		oTestBlock.hide();
	}
}

function e2eClearTimeout(sTimerName) {
	var timer = this.oE2ETimer[sTimerName];
	if (timer) clearTimeout(timer);
}

function e2eSetTimer(sTimerName, sTimoutHandlerName, iTimeout) {
	var handler = this.oE2ETimeoutHandler[sTimoutHandlerName];
	var timer = setTimeout(handler, iTimeout);
	this.oE2ETimer[sTimerName] = timer;
}

function e2eHistoryCallback(hash) {
	if (hash) {
		var g = window.oE2EGlobals;
		if (g.bE2EIsInternalEvent) {
			g.bE2EIsInternalEvent = false;
		} else { 
			g.oE2EVisibleStates.gotoIndexedState(hash);
		}
	}
}

function e2eHistoryControl() {
	var g = window.oE2EGlobals;
	g.oE2EVisibleStates.saveIndexedState();
	g.bE2EIsInternalEvent = true;
	window.location.hash = window.oE2EGlobals.oE2EVisibleStates.getLastIndex();
}

function e2eTransition(oEvent, fHandler) {
	if (oEvent) oEvent.preventDefault();
	fHandler(oEvent);
	e2eHistoryControl();
}

function e2eInitialTransition(fHandler) {
	fHandler();
	e2eHistoryControl();
}

function e2eTimeoutTransition(fHandler) {
	fHandler();
	e2eHistoryControl();
}

function E2E_Query () {
	this.oQuery = e2eParseQueryString(window.location.search);
	
	this.getAsString = function (name, defaultValue) {
		return this.parse(name, defaultValue);
	}
	
	this.getAsBoolean = function (name, defaultValue) {
		var parser = function(sValue) {
			return (sValue == 'true');
		}
		return this.parse(name, defaultValue, parser);
	}

	this.getAsInteger = function (name, defaultValue) {
		return this.parse(name, defaultValue, parseInt);
	}

	this.getAsFloat = function (name, defaultValue) {
		return this.parse(name, defaultValue, parseFloat);
	}
	
	this.getAsDateTime = function (name, defaultValue) {
		var parser = function(sValue) {
			return new Date(Date.parse(sValue));
		}
		return this.parse(name, defaultValue, parser);
	}
	
	this.parse = function (name, defaultValue, parser) {
		var aValue = this.oQuery[name];
		if (aValue !== undefined && aValue !== null && aValue[0] !== null) {
			if (parser !== undefined) {
				return parser(aValue[0]);
			} else {
				return aValue[0];
			}
		} else {
			if (defaultValue !== undefined) {
				return defaultValue;
			} else {
				return null;
			}
		}
	}

}

function e2eGetURL(sPath, oParameter) {
	var isTraceOn = e2eIsTraceOn();
	var sParameter =  isTraceOn ? "?trace=true" : "";
	var sDelimiter =  "&";
	if (oParameter !== undefined && oParameter !== null) {
		var index = 0;
		for (var sName in oParameter) {
			var sValue = oParameter[sName];
			if (index === 0 && !isTraceOn) {
				sDelimiter = "?";
			}
			if (sValue !== undefined && sValue !== null) {
				sParameter = sParameter + sDelimiter + encodeURIComponent(sName) + "=" + encodeURIComponent(sValue);
			} 
			index = index + 1;
		}
	} 
 
 	return (sPath + sParameter);
}

function e2eOnBeforeUnload(message) {
	window.onbeforeunload = function (event) {
		if (typeof event == 'undefined') {
			event = window.event;
		}
		if (event) {
			event.returnValue = message;
		}
		return message;
	}
}

function E2E_VisibilityStates(maxSize) {
	this.maxSize = maxSize; // max length of history	
	this.indexedStates = []; // used for the back button history
	this.historyStates = new Object(); // used for history states
	this.index = -1;
	this.selector = "form:visible, iframe:visible"; // going forward and backward means moving from one form to another. All other dfinitions including div, span, and other elements proved to confusing

	this.getState = function(index) {
		if (index >= 0) {
			if (index <= this.getLastIndex()) {
				return this.indexedStates[index];
			} else {
				return this.indexedStates[this.getLastIndex()];
			}
		} else {
			return null;
		}
	}
	
	this.getLastIndex = function() {
		return (this.indexedStates.length - 1);
	}

	// associate current index with state id
	this.saveHistoryState = function(id) {
		this.historyStates[id] =  this.indexedStates[this.getLastIndex()]; // this is the last well defined visible state
	}

	// returns true if it was possible to go back.
	this.gotoHistoryState = function(id) {
		var newVisibleElements = this.historyStates[id];		
		if (newVisibleElements !== undefined && newVisibleElements !== null) {
			$(this.selector).hide();
			newVisibleElements.show();
			return true;
		} else {
			return false;
		}
	}

	this.saveIndexedState = function() {
		if (this.indexedStates.length == this.maxSize) {
			this.indexedStates.shift(); // remove first element to get space for the new one
		}
		this.indexedStates.push($(this.selector));
	}

	// returns true if it was possible to goto the index.
	this.gotoIndexedState = function(indexString) {
		var index = Number(indexString);

		if (index == 'NaN' || index < 0) {
			return false;
		} 
		
		var newVisibleElements = this.getState(index);		
		if (newVisibleElements) {
			$(this.selector).hide();
			newVisibleElements.show();
			return true;
		} else {
			return false;
		}
	}

}

/*
	The loaded script must look like:
	
	var e2eTranslationTexts = {
	  caseIDLabel: "Fall Identifikation",
	  descriptionLabel: "Beschreibung"
	};
*/
function e2eTranslate(sControllerURI, sDefaultLanguage) {
	
	var sLang = e2eGetLanguage();
	
	if (sLang === sDefaultLanguage) return;

	var sTranslationsURL = sControllerURI + '.' + sLang + '.js';
	$.ajax({
		url: sTranslationsURL,  
		dataType: 'script',
		cache: true,
		success: function(data) {	
			var oTranslations = window.e2eTranslationTexts;
			for (var id in oTranslations) {
				var sTranslation = oTranslations[id];
				var nElement = $('#' + id);
				var nChildren = nElement.children();
				if (nChildren.size() > 0) {
					if (nChildren.is('span')) {
						nChildren.html(sTranslation);
					} else {
						// can this happen?
					}
				} else {
					if (nElement.is('input')) {
						nElement.attr('placeholder', sTranslation);
					} else {
						nElement.html(sTranslation);
					}
				}
			}
		},
		error: function() {	
			var sPostfix = sLang.indexOf('-') !== -1 ? "" : "\nIs the region missing? Format: lang=<lang>-<region>, e.g.: lang=en-US";
			var sMessage = "Could not load translations for the language '" + sLang + "'. " + sPostfix;
			alert(sMessage);	
			//e2eLog(sMessage);
		}
	});
}

function e2eGetLanguage() {
	if (window.oE2EGlobals !== undefined) {
		return window.oE2EGlobals.sE2ELang;
	} else {
		e2eGetBrowserLanguage(); // if we get here, we have a compiler bug
	}
}

function e2eGetBrowserLanguage() {
	return (navigator.language /* Mozilla, Opera, Safari */ || navigator.userLanguage /* IE */);
}

function e2eGetBrowserRegion() {
	var sLang = e2eGetBrowserLangauge();
	var aLangTags = sLang.split('-');
	return (aLangTags[1] || 'US');
}

function e2eGetSupportedLanguageTag(sLang, oSupportedLanguages) {
	var aLangTags = sLang.split('-');
	var sLangSubtag = aLangTags[0] || '';
	var sRegionSubtag = aLangTags[1] || '';
	
	var oSupportedRegions = oSupportedLanguages[sLangSubtag.toLowerCase()];
	
	if (oSupportedRegions) {
		if (oSupportedRegions[sRegionSubtag.toUpperCase()])
		{   // region is supported
			if (sRegionSubtag !== '' ) { 
				return (sLangSubtag + '-' + sRegionSubtag.toUpperCase());
			} else {
				return sLangSubtag;
			}
		} else {
			// If we are here, there is no appropriate region. However, we take the overall language as default
			return sLangSubtag;
		}
	} else {
		return sLangSubtag;
	}
}


function e2eLoadTableTranslations(sLangFilePattern, sLang) {
	if (!e2eIsWidgetDefaultLanguage(sLang)) {
		var sLanguageTag = e2eGetSupportedLanguageTag(sLang, {pt:{BR: true}, sr:{Latn: true}})
		var sUrl = sLangFilePattern.replace('\{tag\}', sLanguageTag);
		$.ajax({
			async: false, // otherwise we might need the translations in the first view before they are loaded
			url: sUrl,  
			dataType: 'json',
			cache: true,
			success: function(data) {	
				window.oE2EGlobals.oE2EDataTablesLanguage = data;
			},
			error: function() {	
				alert("Could not load the table widget translations for '" + sLang + "' using the URL '" + sUrl + "'");			
			}
		});
	}
}

function e2eLoadValidationTranslations(sLangFilePattern, sLang) {
	if (!e2eIsWidgetDefaultLanguage(sLang)) {
		var sLanguageTag = e2eGetSupportedLanguageTag(sLang, {pt:{BR: true, PT: true}})
		var sUrl = sLangFilePattern.replace('\{tag\}', sLanguageTag);
		$.ajax({
			async: false, // otherwise we might need the translations in the first view before they are loaded
			url: sUrl,  
			dataType: 'script',
			cache: true,
			error: function() {	
				alert("Could not load the validation plug-in translations for '" + sLang + "' using the URL '" + sUrl + "'");			
			}
		});		
	}
}

function e2eLoadDatePickerTranslations(sLangFilePattern, sLang) {
	if (!e2eIsWidgetDefaultLanguage(sLang)) {
		var sLanguageTag = e2eGetDatepickerLangaugeTag(sLang);
		var sUrl = sLangFilePattern.replace('\{tag\}', sLanguageTag);
		$.ajax({
			async: false, // otherwise we might need the translations in the first view before they are loaded
			url: sUrl,  
			dataType: 'script',
			cache: true,
			error: function() {	
				alert("Could not load the date widget translations for '" + sLang + "' using the URL '" + sUrl + "'");			
			}
		});		
	}
}

function e2eGetDatepickerLangaugeTag(sLang) {
	// which languages have supported regions
	var oSupportedRegions = {en:{US: true, GB: true}, fr:{CH: true}, pl:{BR: true}, pt:{BR: true}, sr:{SR: true}, zh:{CN: true, HK: true, TW: true}};
	return e2eGetSupportedLanguageTag(sLang, oSupportedRegions);
}
function e2eGetSOAPDateString(jElement) {
	var sDate = e2eGetText(jElement);
	var sDateFormat = e2eGetDateFormat();
	
	return $.datepicker.formatDate('yy-mm-dd', $.datepicker.parseDate(sDateFormat, sDate)); 
}

function e2eParseSOAPDateTime(sDate) {
	return new Date(Date.parse(sDate));
}

function e2ePrintSOAPDateTime(dDate) {
	if (dDate !== null) { 
		var padLeft = function(iValue) {
			return (iValue < 10 ? ('0' +  iValue) : iValue);
		}
		var sSOAPDateTime = e2ePrintSOAPDate(dDate) + 
			'T' + padLeft(dDate.getUTCHours()) + ':' + padLeft(dDate.getUTCMinutes()) + ':' + padLeft(dDate.getUTCSeconds()) + 
			'.' + dDate.getUTCMilliseconds() + 'Z';
		return sSOAPDateTime;
	} else {
		return null;
	}
}

function e2ePrintSOAPDate(dDate) {
	if (dDate !== null) { 
		var padLeft = function(iValue) {
			return (iValue < 10 ? ('0' +  iValue) : iValue);
		}
		var sSOAPDate = dDate.getUTCFullYear() + '-' +  padLeft(dDate.getUTCMonth() + 1) + '-' + padLeft(dDate.getUTCDate());
		return sSOAPDate;
	} else {
		return null;
	}
}

function e2eFormatSOAPDate(jElement, sFormat) {
	e2eAddFormattingClass(jElement, 'e2e-date');
	
	var sDate = e2eGetText(jElement);
	var sDateFormat = sFormat || e2eGetDateFormat();
	var sFormattedDate = $.datepicker.formatDate(sDateFormat, $.datepicker.parseDate('yy-mm-dd', sDate)); 

	e2eSetText(jElement, sFormattedDate);
}

//  e2eSetCurrentDateSettings({ dateFormat: "d-M-yy", monthNamesShort: ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC']});
function e2eSetCurrentDateSettings(oSettings) {
    var sLang = e2eGetLanguage();

    if (e2eIsWidgetDefaultLanguage(sLang)) {
       e2eSetDateSettings('', oSettings);
     } else {
       var sLanguageTag = e2eGetDatepickerLangaugeTag(sLang);
       e2eSetDateSettings(sLanguageTag, oSettings);
    }
}

// The setting object may contain the following attributes:
//     closeText, prevText, nextText, currentText, monthNames, monthNamesShort, dayNames, dayNamesShort, dayNamesMin, weekHeader, dateFormat, firstDay, isRTL, showMonthAfterYear, and yearSuffix
// details: http://docs.jquery.com/UI/Datepicker#options
function e2eSetDateSettings(sLanguageTag, oSettings) {
    var oRegional = $.datepicker.regional;
    if ( oRegional[sLanguageTag] === undefined) {
        oRegional[sLanguageTag] = oRegional['']; // fall back to the default
    }
    
    // override the regional options if defined in the setting object
    var sName = '';
    for (sName in oSettings) {
        oRegional[sLanguageTag][sName] = oSettings[sName];      
    }
    
   $.datepicker.setDefaults($.datepicker.regional[sLanguageTag]);
}


function e2eGetDateFormat() {
	var sDateFormat =  $.datepicker.regional[''].dateFormat; // default
	var sLang = e2eGetLanguage();
	
               if (!e2eIsWidgetDefaultLanguage(sLang)) {
                              var sLanguageTag = e2eGetDatepickerLangaugeTag(sLang);
                              var region = $.datepicker.regional[sLanguageTag];
                              if (region) {
                                             sDateFormat = region.dateFormat;
                              }
               }
               
	return sDateFormat;
}

// For the default lang we do not have explicit translations, thus they are handled differently
function e2eIsWidgetDefaultLanguage(sLang) {
	return  (sLang === "en" || sLang === "en-US") ;
}

function e2eFormatSOAPDates(jElements) {
	var sDateFormat = e2eGetDateFormat();
	jElements.each(function(index) {
		e2eFormatSOAPDate($(this), sDateFormat);
	});
}

function e2eGetSOAPNumberString(jElement) {
	var sRegion = e2eGetNumberRegion();
	var aNumber = jElement.parse({locale: sRegion});
 	return aNumber.join(); 
}

function e2eGetNumberRegion() {
	var sLang = e2eGetLanguage();
	var aLangTags = sLang.split('-');
	var sRegion = aLangTags[1] || e2eMapLanguage2Region(sLang);
	return sRegion.toLowerCase(); // the used number plug-ins require the region in lower case
}

function e2eFormatNumber(jElement, sFormat, sNumberRegion) {
	e2eAddFormattingClass(jElement, 'e2e-number');	
	
	var sRegion = sNumberRegion || e2eGetNumberRegion();
	if (sFormat !== undefined && sFormat !== null && sFormat !== "") {
		jElement.format({format: sFormat, locale: sRegion}); 
	} else {
		jElement.format({locale: sRegion}); 
	}
}

function e2eFormatSOAPNumber(jElement, sFormat, sNumberRegion) {
	var sRegion = sNumberRegion || e2eGetNumberRegion();
	var sDecimalSeparator = e2eGetDecimalSeparator(sRegion);
	var sNumber = e2eGetText(jElement);
	// we have to replace the SOAP decimal separator  by the locale one, 
	// otherwise, the number formatter plugin would not work
	var sFormattedNumber = sNumber.replace(".", sDecimalSeparator);
	e2eSetText(jElement, sFormattedNumber);
	e2eFormatNumber(jElement, sFormat, sRegion);
}

function e2eFormatSOAPNumbers(jElements, sFormat) {
	var sNumberRegion = e2eGetNumberRegion();
	jElements.each(function(index) {
		e2eFormatSOAPNumber($(this), sFormat, sNumberRegion);
	});
}

function e2eFormatSOAPInteger(jElement) {
	e2eAddFormattingClass(jElement, 'e2e-integer');
}

function e2eAddFormattingClass(jElement, sCssClass) {
	var jTarget = jElement;
	if (!jElement.is(":input") && jElement.parent().is("td")) jTarget = jElement.parent()
	if (!(jTarget.hasClass(sCssClass))) jTarget.addClass(sCssClass); 
}

function e2eGetText(jElement) {
	var sText = jElement.text();
	if (jElement.is(":input")) {
		sText = jElement.val();
	}
	return sText; 
}

function e2eSetText(jElement, sText) {
	if (jElement.is(":input")) {
		jElement.val(sText);
	} else {
		jElement.text(sText);
	}
}

$.validator.addMethod(
        "e2ePattern",
        function(value, element, regexp) {
            var check = false;
            var re = new RegExp(regexp);
            return this.optional(element) || re.test(value);
        },
        "Please check your input."
);

$.validator.addMethod(
        "e2eNumber",
        function(value, element, sValidFormat) {
			var jElement = $(element); 
			
			e2eFormatNumber(jElement, sValidFormat);
			
			var sFormattedValue = jElement.val();
			if (sFormattedValue.indexOf('NaN') > -1) {
				jElement.val(value);
				return false;
			} else {
				return true;
			}
		},
		$.validator.messages.number
);

$.validator.addMethod(
        "e2eDate",
        function(value, element, sValidFormat) {
        			// sValidFormat is ignored yet because use the datepicker plugin to set and get formats
			var jElement = $(element); 
			e2eAddFormattingClass(jElement, 'e2e-date');
			var sDateFormat = e2eGetDateFormat();
			try {
				var oDate = $.datepicker.parseDate(sDateFormat, value);
			} catch(e) {
				return false;
			}
			
			return true;
		},
		$.validator.messages.date
);

$.validator.addMethod(
        "e2eInteger",
        function(value, element, sValidFormat) {
        			// we ingore sValidFormat yet
			var jElement = $(element); 
			e2eAddFormattingClass(jElement, 'e2e-integer');
			// there is nothing to check yet, because all integers already get the digits rule
			return true;
		}
);

function e2eGetFileUploadURL(sServiceURL, sPortPath, sOperationName) {
	var sServiceDelimiter = "/";
	if (sServiceURL.charAt(sServiceURL.length - 1) == '/' || sPortPath.charAt(0) == '/' ) {
		sServiceDelimiter = "";
	}
	var sPortDelimiter = "/";
	if (sPortPath.charAt(sServiceURL.length - 1) == '/' || sOperationName.charAt(0) == '/' ) {
		sPortDelimiter = "";
	}
	var sHostName = '//' + window.location.hostname;
	var sRealServiceURL = sServiceURL.replace('//localhost', sHostName);
	var sFileUploadURL = sRealServiceURL + sServiceDelimiter + sPortPath + sPortDelimiter + sOperationName;
	
	return sFileUploadURL;
}

function e2eHideModalDialog(sHtmlId, sDialogName) {
	var dialog = this.oE2EDialogs[sDialogName];
	if (dialog === undefined || dialog === null)  {
		$("#" + sHtmlId).hide();
	} else {
		dialog.dialog("close");
	}
}

// Normally, a opening a dialog means just creating a new window on top 
// of the existing one, so building a stack of modal windows.
// However, finally the top most modal window is reached in this case
// we have to close the existing modal dialog because we start climbing down the tree
function e2eOpenModalDialog(nextDialog) {
	var stack = this.oE2EDialogStack;
	var currentDialog = stack.length > 0 ? stack[stack.length - 1] : null;
	var lastDialog = stack.length > 1 ? stack[stack.length - 2] : null;
	if (lastDialog !== null && lastDialog.attr("id") === nextDialog.attr("id")) {
		currentDialog.css({opacity: 1});
		currentDialog.dialog("close");
		stack.pop();
	}
	nextDialog.dialog("open");
	stack.push(nextDialog);
}

function e2eCreateOrOpenModalDialog(htmlId, sDialogName, dialogOptions) {
	var dialog = this.oE2EDialogs[sDialogName];
	if (dialog === undefined || dialog === null) {
		dialog = $("#" + htmlId).show().dialog(dialogOptions);
		dialog.dialog( "option", "modal", true );
		this.oE2EDialogStack.push(dialog);
		this.oE2EDialogs[sDialogName] = dialog;
	} else {
		this.e2eOpenModalDialog(dialog);
	}
}


function e2eDispatchConnectionError(sURL, oErrorHandlers) {
	var fErrorHandler = oErrorHandlers['onConnectionError'];
	if (fErrorHandler) {
		fErrorHandler(sURL);
	} else {
		alert("Error connecting to '" + sURL + "'");
	}					
}

function e2eDispatchSOAPError(oRequest, oErrorHandlers) {
	var sErrorXml = oRequest.responseText;
	if (sErrorXml) {
		var oE2EErrorResponse = new E2E_XMLResponse(sErrorXml);
		var nSOAPFault = oE2EErrorResponse.getElements("Fault", "http://schemas.xmlsoap.org/soap/envelope/")[0];
		if (nSOAPFault) {
			var nDetail = e2eGetChildNode(nSOAPFault, 'detail');
			var nMessage = e2eGetChildNode(nDetail, 'message');
			var nCallstack = e2eGetChildNode(nMessage, 'callstack');
			var nCategory = e2eGetChildNode(nMessage, 'category');
			var nType = e2eGetChildNode(nMessage, 'domain');
			var nCode = e2eGetChildNode(nMessage, 'code');
			var nDescription = e2eGetChildNode(nMessage, 'description');
			var oMessage = new Object();
			oMessage.callstack = e2eGetChildNodeValue(nCallstack);
			oMessage.category = e2eGetChildNodeValue(nCategory);
			oMessage.type = e2eGetChildNodeValue(nType);
			oMessage.code = e2eGetChildNodeValue(nCode);
			oMessage.description = e2eGetChildNodeValue(nDescription);
			
			var sType = '*';
			var sCode = '*';
			if (oMessage.type) { 
				sType = oMessage.type;
			}
			if (oMessage.code) { 
				sCode = oMessage.code;
			}
			var sKey1 = sType + '::' + sCode;
			var fErrorHandler1 = oErrorHandlers[sKey1];
			if (fErrorHandler1) {
				fErrorHandler1(oMessage);
			} else {
				var sKey2 = '*::' + sCode;
				var fErrorHandler2 = oErrorHandlers[sKey2];
				if (fErrorHandler2) {
					fErrorHandler2(oMessage);
				} else {
					var sKey3 = sType + '::*';
					var fErrorHandler3 = oErrorHandlers[sKey3];
					if (fErrorHandler3) {
						fErrorHandler3(oMessage);
					} else {
						var sKey4 = '*::*';
						var fErrorHandler4 = oErrorHandlers[sKey4];
						if (fErrorHandler4) {
							fErrorHandler4(oMessage);
						} else {
							var nFaultCode = e2eGetChildNode(nSOAPFault, 'faultcode');
							var sFaultCode = e2eGetChildNodeValue(sFaultCode);
							var nFaultDescription = e2eGetChildNode(nSOAPFault, 'faultstring');
							var sFaultDescription = e2eGetChildNodeValue(nFaultDescription);
							alert(	"SOAP Operation Error: Fault Code: '" + sFaultCode + "' Fault Code: '" + sFaultDescription + 
									"'\n HTTP Status: '" + oRequest.status + " - " + oRequest.statusText + "'");
						}							
					}					
				}
			}
		} else {
			alert(	"SOAP Operation Error: XML text: \n" + sErrorXml + 
					"'\n HTTP Status: '" + oRequest.status + " - " + oRequest.statusText + "'");
		}
	} else {
		alert(	"SOAP Operation Error: XML text: *undefined* \n HTTP Status: '" + oRequest.status + " - " + oRequest.statusText + "'");
	}
}

/*	
e2eSend({
		"sURLVarName": "sServices_UITransitionPort_URI",
		"sAction": "onExit",
		"sSOAPAction": "urn:saveData",
		"sOperationName": "saveData",
		"sResponseHandlerName": "handleUITransition_saveDataResponse",
		"sMockupKey": myController.oE2EMockups["UITransitionPort.saveData"],
		"bIsAsynchronous": true,
		"fBinding": fInputBinding
	});
*/
function e2eSend(oParameters) {
	
	var sResponseHandlerName = oParameters.sResponseHandlerName;
	var fResponseHandler = this.oE2EServiceHandler[sResponseHandlerName];
	
	var mockup = this.oE2EMockups[oParameters.sMockupKey];
	if (mockup !== undefined && mockup !== null) {
		return fResponseHandler();
	}

	var oEnvelope = e2eGetSOAPEnvelope(null);
	var oBody = new E2E_XMLElementNode('soap:Body');
	oEnvelope.appendChildElement(oBody);

	if (oParameters.aRow) {
		oParameters.fBinding(oBody, oParameters.aRow);
	} else if (oParameters.aFilterParameters) {
		oParameters.fBinding(oBody, oParameters.aFilterParameters);
	} else {
		oParameters.fBinding(oBody);
	}
	
	var oRequest = e2eGetXMLHttpRequest();
	if (oRequest) {
		var key = e2eGetXMLHTTPRequestKey(oParameters);
		this.oE2ERequest[key] = oRequest;

		var sURL = window[oParameters.sURLVarName];
		if (sURL === undefined) {
			alert("Cannot call " + oParameters.sOperationName + " because the soap url is missing. Please, set the variable '" + oParameters.sURLVarName + "'.");
		} else {					
			oRequest.open("POST", sURL, oParameters.bIsAsynchronous);
			oRequest.setRequestHeader("Content-Type", "text/xml");
			oRequest.setRequestHeader("SOAPAction", oParameters.sSOAPAction);
			
			if (oParameters.bIsAsynchronous) {
				oRequest.onreadystatechange = fResponseHandler;
			}
			
			if (oRequest.onerror !== undefined) { // this attribute is not defined for IE 6 or if enable native HTTP support is switched off 
				oRequest.onerror = function () { 
					e2eDispatchConnectionError(sURL, this.oE2EErrorHandlers); 
				}
			}

			var sMessage = oEnvelope.serialize();
			oRequest.send(sMessage);
			
			if (!(oParameters.bIsAsynchronous)) {
				return fResponseHandler();
			}
		}
	}
}

function e2eGetXMLHTTPRequestKey(oParameters) {
	return (oParameters.sAction + "." + oParameters.sResponseHandlerName);
}

/*	
	e2eReceive({
		"oDocument": document,
		"sResponseHandlerName": "handleUITransition_saveDataResponse",
		"sAction": "onExit",
		"sMockupKey": "UITransitionPort.saveData",
		"bIsAsynchronous": true,
		"fBinding": fOutputBinding
	});
*/
function e2eReceive(oParameters) {
	var bIsSynchronous = !(oParameters.bIsAsynchronous);
	var oXMLHTTPRequest = null;
	var mockup = this.oE2EMockups[oParameters.sMockupKey];
	if (mockup !== undefined && mockup !== null) {
		e2eLogXML("Mocking up ", mockup);
		oXMLHTTPRequest = { readyState: 4, status: 200, responseText: mockup };
	} else {
		var key = e2eGetXMLHTTPRequestKey(oParameters);
		oXMLHTTPRequest = this.oE2ERequest[key];
	}

	if (oXMLHTTPRequest.readyState == 4) {
		if (oXMLHTTPRequest.status == 200) {
			var sXml = oXMLHTTPRequest.responseText;
			var oE2EResponse = new E2E_XMLResponse(sXml, oParameters.oDocument, this);
			if (e2eHasParseError(oE2EResponse)) return false;

			e2eTraceOpen("BINDING: Operation='" + oParameters.sResponseHandlerName + "'");

			var oE2EResponseBody = oE2EResponse.getFirstElement("Body", "http://schemas.xmlsoap.org/soap/envelope/");

			oParameters.fBinding(oE2EResponse, oE2EResponseBody);
			
			e2eTraceClose();
			
			if (bIsSynchronous) return true;
		} else {
			e2eDispatchSOAPError(oXMLHTTPRequest, this.oE2EErrorHandlers);
			if (bIsSynchronous) return false;
		}
	} else {
		if (bIsSynchronous) return false;
	}	
}

function e2eRemoveChildren(node) {
	var childNodes = node.childNodes;
	var length = childNodes.length;
	for (var j = length-1; j >= 0; j--) {
		var c = childNodes[j];
		c.parentNode.removeChild(c);
	}
}

function e2eAppendTreeChildren(parent, children) {
	
	for (var i=0; i < children.length; i++) {
		var idAttribute=e2eGetAttribute(children[i], "id");
		var id="UnknownId";
		if (idAttribute) { 
			id=idAttribute.nodeValue;
		} else {
			alert("ASSERTION: no id returned");
		}
		var labelAttribute=e2eGetAttribute(children[i], "label");
		var label="UnknownLabel";
		if (labelAttribute && labelAttribute != "") { 
			label=labelAttribute.nodeValue;
		}
		var groupAttribute=e2eGetAttribute(children[i], "group");
		var group="UnknownGroup";
		if (groupAttribute) { 
			group=groupAttribute.nodeValue;
		}
		var isLeafAttribute=e2eGetAttribute(children[i], "isLeaf");
		var isLeaf="false";
		if (isLeafAttribute) { 
			isLeaf=isLeafAttribute.nodeValue;
		}
		var li=document.createElement("li");
		li.setAttribute("id", id);
		li.setAttribute("group", group);
		
		if (isLeaf == "true") {
			var handlerName = "activate" + group;
			if (window[handlerName] === undefined) {
				alert("The tree label '" + label + 
							"' has no handler ('" + handlerName + 
							"'). Most likely reason: the returned group '" + group + 
							"' is not defined on the tree transitions.");
			} else {
				li.innerHTML="<div class='e2e-tree-leaf' id=\"" + group + 
										"\" onClick=\"" + handlerName + "('" + id + "')\">" + label + "</div>";
			}
		} else {
			li.innerHTML="<span>" + label + "</span><ul id=\"" + e2eGetNavigationTreeHtmlId(id) + "\" class=\"treeview\"></ul>";
		}
		parent.appendChild(li);
		//alert("id=" + id);
	}
}

function e2eGetNavigationTreeHtmlId(externalId) {
	return("ulOf" + externalId);
}

function E2E_NavigationTree(htmlId, externalId, group) {
	this.htmlId = htmlId; // list element id	
	this.isExpanded = false; // are children expanded
	this.externalId = externalId;
	this.group = group;
	
	this.getHtmlId = function() {
		return this.htmlId;
	}
	this.getExternalId = function() {
		return this.externalId;
	}
	this.getGroup = function() {
		return this.group;
	}
	this.setIsExpanded = function(isExpanded) {
		this.isExpanded = isExpanded;
	}
	this.getIsExpanded = function() {
		return this.isExpanded;
	}
}

function e2eGetNodeValue(node, defaultValue, defaultParser) {
	if (node !== undefined && node !== null && node.nodeValue !== null) {
		if (defaultParser !== undefined) {
			return defaultParser(node.nodeValue);
		} else {
			return node.nodeValue;
		}
	} else {
		if (defaultValue !== undefined) {
			return defaultValue;
		} else {
			return "";
		}
	}
}

function e2eGetChildNodeValue(node) {
	var value = "";
	
	if (node !== undefined && node !== null) {
		if (node.childNodes !== undefined && node.childNodes !== null) {
			value = e2eGetNodeValue(node.childNodes[0]);
		}
	} 
	
	return value;
}

/*
 * We need these classes because the XML DOM serializer does not support namespaces on IE
 */

function e2eGetSOAPEnvelope(principal) {
	
	var envelope=new E2E_XMLElementNode('soap:Envelope');
	envelope.appendNamespace("xmlns:soap='http://schemas.xmlsoap.org/soap/envelope/'");

	if (principal && principal.userID !== undefined && principal.userID !== null) {
		var header=new E2E_XMLElementNode('soap:Header');
		var security=new E2E_XMLElementNode('wsse:Security');
		security.appendNamespace("xmlns:wsse='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wsswssecurity-secext-1.0.xsd'");
		var usernameToken=new E2E_XMLElementNode('wsse:UsernameToken');
		var username=new E2E_XMLElementNode('wsse:Username');
		username.setValue(principal.userID);
		var password=new E2E_XMLElementNode('wsse:Password');
		password.setValue(principal.userToken);

		usernameToken.appendChildElement(username);
		usernameToken.appendChildElement(password);

		if (principal.userTokenTimestamp !== undefined && principal.userTokenTimestamp !== null) {
			var created=new E2E_XMLElementNode('wsu:Created');
			created.appendNamespace("xmlns:wsu='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wsswssecurity-utility-1.0.xsd'");
			created.setValue(principal.userTokenTimestamp);
		
			usernameToken.appendChildElement(created);
		}	
		
		security.appendChildElement(usernameToken);
		header.appendChildElement(security);
		envelope.appendChildElement(header);
	}
	
	return envelope;
}

function e2eEscapeXML(value) {
	if (value !== undefined && value !== null) {
		if (typeof(value) == "string") {
			return value.replace(/</g,"&lt;").replace(/>/g, "&gt;").replace(/\&/g, "&amp;").replace(/\"/g, "&quot;");
		} else {
			return value.toString();
		}
	} else {
		return "";
	}
}

function E2E_XMLAttributeNode(name, value) {
	this.name = name;
	this.value = e2eEscapeXML(value);
}

function E2E_XMLElementNode(name) {
	this.name = name;
	this.value = null; // we have either values or children
	this.namespaces = []; // array of xmlns strings: xmlns:ns1='...' xmlns:ns2='...'
	this.children = []; // array of XML element nodes
	this.attributes = []; // array of XML attribute nodes
	
	this.serialize = function() {
		var elementStart = "<" + this.name; 
		if (this.namespaces) { elementStart += " " + this.namespaces.join(" "); }
		for (var i=0; i < this.attributes.length; i++) {
			elementStart += " " + this.attributes[i].name + "=\"" + this.attributes[i].value + "\"";
		}
		elementStart += ">";
		var innerXML = "";
		if (this.value) { innerXML += this.value; }
		for (var j=0; j < this.children.length; j++) {
			innerXML = innerXML + this.children[j].serialize();
		}
		var elementEnd = "</" + this.name + ">";
		return elementStart + innerXML + elementEnd;
	}
	this.appendChildElement = function(child) {
		this.children.push(child);
	}
	this.appendAttribute = function(attribute) {
		this.attributes.push(attribute);
	}
	this.appendNamespace = function(child) {
		this.namespaces.push(child);
	}
	this.setValue = function(value) {
		this.value = e2eEscapeXML(value);
	}
}

function e2eCreateXMLNode(nParent, sElementName, sElementNamespace) {
		var nElement = new E2E_XMLElementNode(sElementName);
		nElement.appendNamespace(sElementNamespace);
		nParent.appendChildElement(nElement);
		return nElement;
}

function e2eBindXMLElement(nParent, sElementName, sElementNamespace, sHtmlId, sHtmlType, sType, sHtmlInfo) {
		var nElement = e2eCreateXMLNode(nParent, sElementName, sElementNamespace);
		var sValue = e2eGetValueFromHtml(sHtmlId, sHtmlType, sType, sHtmlInfo);
		nElement.setValue(sValue);
		return nElement;
}

function e2eBindValueToXMLElement(nParent, sElementName, sElementNamespace, sValue, bRemoveMarkup) {
		var nElement = e2eCreateXMLNode(nParent, sElementName, sElementNamespace);
		nElement.setValue(bRemoveMarkup ? e2eRemoveMarkup(sValue) : sValue);
}

function e2eBindValueToXMLAttribute(nElement, sAttributeName, sValue, bRemoveMarkup) {
		var nAttribute = new E2E_XMLAttributeNode(sAttributeName, bRemoveMarkup ? e2eRemoveMarkup(sValue) : sValue);
		nElement.appendAttribute(nAttribute);
}

function e2eRemoveMarkup(s) {
	return (s.replace(/<[^>]+>/g, ""));
}

function e2eGetValueFromHtml(sHtmlId, sHtmlType, sType, sHtmlInfo) {
		var nHTMLNode = document.getElementById(sHtmlId);
		// NEWUI_TODO: e2eTraceMessage(sElementName + " = #" + sHtmlId);
		
		var sValue = "";
		if (sHtmlType === 'CheckBox' || sHtmlType === 'RadioButton') {
			sValue = nHTMLNode.checked.toString() == 'true';
		} else if (sHtmlType === 'Label') {
			sValue = e2eGetChildNodeValue(nHTMLNode);
		} else if (sHtmlType === 'ComboBox') {
			if (sHtmlInfo === 'value') {
				sValue = nHTMLNode.selectedIndex > -1 ? $(nHTMLNode.options[nHTMLNode.selectedIndex]).val() : null;
			} else if (sHtmlInfo === 'text') {
				sValue = nHTMLNode.selectedIndex > -1 ? nHTMLNode.options[nHTMLNode.selectedIndex].text : null;
			} else if (sHtmlInfo === 'selected' || sHtmlInfo === 'defaultSelected') {
				sValue = nHTMLNode.selectedIndex;
			} else {
				sValue = nHTMLNode.selectedIndex > -1 ? nHTMLNode.options[nHTMLNode.selectedIndex].text : null;
			}
		} else {
			if (sType === 'DateTime') {
				sValue = e2eGetSOAPDateString($(nHTMLNode));
			} else if (sType === 'Float') {
				sValue = e2eGetSOAPNumberString($(nHTMLNode));
			} else {
				sValue = e2eGetText($(nHTMLNode));
			} 
		}
		
		return sValue;
}

function e2eBindXMLAttribute(nElement, sAttributeName, sHtmlId, sHtmlType, sType, sHtmlInfo) {
		var sValue = e2eGetValueFromHtml(sHtmlId, sHtmlType, sType, sHtmlInfo);
		e2eTraceMessage(sAttributeName + " = #" + sHtmlId);
		var nAttribute = new E2E_XMLAttributeNode(sAttributeName, sValue);
		nElement.appendAttribute(nAttribute);
}

function e2eGetXMLHttpRequest() {
	var httpReq = null;
	if (window.XMLHttpRequest) {
		httpReq = new XMLHttpRequest();
	} else if (typeof ActiveXObject != "undefined") {
		httpReq = new ActiveXObject("Microsoft.XMLHTTP");
	} else {
		alert("Your browser does not support XMLHTTP!");
	}
	return httpReq;
}

// finding parsing errors, do not work for safari
function e2eHasParseError(oE2EResponse) {
	var hasError = false;
	if (typeof ActiveXObject != "undefined") { // IE
		var parseError = oE2EResponse.xmlDOM.parseError;
		if (parseError.reason) {
			alert("Parser Error: Reason: " + parseError.reason + " Line: " + parseError.line + " Column: " + parseError.linepos);
			hasError = true;
		}
	} else if (oE2EResponse.xmlDOM.lastChild.localName == "parsererror") {  // FF     
		alert("Parser Error: " + oE2EResponse.xmlDOM.lastChild.firstChild.data);
		hasError = true;
	}
	return hasError;
}

function E2E_XMLResponse(docString, htmlDocument, oController) {
	this.xmlDOM = e2eParseXML(docString);
	this.htmlDocument = htmlDocument;
	this.oController = oController;
	
	this.getElements = e2eGetElements;
	this.getFirstElement = e2eGetFirstElement;
	this.getChildElements = e2eGetChildElements;
	this.traverseForElements = e2eTraverseForElements;
	this.getAttribute = e2eGetAttribute;
	this.getChildNode = e2eGetChildNode;
	
	this.bindXMLAttribute = function(oElement, sAttributeName, sAttributeNamespace, sHtmlId, sHtmlType, sType) {
		var oAttribute = this.getAttribute(oElement, sAttributeName, sAttributeNamespace);
		var oHtmlNode = this.htmlDocument.getElementById(sHtmlId);
		var sValue = e2eGetNodeValue(oAttribute);
		
		this.setHTMLNodeValue(oHtmlNode, sValue, sHtmlId, sHtmlType, sType);
	
		e2eTraceMessage("Bind attribute '" + sAttributeName + "' to #" + sHtmlId + "='" + sValue + "'");		
	}
	
	this.bindXMLElement = function(oRoot, sElementName, sElementNamespace, sHtmlId, sHtmlType, sType) {
		var oElement = this.getChildElements(oRoot, sElementName, sElementNamespace)[0];
		var oHtmlNode = this.htmlDocument.getElementById(sHtmlId);
		var sValue = e2eGetChildNodeValue(oElement);

		this.setHTMLNodeValue(oHtmlNode, sValue, sHtmlId, sHtmlType, sType);

		e2eTraceMessage("Bind element '" + sElementName + "' to #" + sHtmlId + "='" + sValue + "'");		
	}
	
	this.setHTMLNodeValue = function(oHtmlNode, sValue, sHtmlId, sHtmlType, sType) {		
		if (sHtmlType === 'TextArea' || sHtmlType === 'TextField') {
			$(oHtmlNode).val(sValue);
		} else if (sHtmlType === 'CheckBox' || sHtmlType === 'RadioButton') {
			oHtmlNode.checked = sValue == 'true';
		} else {
			oHtmlNode.innerHTML = sValue;
		}
		
		if (sType === 'DateTime') {
			e2eFormatSOAPDate($(oHtmlNode));
		} else if (sType === 'Float') {
			e2eFormatSOAPNumber($(oHtmlNode));
		} else if (sType === 'Integer') {
			e2eFormatSOAPInteger($(oHtmlNode));
		} 
	}
	
	this.bindDropDownList = function(oElement, sHtmlId, oOptionBinding) {
		var oHtmlNode = document.getElementById(sHtmlId);
		for (var i = oHtmlNode.length; i >= 0; i--) {
			oHtmlNode[i] = null;
			e2eTraceMessage("Deleting select#" + sHtmlId + "[" + i + "] entry before binding the new response values.");
		}
		
		for (var i = 0; i < oElement.length; i++) {
				var oOption = oElement[i];
				var sNameOption = oOptionBinding.name ? this.getValue(oOption, oOptionBinding.name[0], oOptionBinding.name[1], oOptionBinding.name[2]) : null;
				var sValueOption = oOptionBinding.value ? this.getValue(oOption, oOptionBinding.value[0], oOptionBinding.value[1], oOptionBinding.value[2]) : null;
				var bDefaultSelectedOption = oOptionBinding.defaultSelected ? this.getValue(oOption, oOptionBinding.defaultSelected[0], oOptionBinding.defaultSelected[1], oOptionBinding.defaultSelected[2]) == "true" : null;
				var bSelectedOption = oOptionBinding.selected ? this.getValue(oOption, oOptionBinding.selected[0], oOptionBinding.selected[1], oOptionBinding.selected[2]) == "true" : null;
				oHtmlNode[i] = new Option(sNameOption, sValueOption, bDefaultSelectedOption, bSelectedOption);
				e2eTraceMessage("Deleting select#" + sHtmlId + "[" + i + "] = '" + sNameOption + "'");
		}
	}

	this.getValue = function(oElement, sElementType, sName, sNamespace) {
		if (sElementType === 'A' ) {
			return e2eGetNodeValue(this.getAttribute(oElement, sName, sNamespace));
		} else if (sElementType === 'E' ) {
			return e2eGetChildNodeValue(this.getChildElements(oElement, sName, sNamespace)[0]);
		} else {
			alert("getValue: found unknown element type '" + sElementType + "'. We support 'A' (Attribute) and 'E' (Element).");
		}
	}
	
	this.bindXMLAttribute2Controller = function(oElement, sAttributeName, sAttributeNamespace, sControllerAttribute, sType) {
		var oAttribute = this.getAttribute(oElement, sAttributeName, sAttributeNamespace);
		
		this.setControllerValue(oAttribute, sControllerAttribute, sType);
	
		e2eTraceMessage("Bind attribute '" + sAttributeName + "' to controller attribute " + sControllerAttribute);		
	}
	
	this.bindXMLElement2Controller = function(oRoot, sElementName, sElementNamespace, sControllerAttribute, sType) {
		var oElement = this.getChildElements(oRoot, sElementName, sElementNamespace)[0];
	
		this.setControllerValue(oElement, sControllerAttribute, sType);
	
		e2eTraceMessage("Bind element '" + sElementName + "' to controller attribute " + sControllerAttribute);		
	}
	
	this.setControllerValue = function(oNode, sControllerAttribute, sType) {		
		
		if (sType === 'Boolean') {
			this.oController[sControllerAttribute] = (e2eGetNodeValue(oNode) == "true");
		} else if (sType === 'Float') {
			this.oController[sControllerAttribute] = e2eGetNodeValue(oNode, null, parseFloat);
		} else if (sType === 'Integer') {
			this.oController[sControllerAttribute] = e2eGetNodeValue(oNode, null, parseInt);
		} else if (sType === 'DateTime') {
			this.oController[sControllerAttribute] = e2eGetNodeValue(oNode, null, e2eParseSOAPDateTime);
		} else {
			this.oController[sControllerAttribute] = e2eGetNodeValue(oNode, null);
		} 
	}

}

function e2eParseXML(xml) {
	if (typeof ActiveXObject != "undefined") {
		xmlDOM = new ActiveXObject("Microsoft.XmlDom");
		xmlDOM.loadXML(xml);
	} else {
		var parser = new DOMParser();
		xmlDOM = parser.parseFromString(xml, "text/xml");
	}
	return xmlDOM;
}

function e2eGetElements(name, namespace) {
	var elements = [];
	var xmlDOM = this.xmlDOM;
	if (namespace !== null) {
		if (typeof ActiveXObject != "undefined") {
			e2eTraverseForElements(xmlDOM.documentElement, name, namespace, elements, false);
		} else {
			elements = xmlDOM.getElementsByTagNameNS(namespace, name);
		}
	} else {
		elements = xmlDOM.getElementsByTagName(name);
	}
	return elements;
}

function e2eGetFirstElement(name, namespace) {
	var elements = [];
	var xmlDOM = this.xmlDOM;
	e2eTraverseForElements(xmlDOM.documentElement, name, namespace, elements, true);
	return elements[0];
}

function e2eGetChildElements(node, name, namespace) {
	var elements = [];
	var children = node.childNodes;
	if (children !== undefined && children !== null) {
		for (var i=0;i<children.length;i++) {
			var child = children[i];
			if (e2eMatchNode(child, name, namespace))  {
				elements.push(child);
			}
		}
	}
	return elements;
}

function e2eMatchNode(node, name, namespace) {
	if (node !== undefined && node !== null) {
		var nodeName = node.nodeName;
		var localName = nodeName.substring(nodeName.indexOf(':') + 1, nodeName.length);
		if (namespace !== undefined && namespace !== null && namespace !== '') {
			return (localName == name && node.namespaceURI == namespace);
		} else {
			return (localName == name);
		}
	} else {
		return false;
	}
}

function e2eTraverseForElements(currentNode, name, namespace, elements, firstOnly) {
	
	if (e2eMatchNode(currentNode, name, namespace))  {
		elements.push(currentNode);
		if (firstOnly) return;
	}
	
	var children = currentNode.childNodes;
	for (var i=0;i<children.length;i++) {
		e2eTraverseForElements(children[i], name, namespace, elements, firstOnly);
	}
}

// first child node having the given name and namespace
function e2eGetChildNode(currentNode, name, namespace) {

	var children = currentNode.childNodes;

	for (var i=0;i<children.length;i++) {
		var child = children[i];
		if (e2eMatchNode(child, name, namespace))  {
			return child;
		}
	}
	return null;
}

function e2eGetAttribute(element, name, namespace) {
	var attribute = null;

	if (element !== undefined && element != null && element.attributes !== undefined && element.attributes !== null) {
		var attributes= element.attributes;
		if (namespace) {
			if (typeof ActiveXObject != "undefined") {
					for (var i=0;i<attributes.length;i++) {
						var item = attributes.item(i);
						if (e2eMatchNode(item, name, namespace)) {
							attribute = item;
							return attribute;
						}
					}
			} else {
					attribute = attributes.getNamedItemNS(namespace, name);
			}
		} else {
			attribute = attributes.getNamedItem(name);
		}
	}
		
	return attribute;
}

function e2eConsoleLog(sLogType, any) {
	if (window.console !== undefined && console[sLogType] !== undefined) {
		console[sLogType](any);
	} else if (window.firebug !== undefined && firebug.d.console.cmd[sLogType] !== undefined) {
		firebug.d.console.cmd[sLogType](any);
	}
}

function e2eLogXML(title, xmlString) {
               e2eGroup(title);
               var node = e2eParseXML(xmlString);
               e2eConsoleLog('dirxml', node);
               e2eGroupEnd();
}

function e2eLog(message) {
	e2eConsoleLog('log', message);
}

function e2eDir(object) {
	e2eConsoleLog('dir', object);
}

function e2eGroup(title) {
	e2eConsoleLog('group', title);
}

function e2eGroupEnd() {
	e2eConsoleLog('groupEnd');
}

function e2eIsTraceOn() {
	return (window.oE2EGlobals  !== undefined && window.oE2EGlobals.bE2ETrace);
}

function e2eTraceObject(title, object) {
	if (e2eIsTraceOn()) {
		e2eGroup(title);
		e2eDir(object);
		e2eGroupEnd();
	}
}
function e2eTraceMessage(message) {
	if (e2eIsTraceOn()) {
		e2eLog(message);
	}
}

function e2eTraceOpen(title) {
	if (e2eIsTraceOn()) {
		e2eGroup(title);
	}
}

function e2eTraceClose() {
	if (e2eIsTraceOn()) {
		e2eGroupEnd();
	}
}

function e2eGetValidArrayIndex(index) {
	return (index > -1 ? index : 0);
}

/* Parses a query string and returns an object containing the parsed data. A
 * custom query string can supplied, or the query string from the current
 * document's URL can be used. The return value is an object whose property
 * names and values correspond to the decoded query data. Because a single key
 * may occur multiple times in a query string, the properties of the returned
 * object consist of arrays of values. The parameter is:
 *
 * queryString - the queryString to parse. This parameter is optional, and if it
 *               is not supplied then the query string from the current
 *               document's URL is used. The query string may start with a
 *               question mark, spaces may be encoded either as plus signs or
 *               the escape sequence '%20', and both ampersands and semicolons
 *               are permitted as separators.
 */
function e2eParseQueryString(queryString){

  // define an object to contain the parsed query data
  var result = {};

  // if a query string wasn't specified, use the query string from the URI
  if (queryString == undefined){
    queryString = location.search ? location.search : '';
  }

  // remove the leading question mark from the query string if it is present
  if (queryString.charAt(0) == '?') queryString = queryString.substring(1);

  // replace plus signs in the query string with spaces
  queryString = queryString.replace(/\+/g, ' ');

  // split the query string around ampersands and semicolons
  var queryComponents = queryString.split(/[&;]/g);

  // loop over the query string components
  for (var i = 0; i < queryComponents.length; i++){

    // extract this component's key-value pair
    var keyValuePair = queryComponents[i].split('=');
    var key = decodeURIComponent(keyValuePair[0]);
    var value = decodeURIComponent(keyValuePair[1]);

    // update the parsed query data with this component's key-value pair
    if (!result[key]) result[key] = [];
    result[key].push((keyValuePair.length == 1) ? '' : value);

  }

  // return the parsed query data
  return result;

}

function e2eGetAODataElementByName(aoData, sName) {
	for (var index=0, length=aoData.length; index < length; index++) {
		var element = aoData[index];
		if (element.name === sName) return element.value;
	}
	return null;
}

function e2eGetSortCompareObject () {
	var oSort = {
		/*
		 * text sorting
		 */
		"string-asc": function ( a, b ) {
			var x = a.toLowerCase();
			var y = b.toLowerCase();
			return ((x < y) ? -1 : ((x > y) ? 1 : 0));
		},
		
		"string-desc": function ( a, b ) {
			var x = a.toLowerCase();
			var y = b.toLowerCase();
			return ((x < y) ? 1 : ((x > y) ? -1 : 0));
		},
		
		
		/*
		 * html sorting (ignore html tags)
		 */
		"html-asc": function ( a, b ) {
			var x = a.replace( /<.*?>/g, "" ).toLowerCase();
			var y = b.replace( /<.*?>/g, "" ).toLowerCase();
			return ((x < y) ? -1 : ((x > y) ? 1 : 0));
		},
		
		"html-desc": function ( a, b ) {
			var x = a.replace( /<.*?>/g, "" ).toLowerCase();
			var y = b.replace( /<.*?>/g, "" ).toLowerCase();
			return ((x < y) ? 1 : ((x > y) ? -1 : 0));
		},
		
		
		/*
		 * date sorting
		 */
		"date-asc": function ( a, b ) {
			var x = Date.parse( a );
			var y = Date.parse( b );
			
			if ( isNaN( x ) ) {
				x = Date.parse( "01/01/1970 00:00:00" );
			}
			if ( isNaN( y ) ) {
				y =	Date.parse( "01/01/1970 00:00:00" );
			}
			
			return x - y;
		},
		
		"date-desc": function ( a, b ) {
			var x = Date.parse( a );
			var y = Date.parse( b );
			
			if ( isNaN( x ) ) {
				x = Date.parse( "01/01/1970 00:00:00" );
			}
			if ( isNaN( y ) ) {
				y =	Date.parse( "01/01/1970 00:00:00" );
			}
			
			return y - x;
		},
		
		
		/*
		 * numerical sorting
		 */
		"numeric-asc": function ( a, b ) {
			var x = a == "-" ? 0 : a;
			var y = b == "-" ? 0 : b;
			return x - y;
		},
		
		"numeric-desc": function ( a, b ) {
			var x = a == "-" ? 0 : a;
			var y = b == "-" ? 0 : b;
			return y - x;
		}
	};

	return oSort;
}

function e2eGetTableElementComparator(oSettings) {
	var fnLocalSorting;
	var sDynamicSort = "fnLocalSorting = function(a,b){"+
		"var iTest, oSort=e2eGetSortCompareObject();";
	var aaSort = [];
	
	if ( oSettings.aaSortingFixed !== null ) {
		aaSort = oSettings.aaSortingFixed.concat( oSettings.aaSorting );
	} else {
		aaSort = oSettings.aaSorting.slice();
	}
		
	var iColumnIndex = aaSort[aaSort.length-1][0];
	var iDataSort = oSettings.aoColumns[ iColumnIndex ].iDataSort;
	var iDataType = oSettings.aoColumns[ iDataSort ].sType;
	
	sDynamicSort += "iTest = oSort['"+iDataType+"-"+aaSort[aaSort.length-1][1]+"']"+
		"( a["+iDataSort+"], b["+iDataSort+"] );"+
		"if (iTest===0) return oSort['numeric-"+aaSort[aaSort.length-1][1]+"'](a, b); "+
		"return iTest;}";
	
	/* The eval has to be done to a variable for IE */
	fnLocalSorting = eval( sDynamicSort );
	return fnLocalSorting;
}

function e2eGetDecimalSeparator(sLocale) {
	 if (
		sLocale == "de" ||
		sLocale == "vn" ||
		sLocale == "es" ||
		sLocale == "dk" ||
		sLocale == "at" ||
		sLocale == "gr" ||
		sLocale == "br" ||
		sLocale == "cz" ||
		sLocale == "fr" ||
		sLocale == "fi" ||
		sLocale == "ru" ||
		sLocale == "se") {
		return ",";
	 } else {
		return ".";
	 }
};

function e2eMapLanguage2Region(sLangTag) {
	var oMap = {
		"af": "ZA", // South Africa (Africaans)
		"ar": "AE", // Arab Emirates
		"az": "AZ", // Azerbaijan
		"bg": "BG", // Bulgaria
		"bs": "BA", // Bosnia and Herzegovina
		"ca": "ES", // Spain (Catalan)
		"cs": "CZ", // Czech Republic
		"da": "DK", // Denmark
		"de": "DE", // Germany
		"el": "GR", // Greece
		"en": "US", // United States
		"es": "ES", // Spain
		"et": "EE", // Estonia
		"eu": "ES", // Spain (Basque)
		"fa": "IQ", // Iraq (Persian)
		"fi": "FI", // Finland
		"fo": "FO", // Faroe Islands
		"fr": "FR", // France
		"he": "IL", // Israel
		"hr": "HR", // Croatia
		"hi": "IN", // India
		"hu": "HU", // Hungary
		"hy": "AM", // Armenia
		"id": "ID", // Indonesia
		"is": "IS", // Iceland
		"it": "IT", // Italy
		"ja": "JP", // Japan
		"ko": "KR", // South Korea
		"lt": "LT", // Lithuania
		"lv": "LV", // Latvia
		"ms": "MY", // Malaysia
		"nl": "NL", // Netherlands
		"no": "NO", // Norway
		"pl": "PL", // Poland
		"pt": "PT", // Portugal
		"ro": "RO", // Romania
		"ru": "RU", // Russia
		"sk": "SK", // Slovakia
		"sl": "SI", // Slovenia
		"sq": "AL", // Albania
		"sr": "RS", // Serbia
		"sv": "SE", // Sweden
		"ta": "LK", // Sri Lanka
		"th": "TH", // Thailand
		"tr": "TR", // Turkey
		"uk": "UA", // Ukraine
		"vi": "VN", // Viet Nam
		"zh": "CN" // China
	}
	if (oMap[sLangTag] !== undefined) {
		return oMap[sLangTag];
	} else {
		return "US";
	}
}

/*
 * jQuery UI flyout menu 
 *   - written for jQuery UI 1.9 milestone 2 using the widget factory
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * modified from: http://view.jqueryui.com/menu/tests/visual/menu/nested.html
 * 	by: Michael Lang, http://nexul.com/
 *
 */
(function($) {
$.widget("ui.flyoutmenu", {
	_create: function(){
		var self = this;
		this.active = this.element;
		this.activeItem = this.element.children("li").first();
		// hide submenus and create indicator icons
		this.element.find("ul").addClass("ui-menu-flyout").hide()
			.prev("a").prepend('<span class="ui-icon ui-icon-carat-1-e"></span>');
		
		this.element.find("ul").andSelf().menu({
			// disable built-in key handling
			input: (!this.options.input)? $() : this.options.input,
			select: this.options.select,
			focus: function(event, ui) {
				self.active = ui.item.parent();
				self.activeItem = ui.item;
				ui.item.parent().find("ul").hide();
				var nested = $(">ul", ui.item);
				if (nested.length && /^mouse/.test(event.originalEvent.type)) {
					self._open(nested);
				}
			}
		}).keydown(function(event) {
			if (self.element.is(":hidden"))
				return;
			event.stopPropagation();
			switch (event.keyCode) {
			case $.ui.keyCode.PAGE_UP:
				self.pageup(event);
				break;
			case $.ui.keyCode.PAGE_DOWN:
				self.pagedown(event);
				break;
			case $.ui.keyCode.UP:
				self.up(event);
				break;
			case $.ui.keyCode.LEFT:
				self.left(event);
				break;
			case $.ui.keyCode.RIGHT:
				self.right(event);
				break;
			case $.ui.keyCode.DOWN:
				self.down(event);
				break;
			case $.ui.keyCode.ENTER:
			case $.ui.keyCode.TAB:
				self._select(event);
				event.preventDefault();
				break;
			case $.ui.keyCode.ESCAPE:
				self.hide();
				break;
			default:
				clearTimeout(self.filterTimer);
				var prev = self.previousFilter || "";
				var character = String.fromCharCode(event.keyCode);
				var skip = false;
				if (character == prev) {
					skip = true;
				} else {
					character = prev + character;
				}
				
				var match = self.activeItem.parent("ul").children("li").filter(function() {
					return new RegExp("^" + character, "i").test($("a", this).text());
				});
				var match = skip && match.index(self.active.next()) != -1 ? match.next() : match;
				if (!match.length) {
					character = String.fromCharCode(event.keyCode);
					match = self.widget().children("li").filter(function() {
						return new RegExp("^" + character, "i").test($(this).text());
					});
				}
				if (match.length) {
					self.activate(event, match);
					if (match.length > 1) {
						self.previousFilter = character;
						self.filterTimer = setTimeout(function() {
							delete self.previousFilter;
						}, 1000);
					} else {
						delete self.previousFilter;
					}
				} else {
					delete self.previousFilter;
				}
			}
		});
	},
	_open: function(submenu) {
		//only one menu can have items open at a time.
		$(document).find(".ui-menu-flyout").not(submenu.parents()).hide();
		submenu.show().css({
			top: 0,
			left: 0
		}).position({
			my: "left top",
			at: "right top",
			of: this.activeItem
		});
		$(document).one("click", function() {
				//clicking outside menu flyouts should close all flyouts
				$(document).find(".ui-menu-flyout").hide();
		})
	},
	_select: function(event){
		this.activeItem.parent().data("menu").select(event);
		$(document).find(".ui-menu-flyout").hide();	
		activate(event, self.element.children("li").first());
	},
	left: function(event){
		this.activate(event, this.activeItem.parents("li").first());
	},
	right: function(event){
		this.activate(event, this.activeItem.children("ul").children("li").first());
	},
	up: function(event) {
		if (this.activeItem.prev("li").length > 0){
			this.activate(event, this.activeItem.prev("li"));
		}else{
			this.activate(event, this.activeItem.parent("ul").children("li:last"));
		}
	},
	down: function(event) {
		if (this.activeItem.next("li").length > 0){
			this.activate(event, this.activeItem.next("li"));
		}else{
			this.activate(event, this.activeItem.parent("ul").children("li:first"));
		}
	},
	pageup: function(event){
		if (this.activeItem.prev("li").length > 0){
			this.activate(event, this.activeItem.parent("ul").children("li:first"));
		}else{
			this.activate(event, this.activeItem.parent("ul").children("li:last"));
		}
	},
	pagedown: function(event){
		if (this.activeItem.next("li").length > 0){
			this.activate(event, this.activeItem.parent("ul").children("li:last"));
		}else{
			this.activate(event, this.activeItem.parent("ul").children("li:first"));
		}
	},
	activate: function(event, item){
		if (item){
			item.parent().data("menu").widget().show();
			item.parent().data("menu").activate(event, item);
		}
		this.activeItem = item;
		this.active = item.parent("ul");
	},
	show: function() {
		this.active = this.element;
		this.element.show();
		if (this.element.hasClass("ui-menu-flyout")){
			$(document).one("click", function() {
				//clicking outside menu flyouts should close all flyouts
				$(document).find(".ui-menu-flyout").hide();
			})
		}
	},
	hide: function() {
		this.activeItem = this.element.children("li").first();
		this.element.find("ul").andSelf().menu("deactivate").hide();
	}
});
}(jQuery));

/*
 * jQuery UI flyout menu 
 *   - written for jQuery UI 1.9 milestone 2 using the widget factory
 *
 * Copyright (c) 2010 Michael Lang, http://nexul.com/
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 */
(function($) {
$.widget("ui.menubar", {
	_create: function(){
		var self = this;
		this.element.children("button, a").next("ul").each(function(i, elm){
			$(elm).flyoutmenu({
				select: self.options.select,
				input: $(elm).prev()
			}).hide().addClass("ui-menu-flyout");
		});
		this.element.children("button, a").each(function(i, elm){
			$(elm).click(function(event) {
				$(document).find(".ui-menu-flyout").hide();
				if ($(this).next().is("ul")){
					$(this).next().data("flyoutmenu").show();
					$(this).next().css({
						position:"absolute",
						top: 0,
						left: 0
					}).position({
						my: "left top",
						at: "left bottom",
						of: $(this)
					});
				} else {
					self.options.select(event, $(this));
				}
				event.stopPropagation();
			}).button({
				icons :{secondary: ($(elm).next("ul").length>0)? 'ui-icon-triangle-1-s':''}
			});
		});
	}
});
}(jQuery));

function e2eAutocompleteRequest(uri, input) {

	var oEnvelope = e2eGetSOAPEnvelope(null);
	var oBody = new E2E_XMLElementNode('soap:Body');
	oEnvelope.appendChildElement(oBody);

	var oUIAutocompletionRequest = new E2E_XMLElementNode('ui:UIAutocompletionRequest');
	oUIAutocompletionRequest.appendNamespace("xmlns:ui='http://e2e.ch/bridge/advancedBehavior/ui'");
	oBody.appendChildElement(oUIAutocompletionRequest);
	var oInput = new E2E_XMLAttributeNode('input', input);
	oUIAutocompletionRequest.appendAttribute(oInput);

	oE2EReq = e2eGetXMLHttpRequest();
	if (oE2EReq) {
		if (uri === undefined) {
			alert("Cannot call 'autocomplete' because the soap url is missing. Please, set the variable 'uri' in a loaded library.");
		} else {
			oE2EReq.open("POST", uri, false);
			oE2EReq.setRequestHeader("Content-Type", "text/xml");
			oE2EReq.setRequestHeader("SOAPAction", "urn:autocomplete");
			oE2EReq.onerror = function () { 
				alert("Error when calling 'autocomplete' on '" + uri + "'");
			}

			var sMsg = oEnvelope.serialize();
			oE2EReq.send(sMsg);
			return e2eAutocompleteResponse();
		}
	}
}

function e2eAutocompleteResponse() {
	var response = [];
	if (oE2EReq.readyState == 4) {
		if (oE2EReq.status == 200) {
			var sXml = oE2EReq.responseText;
			var oE2EResponse = new E2E_XMLResponse(sXml);

			var oE2EResponseBody = oE2EResponse.getFirstElement("Body", "http://schemas.xmlsoap.org/soap/envelope/");
			var oUIAutocompletionResponse = oE2EResponse.getChildElements(oE2EResponseBody, "UIAutocompletionResponse", "http://e2e.ch/bridge/advancedBehavior/ui")[0];

			var oItems = oE2EResponse.getChildElements(oUIAutocompletionResponse, "items", "http://e2e.ch/bridge/advancedBehavior/ui");

			for (var i=0; i<oItems.length; i++) {
				var oItem = oItems[i];
				var oOption = {}
				var labelNode = oE2EResponse.getAttribute(oItem, "label");
				var valueNode = oE2EResponse.getAttribute(oItem, "value");
				if (labelNode) oOption.label = labelNode.nodeValue;
				if (valueNode) oOption.value = valueNode.nodeValue;
				response.push(oOption);
			}
				
			return response;
		} else {
			alert("Error when calling 'autocomplete' on '" + uri + "'");
			return response;
		}
	} else {
		return response;
	}
}

function e2eErrorPlacement(error, element, dx, dy) {
	var xOffset = dx ? dx : 0;
	var yOffset = dy ? dy : 5;
	var top = element.position().top + element.height() + yOffset;
	var left = element.position().left + xOffset;
	error.css( { "position": "absolute", "left": left + "px", "top": top + "px" } );
	error.insertAfter(element);	
}