/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.junit;

import ch.e2e.ant.gui.junit.CounterPanel;
import ch.e2e.ant.gui.junit.FailureDetailView;
import ch.e2e.ant.gui.junit.JUnitFailureRunView;
import ch.e2e.ant.gui.junit.JUnitHierarchyRunView;
import ch.e2e.ant.gui.junit.JUnitProgressBar;
import ch.e2e.ant.gui.junit.JUnitStatusLine;
import ch.e2e.ant.gui.junit.TestRunView;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.test.TestSelectedEvent;
import ch.e2e.test.Testable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestView
extends JPanel
implements EventExecuter {
    private JTabbedPane testViewTab;
    private FailureDetailView failureView;
    private JUnitStatusLine statusLine;
    private JUnitProgressBar progressIndicator;
    private CounterPanel counterPanel;
    private JUnitFailureRunView failureRunView;
    private JUnitHierarchyRunView hierarchyRunView;

    public TestView() {
        super(new GridBagLayout());
        this.createGui();
        EventController.register((EventExecuter)this, TestSelectedEvent.class);
    }

    public void execute(final EventObject event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestView.this.failureView.testSelected((Testable)((TestSelectedEvent)event).getTests().get(0));
                TestView.this.statusLine.testSelected((Testable)((TestSelectedEvent)event).getTests().get(0));
                TestView.this.progressIndicator.testSelected((Testable)((TestSelectedEvent)event).getTests().get(0));
                TestView.this.counterPanel.testSelected((Testable)((TestSelectedEvent)event).getTests().get(0));
                TestView.this.failureRunView.testSelected((Testable)((TestSelectedEvent)event).getTests().get(0));
                TestView.this.hierarchyRunView.testSelected((Testable)((TestSelectedEvent)event).getTests().get(0));
                SwingUtilities.updateComponentTreeUI(TestView.this);
            }
        });
    }

    private void createGui() {
        JLabel progressLabel = new JLabel("Test progress ...");
        this.progressIndicator = new JUnitProgressBar();
        this.counterPanel = new CounterPanel();
        this.testViewTab = this.createTestRunViews();
        this.failureView = new FailureDetailView();
        JScrollPane tracePane = new JScrollPane(this.failureView.getComponent(), 22, 32);
        this.statusLine = new JUnitStatusLine(380);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 5, 3);
        this.add((Component)progressLabel, c);
        this.add((Component)this.progressIndicator, c);
        this.add((Component)this.counterPanel, c);
        this.add((Component)new JSeparator(), c);
        this.add((Component)new JLabel("Results:"), c);
        JSplitPane splitter = new JSplitPane(0, this.testViewTab, tracePane);
        c.fill = 1;
        c.weighty = 1.0;
        this.add((Component)splitter, c);
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.statusLine, c);
    }

    private JTabbedPane createTestRunViews() {
        JTabbedPane runViewPane = new JTabbedPane(3);
        this.failureRunView = new JUnitFailureRunView();
        this.failureRunView.addTab(runViewPane);
        this.hierarchyRunView = new JUnitHierarchyRunView();
        this.hierarchyRunView.addTab(runViewPane);
        runViewPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TestView.this.testViewChanged();
            }
        });
        return runViewPane;
    }

    private void testViewChanged() {
        this.failureView.clear();
        if (this.testViewTab.getSelectedComponent() instanceof JScrollPane) {
            TestRunView view = (TestRunView)((Object)((JScrollPane)this.testViewTab.getSelectedComponent()).getViewport().getView());
            view.activate();
        }
    }

    public void clear() {
        this.failureView.clear();
        this.failureRunView.clear();
        this.hierarchyRunView.clear();
        this.statusLine.clear();
        this.progressIndicator.reset();
        this.counterPanel.reset();
    }
}

