/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration.types;

import ch.e2e.ant.gui.configuration.ConfigurationParseException;
import ch.e2e.ant.gui.configuration.types.Iterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Loop
implements Iterator {
    private String str;
    private File file;
    private int count = Integer.MIN_VALUE;
    private int counter;
    private String delimiter = "; ";
    private String property = "next";
    private String[] values;

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public void setProperty(String property) {
        this.property = property;
    }

    public void setStr(String str) {
        if (this.count != Integer.MIN_VALUE || this.file != null) {
            throw new ConfigurationParseException("Only one of the attributes 'str', 'count' or 'file' must be set.");
        }
        this.str = str;
    }

    public void setCount(int count) {
        if (this.str != null || this.file != null) {
            throw new ConfigurationParseException("Only one of the attributes 'str', 'count' or 'file' must be set.");
        }
        this.count = count;
    }

    public void setFile(File file) {
        if (this.count != Integer.MIN_VALUE || this.str != null) {
            throw new ConfigurationParseException("Only one of the attributes 'str', 'count' or 'file' must be set.");
        }
        this.file = file;
    }

    @Override
    public boolean hasNext() {
        if (this.values == null) {
            this.initializeValues();
            this.counter = 0;
        }
        return this.counter < this.values.length;
    }

    public Object next() {
        if (this.values == null) {
            this.initializeValues();
            this.counter = 0;
        }
        if (this.counter > this.values.length - 1) {
            throw new NoSuchElementException("No more elements in the loop.");
        }
        return this.values[this.counter++];
    }

    @Override
    public void remove() {
    }

    @Override
    public int getIndex() {
        return this.counter;
    }

    private void initializeValues() {
        if (this.file != null) {
            this.values = this.readLines();
        } else if (this.str != null) {
            this.values = this.tokenizeString();
        } else if (this.count > -1) {
            this.values = new String[this.count];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = String.valueOf(i);
            }
        } else {
            throw new ConfigurationParseException("One of the attributes 'str', 'count' or 'file' must be set.");
        }
    }

    private String[] tokenizeString() {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.str, this.delimiter);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        String[] values = new String[tokens.size()];
        tokens.toArray(values);
        return values;
    }

    private String[] readLines() {
        ArrayList<String> lineList = new ArrayList<String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(this.file));
            String line = in.readLine();
            while (line != null) {
                lineList.add(line);
                line = in.readLine();
            }
        }
        catch (IOException ex) {
            throw new ConfigurationParseException(ex);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        String[] lines = new String[lineList.size()];
        lineList.toArray(lines);
        return lines;
    }
}

