/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant;

import ch.e2e.io.FileUtilities;
import ch.e2e.util.StringTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;

public class StringReplacer
extends Task {
    private String oldstr;
    private String newstr;
    private String value;
    private String property;
    private boolean ignorecase = false;
    private File file;
    private File backupFile;
    private ArrayList<Replacement> replacements = new ArrayList();

    public void execute() throws BuildException {
        if (this.file == null) {
            if (this.backupFile != null) {
                throw new BuildException("The attribute backupfile is only allowed if the attribute file is set.");
            }
            this.executeOneReplace();
        } else {
            this.executeFileReplacement();
        }
    }

    private void executeFileReplacement() throws BuildException {
        if (this.backupFile != null) {
            try {
                FileUtilities.copyFile((File)this.file, (File)this.backupFile, (boolean)true);
            }
            catch (IOException e) {
                Logger.getAnonymousLogger().severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                Logger.getAnonymousLogger().throwing(((Object)((Object)this)).getClass().getName(), "", e);
                throw new BuildException("Could not copy " + this.file + " to " + this.backupFile + ": " + e.getMessage());
            }
        }
        BufferedReader in = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            in = new BufferedReader(new FileReader(this.file));
            String line = in.readLine();
            while (line != null) {
                line = this.replaceAll(line);
                lines.add(line);
                in.readLine();
            }
        }
        catch (FileNotFoundException e) {
            Logger.getAnonymousLogger().severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logger.getAnonymousLogger().throwing(((Object)((Object)this)).getClass().getName(), "", e);
            throw new BuildException("could not open " + this.file + " for reading: " + e.getMessage());
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logger.getAnonymousLogger().throwing(((Object)((Object)this)).getClass().getName(), "", e);
            throw new BuildException("Error reading from " + this.file + ": " + e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(this.file));
            int length = lines.size();
            for (int i = 0; i < length; ++i) {
                String s = (String)lines.get(i);
                out.println(s);
            }
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            Logger.getAnonymousLogger().throwing(((Object)((Object)this)).getClass().getName(), "", e);
            throw new BuildException("Could not write to " + this.file + ": " + e.getMessage());
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private String replaceAll(String line) {
        int length = this.replacements.size();
        for (int i = 0; i < length; ++i) {
            Replacement replacement = this.replacements.get(i);
            line = StringTools.replaceAll((String)line, (String)replacement.oldstring, (String)replacement.newstring, (boolean)this.ignorecase);
        }
        return line;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setBackupFile(File backupFile) {
        this.backupFile = backupFile;
    }

    public Object createReplacement() {
        Replacement replacement = new Replacement();
        this.replacements.add(replacement);
        return replacement;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setOldstr(String oldstr) {
        this.oldstr = oldstr;
    }

    public void setNewstr(String newstr) {
        this.newstr = newstr;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setIgnorecase(boolean ignorecase) {
        this.ignorecase = ignorecase;
    }

    private void executeOneReplace() {
        if (this.replacements.size() == 0 && this.oldstr == null) {
            throw new BuildException("The attribute 'oldstr' must be specified.");
        }
        if (this.value == null) {
            throw new BuildException("The attribute 'value' must be specified.");
        }
        if (this.property == null) {
            throw new BuildException("The attribute 'property' must be specified.");
        }
        String value = PropertyHelper.getPropertyHelper((Project)this.getProject()).replaceProperties("", this.value, null);
        String oldstr = PropertyHelper.getPropertyHelper((Project)this.getProject()).replaceProperties("", this.oldstr, null);
        String newstr = PropertyHelper.getPropertyHelper((Project)this.getProject()).replaceProperties("", this.newstr, null);
        value = oldstr != null && newstr != null ? StringTools.replaceAll((String)value, (String)oldstr, (String)newstr, (boolean)this.ignorecase) : this.replaceAll(value);
        if (this.getProject().getUserProperty(this.property) != null) {
            this.getProject().setUserProperty(this.property, value);
        } else if (this.getProject().getProperty(this.property) != null) {
            this.getProject().setProperty(this.property, value);
        } else {
            this.getProject().setNewProperty(this.property, value);
        }
    }

    public class Replacement {
        private String oldstring;
        private String newstring;

        public void setNewString(String newstring) {
            this.newstring = newstring;
        }

        public void setOldString(String oldstring) {
            this.oldstring = oldstring;
        }
    }
}

