/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.xom;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.option.xom.XOMDocumentWrapper;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.ParsingException;

public class XomUriResolver
extends StandardURIResolver {
    public XomUriResolver(Configuration config) {
        super(config);
    }

    @Override
    public Source resolve(String href, String base) throws XPathException {
        URI url;
        String relativeURI = href;
        int hash = href.indexOf(35);
        if (hash >= 0) {
            relativeURI = href.substring(0, hash);
        }
        try {
            relativeURI = ResolveURI.escapeSpaces(relativeURI);
            new URI(relativeURI);
        }
        catch (URISyntaxException err) {
            throw new XPathException("Invalid relative URI " + Err.wrap(relativeURI), err);
        }
        try {
            url = ResolveURI.makeAbsolute(relativeURI, base);
        }
        catch (URISyntaxException err) {
            String expandedBase = ResolveURI.tryToExpand(base);
            if (!expandedBase.equals(base)) {
                return this.resolve(href, expandedBase);
            }
            throw new XPathException("Invalid URI " + Err.wrap(relativeURI) + " - base " + Err.wrap(base), err);
        }
        try {
            Builder builder = new Builder();
            Document doc = builder.build(url.toString());
            doc.setBaseURI(url.toString());
            if (this.getConfiguration() == null) {
                throw new XPathException("XomUriResolver requires access to the Configuration");
            }
            return new XOMDocumentWrapper((Node)doc, this.getConfiguration());
        }
        catch (IOException io) {
            throw new XPathException(io);
        }
        catch (ParsingException pe) {
            throw new XPathException(pe);
        }
    }
}

