/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.parameter;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.TextEditorDialog;
import ch.e2e.builder.trace.testcase.parameter.StringParameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.tree.TreeCellEditor;

public class StringEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private JFormattedTextField editor;
    private String data;
    private E2EBuilderModule module;

    public StringEditor(E2EBuilderModule module) {
        this.module = module;
        this.editor = new JFormattedTextField(new JFormattedTextField.AbstractFormatter(){

            @Override
            public Object stringToValue(String text) throws ParseException {
                return text.replace('\u21b5', '\n');
            }

            @Override
            public String valueToString(Object value) throws ParseException {
                return value == null ? "" : value.toString().replace('\n', '\u21b5');
            }
        });
        this.editor.setColumns(40);
        this.editor.setBackground(Color.WHITE);
        this.editor.setOpaque(true);
        this.editor.getInputMap().put(KeyStroke.getKeyStroke(10, 128), "insertNewline");
        this.editor.getActionMap().put("insertNewline", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pos = StringEditor.this.editor.getCaretPosition();
                try {
                    StringEditor.this.editor.getDocument().insertString(pos, "\u21b5", null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.editor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        if (this.data == null) {
            try {
                this.editor.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return this.editor.getValue();
        }
        return this.data;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (value instanceof StringParameter) {
            this.data = (String)((StringParameter)value).getValue();
            if (this.data != null && this.data.length() > 3 * this.editor.getColumns()) {
                TextEditorDialog realEditor = TextEditorDialog.getDialog(this.module);
                if (realEditor.showText(this.data, ((StringParameter)value).isTruncated()) == 1) {
                    this.data = realEditor.getText();
                }
            } else {
                this.editor.setValue(this.data);
                this.data = null;
            }
        }
        return this.editor;
    }
}

