/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.xslt;

import ch.e2e.bridge.server.xslt.XSLTLogger;
import ch.e2e.bridge.server.xslt.XSLTScript;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;

public class XSLTTransformerFactory
extends BaseKeyedPoolableObjectFactory<XSLTScript, Transformer> {
    private static HashMap<String, TransformerFactory> transformerFactories = new HashMap();

    public Transformer makeObject(XSLTScript xsltScript) throws Exception {
        long time = new Date().getTime();
        TransformerFactory factory = XSLTTransformerFactory.getTransformerFactory(xsltScript.getTransformerFactory());
        Transformer transformer = factory.newTransformer(this.getSource(xsltScript));
        long time1 = new Date().getTime();
        xsltScript.getSession().log(5L, "JAVA", "XSLT", "XSLTTransformerFactory.makeObject", String.format("transformer loaded in %d ms", time1 - time));
        return transformer;
    }

    public boolean validateObject(XSLTScript key, Transformer obj) {
        return super.validateObject((Object)key, (Object)obj);
    }

    public void destroyObject(XSLTScript key, Transformer adapter) throws Exception {
        super.destroyObject((Object)key, (Object)adapter);
    }

    public static TransformerFactory getTransformerFactory(String factoryClassName) {
        TransformerFactory transformerFactory = transformerFactories.get(factoryClassName);
        if (transformerFactory == null) {
            try {
                Class<?> factoryClass = Class.forName(factoryClassName);
                transformerFactory = (TransformerFactory)factoryClass.newInstance();
                transformerFactories.put(factoryClassName, transformerFactory);
            }
            catch (Exception e) {
                try {
                    XSLTLogger.getInstance().info("3", String.format("Could not load the TransformerFactory '%s', loading default factory", factoryClassName));
                    transformerFactory = TransformerFactory.newInstance();
                    transformerFactories.put(factoryClassName, transformerFactory);
                }
                catch (Exception e1) {
                    XSLTLogger.getInstance().error("3", String.format("Caught a %s: %s", e.getClass().getName(), e.getMessage()), e);
                }
            }
        }
        return transformerFactory;
    }

    private StreamSource getSource(XSLTScript xsltScript) {
        String name = xsltScript.getName();
        File xsltSrcDir = new File("repository/xslt/src");
        File xsltFile = new File(xsltSrcDir, name);
        return new StreamSource(xsltFile);
    }
}

