/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.wrapper;

import ch.e2e.bridge.server.CyclicDependencyException;
import ch.e2e.bridge.server.Wrapper;
import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import ch.e2e.bridge.server.jms.wrapper.StringMap;
import ch.e2e.bridge.server.session.Session;
import java.util.Map;

public class JMSSessionParameterWrapper
extends Wrapper {
    private Class originalClass = JMSSessionParameter.class;
    private boolean fill = false;
    private Map<String, String> stringProperties;

    public JMSSessionParameterWrapper(Session session) {
        super(session);
    }

    public JMSSessionParameterWrapper(RecordItem recordItem, Session session) {
        super(recordItem, session);
    }

    @Override
    public void fill(Object object) {
        if (this.fill) {
            throw new CyclicDependencyException(this.originalClass);
        }
        this.fill = true;
        JMSSessionParameter value = (JMSSessionParameter)object;
        this.setAcknowledgeMode(value.getConnectionInfo().getMode());
        this.setName(value.getConnectionInfo().getName());
        this.setConnectionFactoryClass(value.getConnectionFactoryClass());
        this.setProperties(value.getProperties());
        this.setUser(value.getConnectionInfo().getUser());
        this.setPassword(value.getConnectionInfo().getPassword());
        this.fill = false;
    }

    @Override
    protected String getFullQualifiedModelName() {
        return "urn:Base_Components.Add_Ons.JMS.JMSSessionParameter";
    }

    @Override
    protected Object createObject() {
        JMSSessionParameter result = new JMSSessionParameter();
        result.getConnectionInfo().setMode(this.getAcknowledgeMode());
        result.setConnectionFactoryClass(this.getConnectionFactoryClass());
        result.getConnectionInfo().setName(this.getName());
        result.setProperties(this.getProperties());
        result.getConnectionInfo().setUser(this.getUser());
        result.getConnectionInfo().setPassword(this.getPassword());
        return result;
    }

    private String getAcknowledgeMode() {
        StringItem stringItem = this.getRecordItem().getStringItem(0);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setAcknowledgeMode(String value) {
        this.setValue(0, value);
    }

    private String getName() {
        StringItem stringItem = this.getRecordItem().getStringItem(1);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setName(String value) {
        this.setValue(1, value);
    }

    public String getConnectionFactoryClass() {
        StringItem stringItem = this.getRecordItem().getStringItem(2);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setConnectionFactoryClass(String value) {
        this.setValue(2, value);
    }

    public Map<String, String> getProperties() {
        if (this.stringProperties == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(3);
            this.stringProperties = (Map)arrayItem.fillArrayClass(Map.class, StringMap.class);
        }
        return this.stringProperties;
    }

    public void setProperties(Map stringProperties) {
        this.stringProperties = stringProperties;
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(3);
        arrayItem.setValues(stringProperties, StringMap.class);
    }

    public String getUser() {
        StringItem stringItem = this.getRecordItem().getStringItem(4);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setUser(String value) {
        this.setValue(4, value);
    }

    public String getPassword() {
        StringItem stringItem = this.getRecordItem().getStringItem(5);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setPassword(String value) {
        this.setValue(5, value);
    }
}

