/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.wrapper;

import ch.e2e.bridge.server.CyclicDependencyException;
import ch.e2e.bridge.server.dataitem.BlobItem;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.jms.JMSInitialContext;
import ch.e2e.bridge.server.jms.impl.JMSAddOnHelper;
import ch.e2e.bridge.server.jms.impl.JMSBytesMessageImpl;
import ch.e2e.bridge.server.jms.parameter.JMSBytesMessage;
import ch.e2e.bridge.server.jms.wrapper.JMSMessageWrapper;
import ch.e2e.bridge.server.session.Session;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.NamingException;

public class JMSBytesMessageWrapper
extends JMSMessageWrapper
implements JMSBytesMessage {
    private Class originalClass = JMSBytesMessageImpl.class;
    private boolean fill = false;

    public JMSBytesMessageWrapper(Session session) {
        super(session);
    }

    public JMSBytesMessageWrapper(RecordItem recordItem, Session session) {
        super(recordItem, session);
    }

    @Override
    public Message createMessage(javax.jms.Session session, JMSInitialContext initialContext) throws JMSException, NamingException {
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(this.getByteMessage());
        this.fillMessage(session, (Message)message, initialContext);
        return message;
    }

    @Override
    public void fill(Object object) {
        if (object != null) {
            if (this.fill) {
                throw new CyclicDependencyException(this.originalClass);
            }
            this.fill = true;
            super.fill(object);
            JMSBytesMessage value = (JMSBytesMessage)object;
            this.setByteMessage(value.getByteMessage());
            this.fill = false;
        }
    }

    @Override
    protected Object createObject() {
        JMSBytesMessageImpl result = new JMSBytesMessageImpl();
        result.setByteMessage(this.getByteMessage());
        this.toObject(result);
        return result;
    }

    @Override
    public byte[] getByteMessage() {
        BlobItem blobItem = this.getRecordItem().getBlobItem(19);
        return blobItem == null ? null : blobItem.byteValues();
    }

    @Override
    public void setByteMessage(byte[] value) {
        this.setValue(19, value);
    }

    @Override
    public void fillMessage(javax.jms.Session session, Message msg, JMSInitialContext initialContext) throws JMSException, NamingException {
        JMSAddOnHelper.assign(this, session, msg, initialContext);
    }

    @Override
    public void assignHeaderFromMessage(Message msg) throws JMSException {
        JMSAddOnHelper.assignFrom(this, msg);
    }

    @Override
    public void assignBodyFromMessage(Message msg) throws JMSException {
        JMSAddOnHelper.setBody(this, msg);
    }

    @Override
    public void setMessage(String message) {
        this.setByteMessage(message.getBytes());
    }

    @Override
    public String getMessage() {
        return new String(this.getByteMessage());
    }

    @Override
    protected String getFullQualifiedModelName() {
        return "urn:Base_Components.Add_Ons.JMS.JMSBlobMessage";
    }
}

