/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.fop;

import ch.e2e.bridge.server.JavaVirtualMachine;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class FOPConfiguration {
    private File configFile = new File("./repository/fop/fop.xconf");

    public FOPConfiguration(String userconfig) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        if (userconfig == null && !this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            Document configTemplate = DomUtilities.parseFromClasspath((String)"ch/e2e/bridge/server/fop/fopConfTemplate.xml", (boolean)false, (boolean)false, (boolean)false);
            this.replacePathVariables(configTemplate.getElementsByTagName("directory"));
            DomUtilities.serialize((File)this.configFile, (Document)configTemplate, (boolean)true);
        }
    }

    private void replacePathVariables(NodeList directories) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String path = FileUtilities.getAbsolutePath((File)JavaVirtualMachine.getConsoleHome());
        properties.put("CONSOLE_HOME", path);
        path = FileUtilities.getAbsolutePath((File)JavaVirtualMachine.getInstancesHome());
        properties.put("INSTANCES_HOME", path);
        int length = directories.getLength();
        for (int i = 0; i < length; ++i) {
            Element directory = (Element)directories.item(i);
            if (directory.getChildNodes().getLength() != 1 || directory.getFirstChild().getNodeType() != 3) continue;
            Text text = (Text)directory.getFirstChild();
            text.setData(StringTools.replaceProperties((String)text.getData(), properties));
        }
    }

    public File getFile() {
        return this.configFile;
    }
}

