/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.dataitem.repository;

import ch.e2e.bridge.server.JavaVirtualMachine;
import ch.e2e.bridge.server.dataitem.repository.DataItem;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class Repository {
    private long nativeRepository = Repository.nativeObtainRepository();

    protected static native long nativeObtainRepository();

    protected static native void nativeReleaseRepository(long var0);

    protected static native long nativeGetDataItemByPosition(long var0, long var2);

    protected static native long nativeGetDataItemByName(long var0, byte[] var2);

    protected static native long nativeGetDataItemCount(long var0);

    public void finalize() {
        Repository.nativeReleaseRepository(this.nativeRepository);
    }

    public DataItem getDataItem(long position) {
        long nativeDataItem = Repository.nativeGetDataItemByPosition(this.nativeRepository, position);
        return nativeDataItem == 0L ? null : new DataItem(nativeDataItem);
    }

    public DataItem getDataItem(String name) throws UnsupportedEncodingException {
        long nativeDataItem = Repository.nativeGetDataItemByName(this.nativeRepository, name.getBytes(StandardCharsets.UTF_8));
        return nativeDataItem == 0L ? null : new DataItem(nativeDataItem);
    }

    public long getDataItemCount() {
        return Repository.nativeGetDataItemCount(this.nativeRepository);
    }

    static {
        JavaVirtualMachine.initialize();
    }
}

