/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server;

import ch.e2e.bridge.server.dataitem.BlobItem;
import ch.e2e.bridge.server.dataitem.BooleanItem;
import ch.e2e.bridge.server.dataitem.FloatItem;
import ch.e2e.bridge.server.dataitem.IntegerItem;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.session.Session;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;

public abstract class Wrapper {
    private RecordItem recordItem;
    private Session session;

    public Wrapper(Session session) {
        this.session = session;
        this.recordItem = ItemFactory.createRecordItem(session, this.getFullQualifiedModelName());
    }

    public Wrapper(RecordItem recordItem, Session session) {
        this.recordItem = recordItem;
        this.session = session;
    }

    public RecordItem getRecordItem() {
        if (this.recordItem == null) {
            this.recordItem = ItemFactory.createRecordItem(this.session, this.getFullQualifiedModelName());
        }
        return this.recordItem;
    }

    public Session getSession() {
        return this.session;
    }

    public final Object toObject() {
        Object result = this.createObject();
        this.fillAttributes(result);
        return result;
    }

    protected RecordItem getRecordItem(int index) {
        return this.recordItem.getRecordItem(index);
    }

    public void fill(Object object) {
    }

    protected abstract Object createObject();

    protected abstract String getFullQualifiedModelName();

    protected void fillAttributes(Object object) {
    }

    public byte byteValue(int index) {
        IntegerItem integerItem = this.getRecordItem().getIntegerItem(index);
        return integerItem == null ? (byte)0 : integerItem.byteValue();
    }

    public void setValue(int index, byte value) {
        this.getRecordItem().getIntegerItemCreateIfNotExists(index).setValue(value);
    }

    public void setValue(int index, Byte value) {
        if (value != null) {
            this.getRecordItem().getIntegerItemCreateIfNotExists(index).setValue(value);
        }
    }

    public short shortValue(int index) {
        IntegerItem integerItem = this.getRecordItem().getIntegerItem(index);
        return integerItem == null ? (short)0 : integerItem.shortValue();
    }

    public void setValue(int index, short value) {
        this.getRecordItem().getIntegerItemCreateIfNotExists(index).setValue(value);
    }

    public void setValue(int index, Short value) {
        if (value != null) {
            this.getRecordItem().getIntegerItemCreateIfNotExists(index).setValue(value);
        }
    }

    public int intValue(int index) {
        IntegerItem integerItem = this.getRecordItem().getIntegerItem(index);
        return integerItem == null ? 0 : integerItem.intValue();
    }

    public void setValue(int index, int value) {
        this.getRecordItem().getIntegerItemCreateIfNotExists(index).setValue(value);
    }

    public void setValue(int index, Integer value) {
        if (value != null) {
            this.getRecordItem().getIntegerItemCreateIfNotExists(index).setValue(value);
        }
    }

    public long longValue(int index) {
        IntegerItem integerItem = this.getRecordItem().getIntegerItem(index);
        return integerItem == null ? 0L : integerItem.longValue();
    }

    public void setValue(int index, long value) {
        this.getRecordItem().getIntegerItemCreateIfNotExists(index).setValue(value);
    }

    public void setValue(int index, Long value) {
        if (value != null) {
            this.getRecordItem().getIntegerItemCreateIfNotExists(index).setValue(value);
        }
    }

    public void setValue(int index, BigInteger value) {
        if (value != null) {
            this.getRecordItem().getIntegerItemCreateIfNotExists(index).setValue(value);
        }
    }

    public char charValue(int index) {
        IntegerItem integerItem = this.getRecordItem().getIntegerItem(index);
        return integerItem == null ? (char)'\u0000' : integerItem.charValue();
    }

    public void setValue(int index, char value) {
        this.getRecordItem().getStringItemCreateIfNotExists(index).setValue(value);
    }

    public void setValue(int index, Character value) {
        if (value != null) {
            this.getRecordItem().getStringItemCreateIfNotExists(index).setValue(value);
        }
    }

    public boolean booleanValue(int index) {
        BooleanItem booleanItem = this.getRecordItem().getBooleanItem(index);
        return booleanItem != null && booleanItem.booleanValue();
    }

    public void setValue(int index, boolean value) {
        this.getRecordItem().getBooleanItemCreateIfNotExists(index).setValue(value);
    }

    public void setValue(int index, Boolean value) {
        if (value != null) {
            this.getRecordItem().getBooleanItemCreateIfNotExists(index).setValue(value);
        }
    }

    public float floatValue(int index) {
        FloatItem floatItem = this.getRecordItem().getFloatItem(index);
        return floatItem == null ? 0.0f : floatItem.floatValue();
    }

    public void setValue(int index, float value) {
        this.getRecordItem().getFloatItemCreateIfNotExists(index).setValue(value);
    }

    public void setValue(int index, Float value) {
        if (value != null) {
            this.getRecordItem().getFloatItemCreateIfNotExists(index).setValue(value);
        }
    }

    public double doubleValue(int index) {
        FloatItem floatItem = this.getRecordItem().getFloatItem(index);
        return floatItem == null ? 0.0 : floatItem.doubleValue();
    }

    public void setValue(int index, double value) {
        this.getRecordItem().getFloatItemCreateIfNotExists(index).setValue(value);
    }

    public void setValue(int index, BigDecimal value) {
        if (value != null) {
            this.getRecordItem().getFloatItemCreateIfNotExists(index).setValue(value);
        }
    }

    public void setValue(int index, Double value) {
        if (value != null) {
            this.getRecordItem().getFloatItemCreateIfNotExists(index).setValue(value);
        }
    }

    public void setValue(int index, String value) {
        if (value != null) {
            this.getRecordItem().getStringItemCreateIfNotExists(index).setValue(value);
        }
    }

    public byte[] byteValues(int index) {
        BlobItem blobItem = this.getRecordItem().getBlobItem(index);
        return blobItem == null ? null : blobItem.byteValues();
    }

    public Byte[] getValueAsBytes(int index) {
        BlobItem blobItem = this.getRecordItem().getBlobItem(index);
        return blobItem == null ? null : blobItem.getValueAsBytes();
    }

    public InputStream getValueAsInputStream(int index, Class inputStreamClass) {
        BlobItem blobItem = this.getRecordItem().getBlobItem(index);
        return blobItem == null ? null : blobItem.getValueAsInputStream(inputStreamClass);
    }

    public void setValue(int index, byte[] value) {
        if (value != null) {
            this.getRecordItem().getBlobItemCreateIfNotExists(index).setValue(value);
        }
    }

    public void setValue(int index, Byte[] value) {
        if (value != null) {
            this.getRecordItem().getBlobItemCreateIfNotExists(index).setValue(value);
        }
    }

    public void setValue(int index, InputStream value) {
        if (value != null) {
            this.getRecordItem().getBlobItemCreateIfNotExists(index).setValue(value);
        }
    }

    public void setValue(int index, Calendar value) {
        if (value != null) {
            this.getRecordItem().getDateTimeItemCreateIfNotExists(index).setValue((Object)value);
        }
    }

    public void setValue(int index, Date value) {
        if (value != null) {
            this.getRecordItem().getDateTimeItemCreateIfNotExists(index).setValue(value);
        }
    }

    public void setValue(int index, StringBuffer value) {
        if (value != null) {
            this.getRecordItem().getStringItemCreateIfNotExists(index).setValue(value);
        }
    }

    public void setValue(int index, StringBuilder value) {
        if (value != null) {
            this.getRecordItem().getStringItemCreateIfNotExists(index).setValue(value);
        }
    }

    public Object getValue(int index) {
        RecordItem item = this.getRecordItem(index);
        return item.getValue();
    }

    public void setValue(int index, Object value) {
        if (value != null) {
            RecordItem item = this.getRecordItem(index);
            item.setValue(value);
        }
    }
}

