/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.regtest.gui.OptionContainerTransferable;
import ch.e2e.builder.regtest.gui.TestTransferEvent;
import ch.e2e.builder.regtest.gui.TestTransferListener;
import ch.e2e.builder.regtest.gui.TestableTransferable;
import ch.e2e.builder.regtest.model.TreePathElement;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Library;
import ch.e2e.builder.regtest.testsuite.LibraryChildSuite;
import ch.e2e.builder.regtest.testsuite.TestSuiteOptions;
import ch.e2e.builder.regtest.testsuite.TestSuiteRoot;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.Testable;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;

public class TestTransferHandler
extends TransferHandler {
    private EventListenerList listeners = new EventListenerList();

    public void addTestTransferListener(TestTransferListener listener) {
        this.listeners.add(TestTransferListener.class, listener);
    }

    public void removeTestTransferListener(TestTransferListener listener) {
        this.listeners.remove(TestTransferListener.class, listener);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (!(c instanceof JTree)) {
            return null;
        }
        JTree tree = (JTree)c;
        Transferable transferable = null;
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            Object source = path.getLastPathComponent();
            if (source instanceof Testcase) {
                Testcase data = (Testcase)source;
                if (LibrariesRoot.isInLibraryTree(data) || !data.isInLibrary()) {
                    transferable = new TestableTransferable.TestcaseTransferable(data);
                }
            } else if (source instanceof LibraryChildSuite) {
                transferable = new TestableTransferable.LibraryChildSuiteTransferable((LibraryChildSuite)source);
            } else if (!(source instanceof Library)) {
                if (source instanceof TreeTestSuite) {
                    TreeTestSuite data = (TreeTestSuite)source;
                    if (!(source instanceof TestSuiteRoot) && !data.isInLibrary()) {
                        transferable = new TestableTransferable.TestsuiteTransferable(data);
                    }
                } else if (source instanceof OptionContainer) {
                    transferable = new OptionContainerTransferable((OptionContainer)source);
                }
            }
        }
        return transferable;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop() || !(support.getDropLocation() instanceof JTree.DropLocation)) {
            return false;
        }
        boolean canImport = false;
        TreePath path = ((JTree.DropLocation)support.getDropLocation()).getPath();
        if (path != null) {
            Object dropTarget = path.getLastPathComponent();
            try {
                if (support.isDataFlavorSupported(TestableTransferable.TESTCASE_DATA_FLAVOR)) {
                    Testcase data = (Testcase)support.getTransferable().getTransferData(TestableTransferable.TESTCASE_DATA_FLAVOR);
                    if (!data.equals(dropTarget) && dropTarget instanceof TreePathElement) {
                        boolean targetInLibraryTree = LibrariesRoot.isInLibraryTree((TreePathElement)dropTarget);
                        boolean dataInLibraryTree = LibrariesRoot.isInLibraryTree(data);
                        if (targetInLibraryTree && dataInLibraryTree) {
                            if (dropTarget instanceof Library) {
                                canImport = data.getLibrary().equals(((Library)dropTarget).getLibrary());
                            } else if (dropTarget instanceof Testcase) {
                                canImport = data.getLibrary().equals(((Testcase)dropTarget).getLibrary());
                            }
                        } else if (!targetInLibraryTree && !dataInLibraryTree) {
                            canImport = !(dropTarget instanceof TestSuiteRoot) && (dropTarget instanceof TreeTestSuite && !((TreeTestSuite)dropTarget).isLibrary() && !((TreeTestSuite)dropTarget).isInLibrary() || dropTarget instanceof Testcase && !((Testable)dropTarget).isInLibrary());
                        }
                    }
                } else if (support.isDataFlavorSupported(TestableTransferable.TESTSUITE_DATA_FLAVOR)) {
                    TreeTestSuite data = (TreeTestSuite)support.getTransferable().getTransferData(TestableTransferable.TESTSUITE_DATA_FLAVOR);
                    if (!data.equals(dropTarget)) {
                        if (dropTarget instanceof TreeTestSuite) {
                            TreeTestSuite target = (TreeTestSuite)dropTarget;
                            canImport = !target.isLibrary() && !target.isInLibrary() && !LibrariesRoot.isInLibraryTree(target) && (data.isLibrary() && (data.getTreeParent().equals(target.getTreeParent()) || data.getTreeParent().equals(target)) || !data.isLibrary() && !data.isDescendant(target));
                        } else if (dropTarget instanceof Testcase) {
                            Testcase target = (Testcase)dropTarget;
                            canImport = !LibrariesRoot.isInLibraryTree(target) && !target.isInLibrary() && (data.isLibrary() && (data.getTreeParent().equals(target.getTreeParent()) || data.getTreeParent().equals(target)) || !data.isLibrary() && !data.isDescendant(target));
                        }
                    }
                } else if (support.isDataFlavorSupported(TestableTransferable.LIBRARY_CHILD_SUITE_DATA_FLAVOR)) {
                    LibraryChildSuite data = (LibraryChildSuite)support.getTransferable().getTransferData(TestableTransferable.LIBRARY_CHILD_SUITE_DATA_FLAVOR);
                    if (!data.equals(dropTarget)) {
                        canImport = (dropTarget instanceof Library && data.getLibrary().equals(((Library)dropTarget).getLibrary()) || dropTarget instanceof Testcase && LibrariesRoot.isInLibraryTree((Testcase)dropTarget) && data.getLibrary().equals(((Testcase)dropTarget).getLibrary())) && !data.isDescendant((TreePathElement)dropTarget);
                    }
                } else if (support.isDataFlavorSupported(OptionContainerTransferable.OPTION_CONTAINER_DATA_FLAVOR) && dropTarget instanceof TestSuiteOptions) {
                    OptionContainer data = (OptionContainer)support.getTransferable().getTransferData(OptionContainerTransferable.OPTION_CONTAINER_DATA_FLAVOR);
                    Testable owner = data.getOwner();
                    canImport = owner instanceof TreeTestSuite && !((TestSuiteOptions)dropTarget).getKeys().contains(data.getType()) && !dropTarget.equals(((TreeTestSuite)owner).getTestSuiteOptions());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return canImport;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!support.isDrop() || support.getDropAction() != 2 || !(support.getDropLocation() instanceof JTree.DropLocation)) {
            return false;
        }
        boolean imported = false;
        TreePath path = ((JTree.DropLocation)support.getDropLocation()).getPath();
        if (path != null) {
            Object target = path.getLastPathComponent();
            try {
                if (support.isDataFlavorSupported(TestableTransferable.TESTABLE_DATA_FLAVOR)) {
                    if (target instanceof Testable) {
                        Testable data = (Testable)support.getTransferable().getTransferData(TestableTransferable.TESTABLE_DATA_FLAVOR);
                        this.fireMoveTest(data, (Testable)target);
                        imported = true;
                    }
                } else if (support.isDataFlavorSupported(OptionContainerTransferable.OPTION_CONTAINER_DATA_FLAVOR) && target instanceof TestSuiteOptions) {
                    OptionContainer data = (OptionContainer)support.getTransferable().getTransferData(OptionContainerTransferable.OPTION_CONTAINER_DATA_FLAVOR);
                    this.fireMoveOptions(data, (TestSuiteOptions)target);
                    imported = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return imported;
    }

    private void fireMoveTest(Testable testToMove, Testable testBefore) {
        for (TestTransferListener listener : (TestTransferListener[])this.listeners.getListeners(TestTransferListener.class)) {
            listener.moveTest(new TestTransferEvent((Object)this, testToMove, testBefore));
        }
    }

    private void fireMoveOptions(OptionContainer optionContainer, TestSuiteOptions newOptions) {
        for (TestTransferListener listener : (TestTransferListener[])this.listeners.getListeners(TestTransferListener.class)) {
            listener.moveOptions(new TestTransferEvent((Object)this, optionContainer, newOptions));
        }
    }
}

