/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.ProjectPool;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.builder.regtest.model.LibrarySelectionTreeModel;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.io.FileUtilities;
import ch.e2e.swing.Tree;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.model.SortedListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class LibrarySelectionDialog
extends E2EBuilderDialog
implements TreeSelectionListener {
    private static LibrarySelectionDialog dialog;
    private LibrarySelectionTreeModel treeModel;
    private Tree tree;
    private E2EBuilderModule module;
    private JComboBox projectBox;
    private ProjectPool.ProjectFileFilter projectFileFilter;
    private boolean changesEnabled = false;
    private File browseFile;
    private ProjectBoxModel projectBoxModel;
    private ArrayList<File> additionalProjects;

    public LibrarySelectionDialog(E2EBuilderModule module) {
        super(module.getTranslation("library.selection.dialog.title"), module.getTranslation("library.selection.dialog.internaltitle"), module.getTranslation("library.selection.dialog.subtitle"), 3);
        this.module = module;
        this.createGui();
        this.projectFileFilter = new ProjectPool.ProjectFileFilter(module.getProjectPool());
        this.browseFile = new File("Browse ...");
        this.additionalProjects = new ArrayList();
    }

    public static TreeTestSuite selectLibrary(LibrariesRoot root, E2EBuilderModule module) {
        if (dialog == null) {
            dialog = new LibrarySelectionDialog(module);
        }
        return dialog.selectLibrary(root);
    }

    private TreeTestSuite selectLibrary(LibrariesRoot root) {
        this.fillProjectBox();
        TreeTestSuite result = null;
        this.treeModel.setRoot(root);
        this.tree.clearSelection();
        this.setOkButtonEnabled(false);
        if (this.showDialog() == 1) {
            result = (TreeTestSuite)this.tree.getSelectionPath().getLastPathComponent();
        }
        return result;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.setOkButtonEnabled(e.getNewLeadSelectionPath() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProjects() {
        File projects = this.getProjectsFile();
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(projects));
            for (File project : this.additionalProjects) {
                out.println(project.getAbsolutePath());
            }
            out.flush();
        }
    }

    private void createGui() {
        this.setLayout(new BorderLayout());
        JPanel north = new JPanel(new BorderLayout(5, 20));
        north.add((Component)ComponentFactory.createLabel((String)"test.selection.dialog.select.from", (E2EBuilderModule)this.module), "West");
        this.projectBoxModel = new ProjectBoxModel();
        this.projectBox = new JComboBox(this.projectBoxModel);
        this.projectBox.setRenderer(new ProjectBoxCellRenderer());
        this.projectBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LibrarySelectionDialog.this.projectSelected();
            }
        });
        north.add((Component)this.projectBox, "Center");
        north.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.treeModel = new LibrarySelectionTreeModel(new LibrariesRoot(), this.module);
        this.tree = new Tree((AbstractTreeModel)this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener((TreeSelectionListener)this);
        this.tree.setRootVisible(false);
        JScrollPane scrollPane = new JScrollPane((Component)this.tree, 20, 30);
        this.add(scrollPane, "Center");
    }

    private void projectSelected() {
        if (this.changesEnabled) {
            if (this.projectBox.getSelectedIndex() == 0) {
                this.browseForProject();
            } else {
                this.changeProject();
            }
        }
    }

    private void browseForProject() {
        File projectHome = this.module.getProjectPool().selectProjectFile();
        if (projectHome != null) {
            this.changesEnabled = false;
            projectHome = projectHome.getParentFile();
            this.projectBoxModel.add(projectHome);
            this.changesEnabled = true;
            this.projectBox.setSelectedItem(projectHome);
        }
    }

    private void changeProject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillProjectBox() {
        this.changesEnabled = false;
        File[] projectFolders = FileUtilities.getFileList((File)this.module.getProjectPool().getProjectHome().getParentFile(), (FileFilter)this.projectFileFilter);
        this.projectBoxModel.removeAll();
        this.projectBoxModel.add(this.browseFile);
        this.projectBoxModel.addAll(Arrays.asList(projectFolders));
        this.additionalProjects.clear();
        File projects = this.getProjectsFile();
        if (projects.exists()) {
            BufferedReader projectsIn = null;
            try {
                projectsIn = new BufferedReader(new FileReader(projects));
                String line = projectsIn.readLine();
                while (line != null) {
                    File file = new File(line);
                    if (file.exists()) {
                        this.additionalProjects.add(file);
                    }
                    line = projectsIn.readLine();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (projectsIn != null) {
                    try {
                        projectsIn.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.projectBoxModel.addAll(this.additionalProjects);
        }
        this.changesEnabled = true;
    }

    private File getProjectsFile() {
        File projectHome = this.module.getProjectPool().getProjectHome();
        File testSuiteFolder = new File(projectHome, "regressiontest/testsuite");
        return new File(testSuiteFolder, ".projects");
    }

    private class ProjectBoxComparator
    implements Comparator<File> {
        private ProjectBoxComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.equals(LibrarySelectionDialog.this.browseFile) ? -1 : (o2.equals(LibrarySelectionDialog.this.browseFile) ? 1 : o1.getAbsolutePath().compareToIgnoreCase(o2.getAbsolutePath()));
        }
    }

    private class ProjectBoxModel
    extends SortedListModel<File>
    implements ComboBoxModel {
        private Object selectedItem;

        private ProjectBoxModel() {
            super((Comparator)new ProjectBoxComparator());
        }

        @Override
        public void setSelectedItem(Object selectedItem) {
            this.selectedItem = selectedItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }
    }

    private class ProjectBoxCellRenderer
    extends DefaultListCellRenderer {
        private ProjectBoxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result;
            if (value != null && value.equals(LibrarySelectionDialog.this.browseFile)) {
                result = super.getListCellRendererComponent((JList<?>)list, ((File)value).getName(), index, isSelected, cellHasFocus);
                this.setIcon(E2EBuilderIcons.FILE_OPEN_ICON);
            } else {
                result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(E2EBuilderIcons.PROJECT_ICON);
            }
            return result;
        }
    }
}

