/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.gui.ComponentFactory;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.event.DataChangesAcceptedEvent;
import ch.e2e.builder.regtest.event.RefreshDiffPaneEvent;
import ch.e2e.builder.regtest.gui.swing.AdvancedOptionsDialog;
import ch.e2e.builder.regtest.testsuite.LibrariesRoot;
import ch.e2e.builder.regtest.testsuite.Testcase;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.FixedHeightLabel;
import ch.e2e.swing.InputCheckBox;
import ch.e2e.test.E2ETestResult;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.ErrorDetail;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.ResultCompare;
import ch.e2e.test.Testable;
import ch.e2e.test.Utilities;
import com.jidesoft.diff.CodeEditorDiffPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DiffPane
extends CodeEditorDiffPane
implements InputFieldListener {
    private E2EBuilderModule module;
    private AdvancedOptionsDialog advancedOptionsDlg;
    private JLabel toTitle;
    private Testcase testcase;
    private ErrorDetail errorDetail;
    private FixedHeightLabel fromTitle;
    private InputCheckBox hideBox;
    private JButton accept;
    private JButton editIgnores;

    public DiffPane(E2EBuilderModule module) {
        this.module = module;
        this.setReadOnly(true);
        this.setIgnoreWhitespaces(false);
        this.setFromTitle(module.getTranslation("diff.pane.reference.data.title"));
        this.setToTitle(module.getTranslation("diff.pane.test.data.title"));
        this.accept.setText(module.getTranslation("diff.pane.accept.differences"));
        this.editIgnores.setText(module.getTranslation("diff.pane.edit.ignored.differences"));
        this.editIgnores.setVisible(false);
        this.hideBox.setText(module.getTranslation("diff.pane.hide.ignored.differences"));
        this.hideBox.setVisible(false);
        this.setChangedColor(new Color(255, 196, 196));
        this.setInsertedColor(new Color(196, 255, 196));
        this.setDeletedColor(new Color(200, 200, 200));
        this.addEventHandler();
    }

    public void setToTitle(String s) {
        this.toTitle.setText(s);
    }

    public void setFromTitle(String s) {
        this.fromTitle.setText(s);
    }

    public void setTestcase(Testcase testcase, ErrorDetail errorDetail) {
        this.testcase = testcase;
        this.errorDetail = errorDetail;
        this.editIgnores.setVisible(testcase.hasIgnoredDifferences() && (!testcase.isInLibrary() || LibrariesRoot.isInLibraryTree(testcase)));
        this.hideBox.setVisible(testcase.hasIgnoredDifferences());
        this.refresh();
    }

    public void setEnabled(boolean enabled) {
        this.accept.setEnabled(enabled);
        this.editIgnores.setEnabled(enabled);
        this.hideBox.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private void addEventHandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                DiffPane.this.refresh();
            }
        }, RefreshDiffPaneEvent.class);
    }

    private void refresh() {
        if (this.testcase == null) {
            this.clear();
        } else if (this.testcase.getResult() == null) {
            this.clear();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DiffPane.this.fillDiffPane();
                }
            });
        }
    }

    private void fillDiffPane() {
        Utilities.replaceProperties((E2ETestcase)this.testcase);
        Map properties = Utilities.collectProperties((Testable)this.testcase);
        E2ETestResult testResult = this.testcase.getResult();
        if (this.errorDetail == null) {
            this.setFromText(testResult.getReferenceData(!this.hideBox.isSelected(), properties));
            this.setToText(testResult.getTestData(!this.hideBox.isSelected(), properties));
        } else {
            this.setFromText(testResult.getReferenceData(this.errorDetail, !this.hideBox.isSelected(), properties));
            this.setToText(testResult.getTestData(this.errorDetail, !this.hideBox.isSelected(), properties));
        }
        this.diff();
    }

    public void clear() {
        this.clearDiff();
        this.setFromText("");
        this.setToText("");
    }

    public void inputFieldChanged(InputFieldEvent e) {
        this.reload();
    }

    private void reload() {
        if (this.testcase != null) {
            this.testcase.getResult().clearReferenceAndTestData();
            this.refresh();
        }
    }

    protected JComponent createToTitle() {
        this.toTitle = (JLabel)super.createToTitle();
        Font font = this.getFont();
        this.toTitle.setFont(font.deriveFont(1));
        this.toTitle.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.toTitle.setHorizontalAlignment(4);
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.toTitle, "Center");
        this.accept = ComponentFactory.createButton((String)"diff.pane.accept.differences", (E2EBuilderModule)this.module);
        this.accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffPane.this.acceptChanges();
            }
        });
        result.add((Component)this.accept, "West");
        return result;
    }

    protected JComponent createFromTitle() {
        JPanel result = new JPanel(new BorderLayout());
        this.editIgnores = ComponentFactory.createButton((String)"diff.pane.edit.ignored.differences", (E2EBuilderModule)this.module);
        this.editIgnores.doLayout();
        this.editIgnores.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffPane.this.editIgnoredDifferences();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
        buttonPanel.add(this.editIgnores);
        result.add((Component)buttonPanel, "Center");
        this.fromTitle = new FixedHeightLabel();
        this.fromTitle.setHeight(this.editIgnores.getPreferredSize().height);
        Font font = this.fromTitle.getFont();
        this.fromTitle.setFont(font.deriveFont(1));
        this.fromTitle.setBorder((Border)new EmptyBorder(0, 12, 0, 0));
        result.add((Component)this.fromTitle, "West");
        this.hideBox = ComponentFactory.createCheckBox((String)"diff.pane.hide.ignored.differences", (E2EBuilderModule)this.module);
        this.hideBox.addInputFieldListener((InputFieldListener)this);
        this.hideBox.setSelected(true);
        result.add((Component)this.hideBox, "East");
        return result;
    }

    private void editIgnoredDifferences() {
        ArrayList<ResultCompare> containsIgnores = new ArrayList<ResultCompare>();
        for (ResultCompare compare : this.testcase.getResult().getResultCompares()) {
            if (!compare.hasIgnoredDifferences()) continue;
            containsIgnores.add(compare);
        }
        ResultCompare compare = null;
        if (containsIgnores.size() == 1) {
            compare = (ResultCompare)containsIgnores.get(0);
        }
        if (compare != null) {
            Utilities.mergeOptions((OptionContainer)this.testcase.getParent().getInheritedOptions(compare.getType(), true), (OptionContainer)compare);
            if (this.advancedOptionsDlg == null) {
                this.advancedOptionsDlg = new AdvancedOptionsDialog(E2EBuilder.getInstance().getApplicationFrame(), E2EBuilder.getInstance().getE2EBuilderLogo());
            }
            this.advancedOptionsDlg.setOptions(compare.getIgnoredDifferences().values(), false, true);
            if (this.advancedOptionsDlg.editAdvancedOptions()) {
                this.advancedOptionsDlg.persist(false);
                this.testcase.persist(this.testcase.getName());
                this.reload();
            }
        }
    }

    private void acceptChanges() {
        try {
            this.testcase.acceptChanges();
            this.refresh();
            EventController.fire((EventObject)new DataChangesAcceptedEvent((Object)this, this.testcase));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

