/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.module;

import ch.e2e.builder.base.module.ModuleInterchangeAction;
import ch.e2e.builder.base.module.ModuleInterchangeActionListener;
import ch.e2e.builder.base.module.ModuleInterchangeActionMulticaster;
import java.util.HashMap;

public class ModuleInterchangeController {
    private static ModuleInterchangeController controller;
    private HashMap<String, ModuleInterchangeActionListener> interchangeListeners = new HashMap();

    private ModuleInterchangeController() {
    }

    public static ModuleInterchangeController getInstance() {
        if (controller == null) {
            controller = new ModuleInterchangeController();
        }
        return controller;
    }

    public void registerModuleInterchangeActionListener(ModuleInterchangeActionListener listener) {
        ModuleInterchangeActionListener oldListener = this.interchangeListeners.get(listener.getName());
        listener = ModuleInterchangeActionMulticaster.addListener(oldListener, listener);
        this.interchangeListeners.put(listener.getName(), listener);
    }

    public void fireModuleInterchangeAction(ModuleInterchangeAction action) {
        ModuleInterchangeActionListener listener = this.interchangeListeners.get(action.getName());
        if (listener != null) {
            listener.doAction(action);
        }
    }
}

