/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.test;

import ch.e2e.test.TestSuiteProperty;
import ch.e2e.util.StringTools;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class PropertiesHelper {
    private static HashMap<String, String> systemProperties;

    private PropertiesHelper() {
    }

    public static void resetSystemProperties() {
        systemProperties = new HashMap();
        for (Object o : System.getProperties().keySet()) {
            systemProperties.put((String)o, System.getProperty((String)o));
        }
    }

    public static String replaceProperties(String value) {
        return PropertiesHelper.replaceProperties(value, systemProperties);
    }

    public static String replaceProperties(String value, Map<String, String> properties) {
        HashMap<String, String> replaceMap = new HashMap<String, String>(systemProperties);
        replaceMap.putAll(properties);
        return StringTools.replaceProperties((String)value, replaceMap);
    }

    public static void replaceProperties(Element element) {
        PropertiesHelper.replaceProperties(element, systemProperties);
    }

    public static void replaceProperties(Element element, Map<String, String> properties) {
        HashMap<String, String> allProperties = new HashMap<String, String>(systemProperties);
        allProperties.putAll(properties);
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            if (!(children.item(i) instanceof Element) || children.item(i).getNodeName().equalsIgnoreCase("property")) continue;
            Element child = (Element)children.item(i);
            NamedNodeMap attributes = child.getAttributes();
            int attributesLength = attributes.getLength();
            for (int j = 0; j < attributesLength; ++j) {
                Attr attribute = (Attr)attributes.item(j);
                String name = PropertiesHelper.replaceProperties(attribute.getName(), allProperties);
                String value = PropertiesHelper.replaceProperties(attribute.getValue(), allProperties);
                child.setAttribute(name, value);
            }
            PropertiesHelper.replaceProperties(child, allProperties);
        }
    }

    public static String getAttribute(Element parent, String name) {
        return StringTools.replaceProperties((String)parent.getAttribute(name), systemProperties);
    }

    public static String getAttribute(Element parent, String name, Map<String, String> properties) {
        return PropertiesHelper.getAttribute(parent, name, null, properties);
    }

    public static String getAttribute(Element parent, String name, String defaultValue, Map<String, String> properties) {
        String result;
        if (parent.hasAttribute(name)) {
            HashMap<String, String> replaceMap = new HashMap<String, String>(properties);
            replaceMap.putAll(systemProperties);
            result = StringTools.replaceProperties((String)parent.getAttribute(name), replaceMap);
        } else {
            result = defaultValue == null ? "" : defaultValue;
        }
        return result;
    }

    public static TestSuiteProperty createProperty(Element property, Map<String, String> properties) {
        HashMap<String, String> allProperties = new HashMap<String, String>(properties);
        allProperties.putAll(systemProperties);
        String name = StringTools.replaceProperties((String)property.getAttribute("name"), allProperties);
        String value = StringTools.replaceProperties((String)property.getAttribute("value"), allProperties);
        return new TestSuiteProperty(name, value);
    }

    static {
        PropertiesHelper.resetSystemProperties();
    }
}

