/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.net.test;

import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.compiler.build.test.BuildRepositoryCreateDialog;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.document.UmlDocumentCompilerSettings;
import ch.e2e.builder.compiler.document.UmlDocumentFactory;
import ch.e2e.builder.compiler.net.ServiceTest;
import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.Properties;
import ch.e2e.swing.InputCheckBox;
import ch.e2e.swing.InputPasswordField;
import ch.e2e.swing.InputTextField;
import ch.e2e.swing.IntegerSpinner;
import ch.e2e.swing.ModalDialog;
import ch.e2e.swing.model.SortedComboBoxModel;
import ch.e2e.test.TypeFactory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ServiceTestCreateDialog
extends ModalDialog {
    private static final Icon E2EBUILDER_LOGO = ImageLoader.loadIcon((String)"ch/e2e/builder/compiler/test/images/Y-32x32.png", (boolean)true, (ClassLoader)BuildRepositoryCreateDialog.class.getClassLoader());
    private static ServiceTestCreateDialog dlg;
    private SortedComboBoxModel<String> serviceBoxModel;
    private GridBagConstraints c;
    private InputTextField hostField;
    private IntegerSpinner portField;
    private InputTextField userField;
    private InputPasswordField passwordField;
    private InputCheckBox createAlsoCheckBox;
    private JComboBox serviceComboBox;
    private SortedComboBoxModel<String> serviceTypeBoxModel;
    private JComboBox serviceTypeComboBox;
    private JLabel timeoutLabel = new JLabel("Timeout");
    private IntegerSpinner timeoutSpinner = new IntegerSpinner(new SpinnerNumberModel(-1, -1, Integer.MAX_VALUE, 1));
    private boolean timeoutVisible = false;

    private ServiceTestCreateDialog(Frame owner) {
        super(owner, "", "", "", E2EBUILDER_LOGO, 3, false);
        this.createGui();
    }

    public static ServiceTest[] createTest(Frame owner, boolean startService) {
        if (dlg == null) {
            dlg = new ServiceTestCreateDialog(owner);
        }
        return dlg.create(startService);
    }

    public ServiceTest[] create(boolean startService) {
        this.setTitles(startService);
        this.setOkButtonEnabled(false);
        ServiceTest[] result = null;
        this.fillComboBox();
        this.createAlsoCheckBox.setSelected(true);
        if (this.showDialog() == 1) {
            try {
                if (this.createAlsoCheckBox.isSelected()) {
                    result = new ServiceTest[2];
                    result[0] = (ServiceTest)TypeFactory.getInstance().getType("startservice").newInstance();
                    this.fillServiceTest(result[0], true);
                    result[1] = (ServiceTest)TypeFactory.getInstance().getType("stopservice").newInstance();
                    this.fillServiceTest(result[1], false);
                } else {
                    result = new ServiceTest[1];
                    if (startService) {
                        result[0] = (ServiceTest)TypeFactory.getInstance().getType("startservice").newInstance();
                        this.fillServiceTest(result[0], true);
                    } else {
                        result[0] = (ServiceTest)TypeFactory.getInstance().getType("stopservice").newInstance();
                        this.fillServiceTest(result[0], false);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void fillServiceTest(ServiceTest serviceTest, boolean startService) {
        serviceTest.setOption("service.test.service", (String)this.serviceBoxModel.getSelectedItem());
        if (!this.userField.getText().isEmpty()) {
            serviceTest.setOption("service.test.username", this.userField.getText());
        }
        if (!String.valueOf(this.passwordField.getPassword()).isEmpty()) {
            serviceTest.setOption("service.test.password", String.valueOf(this.passwordField.getPassword()));
        }
        if (!this.hostField.getText().isEmpty()) {
            serviceTest.setOption("service.test.host", this.hostField.getText());
        }
        if (this.portField.getContent() != null) {
            serviceTest.setOption("service.test.port", String.valueOf(this.portField.getContent()));
        }
        serviceTest.setServiceType((String)this.serviceTypeComboBox.getSelectedItem());
        if (!startService) {
            serviceTest.setOption("service.test.stop.timeout", String.valueOf(this.timeoutSpinner.getValue()));
        }
    }

    private void setTitles(boolean startService) {
        if (startService) {
            this.setTitle("Create a Start Service Test");
            this.setInternalTitle("Create a Start Service Test");
            this.setSubtitle("Please enter the parameters for the new test");
            this.createAlsoCheckBox.setText("Create also a Stop Test for the selected service");
            this.removeTimeout();
        } else {
            this.setTitle("Create a Stop Service Test");
            this.setInternalTitle("Create a Stop Service Test");
            this.setSubtitle("Please enter the parameters for the new test");
            this.addTimeout();
        }
    }

    private void removeTimeout() {
        if (this.timeoutVisible) {
            this.remove(this.timeoutLabel);
            this.remove((Component)this.timeoutSpinner);
            this.timeoutVisible = false;
        }
    }

    private void addTimeout() {
        if (!this.timeoutVisible) {
            this.remove((Component)this.createAlsoCheckBox);
            this.c.insets = new Insets(3, 11, 1, 7);
            this.c.weightx = 1.0;
            this.add(this.timeoutLabel, this.c);
            this.add((Component)this.timeoutSpinner, this.c);
            this.addAlsoCheckBox("Create also a Start Test for the selected service");
            this.timeoutVisible = true;
        }
    }

    private void createGui() {
        this.c = this.initLayout();
        this.addServiceType();
        this.addServiceComboBox();
        this.addHost();
        this.addPort();
        this.addUser();
        this.addPassword();
        this.addAlsoCheckBox("");
        this.addFocusOnServiceComboBox();
    }

    private GridBagConstraints initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridwidth = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(3, 11, 1, 7);
        return c;
    }

    private void addServiceType() {
        JLabel serviceTypeLabel = new JLabel("Service Type");
        this.c.insets = new Insets(5, 11, 1, 7);
        this.add(serviceTypeLabel, this.c);
        this.serviceTypeBoxModel = new SortedComboBoxModel();
        this.serviceTypeBoxModel.add((Object)"E2E xUML Service");
        this.serviceTypeBoxModel.add((Object)"E2E Node.js Service");
        this.serviceTypeBoxModel.add((Object)"E2E Java Service");
        this.serviceTypeComboBox = new JComboBox<String>((ComboBoxModel<String>)this.serviceTypeBoxModel);
        this.serviceTypeComboBox.setSelectedItem("E2E xUML Service");
        this.c.insets = new Insets(2, 10, 5, 7);
        this.add(this.serviceTypeComboBox, this.c);
    }

    private void addServiceComboBox() {
        JLabel serviceLabel = new JLabel("E2E Service");
        this.add(serviceLabel, this.c);
        Properties properties = new Properties("ch.e2e.swing.swing");
        this.serviceBoxModel = new SortedComboBoxModel();
        this.serviceComboBox = new JComboBox<String>((ComboBoxModel<String>)this.serviceBoxModel);
        this.c.gridwidth = 0;
        this.c.insets = new Insets(2, 10, 5, 7);
        this.serviceComboBox.setEditable(true);
        ComboBoxEditor editor = this.serviceComboBox.getEditor();
        if (editor.getEditorComponent() instanceof JTextField) {
            ((JTextField)editor.getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ServiceTestCreateDialog.this.checkOkButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ServiceTestCreateDialog.this.checkOkButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ServiceTestCreateDialog.this.checkOkButton();
                }
            });
        }
        this.serviceComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ServiceTestCreateDialog.this.checkOkButton();
            }
        });
        this.add(this.serviceComboBox, this.c);
    }

    private void addHost() {
        JLabel hostLabel = new JLabel("Host");
        this.c.insets = new Insets(3, 11, 1, 7);
        this.c.weightx = 1.0;
        this.add(hostLabel, this.c);
        this.c.insets = new Insets(2, 10, 5, 7);
        this.hostField = new InputTextField("localhost");
        this.add((Component)this.hostField, this.c);
    }

    private void addPort() {
        JLabel portLabel = new JLabel("Port");
        this.c.insets = new Insets(3, 11, 1, 7);
        this.c.weightx = 1.0;
        this.add(portLabel, this.c);
        this.c.insets = new Insets(2, 10, 5, 7);
        SpinnerNumberModel inputModel = new SpinnerNumberModel(8080, 1000, 999999, 1);
        this.portField = new IntegerSpinner(inputModel);
        this.portField.setContent((Object)8080);
        this.add((Component)this.portField, this.c);
    }

    private void addUser() {
        JLabel nameLabel = new JLabel("User");
        this.c.insets = new Insets(3, 11, 1, 7);
        this.c.weightx = 1.0;
        this.add(nameLabel, this.c);
        this.c.insets = new Insets(2, 10, 5, 7);
        this.userField = new InputTextField();
        this.add((Component)this.userField, this.c);
    }

    private void addPassword() {
        JLabel passwordLabel = new JLabel("Password");
        this.c.insets = new Insets(5, 11, 1, 7);
        this.add(passwordLabel, this.c);
        this.passwordField = new InputPasswordField();
        this.c.insets = new Insets(2, 10, 5, 7);
        this.add((Component)this.passwordField, this.c);
    }

    private void addAlsoCheckBox(String text) {
        this.createAlsoCheckBox = new InputCheckBox(text, true);
        this.add((Component)this.createAlsoCheckBox, this.c);
    }

    private void addFocusOnServiceComboBox() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ServiceTestCreateDialog.this.serviceComboBox.requestFocus();
            }
        });
    }

    private void fillComboBox() {
        this.serviceBoxModel.clear();
        UmlDocument[] umlDocuments = new UmlDocumentFactory(new UmlDocumentCompilerSettings(new File(E2EBuilderProject.getProjectFolderName()))).getAllDocuments();
        ArrayList<String> deployments = new ArrayList<String>();
        for (UmlDocument umlDocument : umlDocuments) {
            if (!umlDocument.hasDescriptor()) continue;
            ArrayList allDeployments = umlDocument.getDescriptor().getAllDeployments();
            for (Deployment deployment : allDeployments) {
                deployments.add(deployment.getName());
            }
        }
        this.serviceBoxModel.addAll(deployments);
    }

    private void checkOkButton() {
        String item = (String)this.serviceComboBox.getEditor().getItem();
        this.setOkButtonEnabled(item != null && !item.isEmpty());
    }
}

