/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.project.gui;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.message.SendMessageEvent;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.base.project.ProjectInstantiationException;
import ch.e2e.builder.base.project.ProjectPool;
import ch.e2e.builder.base.project.ProjectSettingObjectWSChecker;
import ch.e2e.builder.base.project.gui.Logging;
import ch.e2e.builder.base.project.gui.ModulePanel;
import ch.e2e.builder.base.project.gui.ProjectDialog;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.builder.base.resource.MessageType;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;

public class NewProjectDialog
extends ProjectDialog
implements Logging {
    public NewProjectDialog(Iterator<E2EBuilderModule> builderModules) {
        super(builderModules, E2EBuilderTranslator.getTranslation((String)"project.new.title", (String)"project.new.title"), E2EBuilderTranslator.getTranslation((String)"project.new.internaltitle", (String)"project.new.internaltitle"), E2EBuilderTranslator.getTranslation((String)"project.new.subtitle", (String)"project.new.subtitle"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                NewProjectDialog.this.generalSettingsPanel.setNameFieldEditable(true);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                NewProjectDialog.this.generalSettingsPanel.setNameFieldEditable(true);
            }
        });
    }

    public E2EBuilderProject createNewProject(File oldProjectHome) {
        this.project = null;
        this.fillDefaults(oldProjectHome.getParentFile());
        this.setStartPane(null);
        this.showDialog();
        return this.project;
    }

    @Override
    public boolean doOnOk() {
        boolean ok = true;
        try {
            boolean containsFiles;
            HashMap<String, ProjectSettingObjectWSChecker> checkers = E2EBuilder.getInstance().getCheckers();
            this.project = new E2EBuilderProject(this.generalSettingsPanel.getProjectHome(), checkers);
            ok = super.doOnOk();
            if (ok && (containsFiles = FileUtilities.containsFiles((File)this.project.getProjectHome()))) {
                ok = ProjectPool.checkOverwriteFolder("project.folder.overwrite.create.question");
            }
            if (!ok) {
                this.project = null;
            }
        }
        catch (ProjectInstantiationException piEx) {
            if (piEx.getTargetException() == null) {
                String classname = this.getClass().getName();
                logger.severe("Caught a " + ((Object)((Object)piEx)).getClass().getName() + " in " + classname + ".readSettings");
                logger.throwing(classname, "readSettings", piEx);
            } else {
                String classname = this.getClass().getName();
                logger.severe("Caught a " + piEx.getTargetException().getClass().getName() + " in " + classname + ".readSettings");
                logger.throwing(classname, "readSettings", piEx.getTargetException());
            }
            EventController.fire((EventObject)new SendMessageEvent((Object)this, piEx.getMessage(), null, "fatalerror", "E2EBuilder", MessageType.APPLICATION_ERROR));
        }
        return ok;
    }

    private void fillDefaults(File oldProjectFolder) {
        File projectHome = this.generalSettingsPanel.fillDefaults(oldProjectFolder);
        for (Object o : this.modulePanels.values()) {
            ModulePanel module = (ModulePanel)o;
            module.fillDefaults(projectHome);
        }
    }
}

