/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui.model;

import ch.e2e.builder.base.gui.model.ActionScriptError;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.builder.eal.ParseException;
import ch.e2e.builder.eal.Token;
import ch.e2e.builder.eal.TokenMgrError;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;

public class EALSyntaxError
implements ActionScriptError {
    private static final String ERROR_SYNTAX_ERROR = "actionscript.document.error.syntaxError";
    private static final Matcher MATCHER = Pattern.compile("line (\\d+),? column (\\d+)").matcher("");
    private final String description;
    private final int line;
    private final int offset;
    private final int length;
    private final boolean multiLine;

    private EALSyntaxError(String description, int line, int offset, int length, boolean multiLine) {
        this.description = description;
        this.line = line;
        this.offset = offset;
        this.length = length;
        this.multiLine = multiLine;
    }

    public static EALSyntaxError newEalSyntaxError(Throwable e) {
        return new EALSyntaxError(e.getMessage());
    }

    public static EALSyntaxError newEalSyntaxError(ParseException e, Document document, int startLine) {
        EALSyntaxError error;
        Token token = e.currentToken.next;
        if (token == null) {
            int line = e.currentToken.beginLine + startLine - 1;
            int pos = document.getDefaultRootElement().getElement(line).getStartOffset() + e.currentToken.beginColumn - 1;
            error = new EALSyntaxError(EALSyntaxError.adjustDescription(e, startLine), line, pos, 1);
        } else {
            int length;
            int line = token.beginLine + startLine - 1;
            int pos = document.getDefaultRootElement().getElement(line).getStartOffset() + token.beginColumn - 1;
            if (token.beginLine == token.endLine) {
                length = token.endColumn - token.beginColumn + 1;
            } else {
                int endPos = document.getDefaultRootElement().getElement(token.endLine + startLine - 1).getStartOffset() + token.endColumn;
                length = endPos - pos;
            }
            error = new EALSyntaxError(EALSyntaxError.adjustDescription(e, startLine), line, pos, length, e.currentToken.image != null && e.currentToken.endLine != token.beginLine);
        }
        return error;
    }

    public static EALSyntaxError newEalSyntaxError(TokenMgrError e, Document document, int startLine) {
        int line = e.getErrorLine() + startLine - 1;
        int pos = document.getDefaultRootElement().getElement(line).getStartOffset() + e.getErrorColumn() - 1;
        return new EALSyntaxError(EALSyntaxError.adjustDescription(e, startLine), line, pos - 1, 1);
    }

    public static EALSyntaxError newEalSyntaxError(Error e, Document document, int startLine) {
        EALSyntaxError error = null;
        if (e.getMessage() != null) {
            MATCHER.reset(e.getMessage());
            if (MATCHER.find()) {
                int line = Integer.parseInt(MATCHER.group(1)) + startLine - 1;
                int column = Integer.parseInt(MATCHER.group(2));
                String desc = MATCHER.replaceFirst("line " + (line + 1));
                int pos = document.getDefaultRootElement().getElement(line).getStartOffset() + column - 1;
                error = new EALSyntaxError(desc, line, pos, 1);
            }
        }
        return error;
    }

    @Override
    public String getDescription() {
        return E2EBuilderTranslator.getTranslation((String)ERROR_SYNTAX_ERROR) + ": " + this.description;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    private EALSyntaxError(String description) {
        this(description, -1, -1, 0, false);
    }

    private EALSyntaxError(String description, int line, int offset, int length) {
        this(description, line, offset, length, false);
    }

    private static String adjustDescription(Throwable e, int startLine) {
        String desc = null;
        if (e.getMessage() != null) {
            MATCHER.reset(e.getMessage());
            if (MATCHER.find()) {
                int line = Integer.parseInt(MATCHER.group(1)) + startLine;
                desc = MATCHER.replaceFirst("line " + line);
            } else {
                desc = e.getMessage();
            }
        }
        return desc;
    }
}

