/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.gui.ListSelectionPopupAction;
import ch.e2e.builder.base.module.E2EBuilderModule;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListModel;

public class ListSelectionList
extends JList {
    private ListMouseAdapter mouseAdapter;

    public ListSelectionList(ListModel dataModel, JButton buttonAction, E2EBuilderModule module) {
        super(dataModel);
        this.mouseAdapter = new ListMouseAdapter(buttonAction, module);
        this.addMouseListener(this.mouseAdapter);
    }

    public void setPopupAction(ListSelectionPopupAction popupAction) {
        this.mouseAdapter.popupAction = popupAction;
    }

    private class ListMouseAdapter
    extends MouseAdapter {
        private JButton buttonAction;
        private E2EBuilderModule module;
        private ListSelectionPopupAction popupAction;

        public ListMouseAdapter(JButton buttonAction, E2EBuilderModule module) {
            this.buttonAction = buttonAction;
            this.module = module;
            this.popupAction = new ListSelectionPopupAction();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.buttonAction.doClick();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int index = ListSelectionList.this.locationToIndex(e.getPoint());
            if ((e.isPopupTrigger() || e.getButton() == 3) && this.isInRange(index, e.getPoint()) && index != -1) {
                ListSelectionList.this.setSelectedIndex(index);
                this.popupAction.doAction(ListSelectionList.this.getSelectedValue(), ListSelectionList.this, e.getPoint(), this.module);
            }
        }

        private boolean isInRange(int index, Point point) {
            Rectangle bounds = ListSelectionList.this.getCellBounds(index, index);
            return bounds != null && point.x >= bounds.x && point.x <= bounds.x + bounds.width && point.y >= bounds.y && point.y <= bounds.y + bounds.height;
        }
    }
}

