/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.examples;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.examples.ExampleEntry;
import ch.e2e.builder.base.examples.ExtractExamplesDialog;
import ch.e2e.builder.base.project.event.OpenRecentProjectEvent;
import ch.e2e.event.EventController;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.ZipUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;

public class ExamplesAction {
    private static final List<String> excludedEntries = Arrays.asList("META-INF", "META-INF/", "META-INF/MANIFEST.MF");
    private static ExamplesAction action;

    private ExamplesAction() {
    }

    public static ExamplesAction getInstance() {
        if (action == null) {
            action = new ExamplesAction();
        }
        return action;
    }

    public void extractExamples() {
        ExtractExamplesDialog extractExamplesDialog = new ExtractExamplesDialog();
        File examplesFolder = E2EBuilder.getInstance().getProperties().getFile("examples.installation.folder", new File("C:/xUML Documentation"));
        List<ExampleEntry> examples = extractExamplesDialog.selectExamples(examplesFolder);
        if (examples != null && examples.size() > 0) {
            boolean openAfterInstallation = extractExamplesDialog.isOpenAfterInstallation();
            examplesFolder = extractExamplesDialog.getExamplesInstallationFolder();
            this.extractExamples(examples, examplesFolder, openAfterInstallation);
        }
    }

    public void extractExamples(List<ExampleEntry> examples, File examplesFolder, boolean openAfterInstallation) {
        E2EBuilder.getInstance().getProperties().setProperty("examples.installation.folder", examplesFolder);
        for (ExampleEntry example : examples) {
            File examplesInstallationFolder = new File(examplesFolder, example.getPath()).getParentFile();
            if (!examplesInstallationFolder.exists()) {
                examplesInstallationFolder.mkdirs();
            }
            try {
                File tmpFile = File.createTempFile(example.getName(), "zip");
                FileUtilities.copy((InputStream)example.getInputStream(), (OutputStream)new FileOutputStream(tmpFile));
                ZipUtilities.extract((File)tmpFile, (File)examplesInstallationFolder, excludedEntries);
                tmpFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (openAfterInstallation) {
            File projectFolder = new File(examplesFolder, examples.get(0).getExampleName());
            EventController.fire((EventObject)((Object)new OpenRecentProjectEvent(projectFolder.getAbsolutePath())));
        }
    }
}

