/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.application;

import ch.e2e.builder.ActivateSaxon;
import ch.e2e.builder.base.application.ApplicationClosingVetoException;
import ch.e2e.builder.base.application.E2EBuilderStandalone;
import ch.e2e.builder.base.application.Logging;
import ch.e2e.builder.base.application.ModulePropertiesPool;
import ch.e2e.builder.base.application.ParentApplication;
import ch.e2e.builder.base.application.abstracts.MenuObserver;
import ch.e2e.builder.base.application.abstracts.StatusHandler;
import ch.e2e.builder.base.application.abstracts.TransactionHandler;
import ch.e2e.builder.base.event.ApplicationClosingEvent;
import ch.e2e.builder.base.event.ApplicationDefaultHandler;
import ch.e2e.builder.base.event.ApplicationWantsCloseEvent;
import ch.e2e.builder.base.event.CloseEvent;
import ch.e2e.builder.base.event.ShowAboutBuilderEvent;
import ch.e2e.builder.base.event.ShowErrorEvent;
import ch.e2e.builder.base.gui.E2EBuilderAboutBox;
import ch.e2e.builder.base.gui.E2EBuilderInfoDialog;
import ch.e2e.builder.base.licensing.CheckLicenseEvent;
import ch.e2e.builder.base.message.ModuleMessageGroupsPool;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.module.ModuleFactory;
import ch.e2e.builder.base.print.E2EBuilderPrintService;
import ch.e2e.builder.base.project.ProjectPool;
import ch.e2e.builder.base.project.ProjectSettingObjectWSChecker;
import ch.e2e.builder.base.resource.E2EBuilderIcons;
import ch.e2e.builder.base.resource.E2EBuilderProperties;
import ch.e2e.event.DefaultHandler;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.Properties;
import ch.e2e.secure.HttpsUtil;
import ch.e2e.util.ArgumentParser;
import com.jidesoft.utils.Lm;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.Icon;

public class E2EBuilder
implements EventExecuter,
Logging {
    private static final String COMPANY_NAME = "E2E Technologies Ltd";
    private static final String PROJECT_NAME = "E2E Builder";
    private static final String JIDE_LICENSE_KEY = "wcY.Y:g9hngKhMs6ULkCkfzhYLpkirW2";
    public static boolean development;
    private static E2EBuilder application;
    private E2EBuilderProperties properties;
    private ModulePropertiesPool moduleProperties;
    private ProjectPool projectPool;
    private E2EBuilderModule activeModule;
    private ParentApplication parentApplication;
    private ModuleFactory moduleFactory;
    private Window parentWindow;
    private Frame parentFrame;
    private ArrayList<Image> applicationIcons;

    private E2EBuilder(ParentApplication parentApplication) throws InstantiationException {
        this.parentApplication = parentApplication;
        Properties installInfo = new Properties("ch.e2e.builder.install");
        String propertiesPrefix = installInfo.getString("properties.prefix");
        if (installInfo.containsKey((Object)"application.home")) {
            System.setProperty("ch.e2e.builder.application.home", installInfo.getString("application.home"));
            System.setProperty("install.root", installInfo.getString("application.home"));
        }
        if (installInfo.containsKey((Object)"builder.home")) {
            System.setProperty("ch.e2e.builder.home", installInfo.getString("builder.home"));
        }
        System.setProperty("ch.e2e.builder.system.library.path", parentApplication.getBuilderSystemLibraryPath());
        this.readApplicationIcons(installInfo);
        this.setModelProperties(installInfo);
        this.properties = new E2EBuilderProperties(propertiesPrefix);
        this.properties.addProperties(installInfo);
        ch.e2e.builder.base.logging.Logging.Initialize((File)this.properties.getFile("logging.properties", new File(System.getProperty("user.home"), ".e2ebuilder" + File.separator + propertiesPrefix + ".logging.properties")));
        this.createDevelopmentProperty();
        this.createDevCleanAllProperty();
        this.createDevCleanTaskProperties();
        this.moduleProperties = new ModulePropertiesPool(propertiesPrefix);
        EventController.setDefaultHandler((DefaultHandler)new ApplicationDefaultHandler());
        EventController.register((EventExecuter)this, CloseEvent.class);
        this.acceptUntrustedCertificate();
        E2EBuilderPrintService.initialize();
        this.checkStatusHandler(parentApplication);
        this.checkMenuObserver(parentApplication);
        this.checkTransactionhandler(parentApplication);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                E2EBuilderInfoDialog.error(((ShowErrorEvent)event).getMessage());
            }
        }, ShowErrorEvent.class);
    }

    public static E2EBuilder getInstance() {
        if (application == null) {
            throw new RuntimeException("E2EBuilder is not initialized.");
        }
        return application;
    }

    public static void initialize(ParentApplication parentApplication) throws InstantiationException {
        if (application == null) {
            ActivateSaxon.activate();
            application = new E2EBuilder(parentApplication);
            application.initializeLicenseManager();
            application.loadModules();
            EventController.register((EventExecuter)new E2EBuilderAboutBox(parentApplication), ShowAboutBuilderEvent.class);
            parentApplication.setModuleFactory(E2EBuilder.application.moduleFactory);
            System.out.println(parentApplication.getApplicationInfo().toString());
        }
    }

    public HashMap<String, ProjectSettingObjectWSChecker> getCheckers() {
        HashMap<String, ProjectSettingObjectWSChecker> checkers = new HashMap<String, ProjectSettingObjectWSChecker>();
        for (E2EBuilderModule module : this.moduleFactory.getModules()) {
            checkers.put(module.getName(), module.getProjectSettingObjectWSChecker());
        }
        return checkers;
    }

    public void loadModules() {
        this.moduleFactory = new ModuleFactory(this.moduleProperties, this.parentApplication);
        this.projectPool = new ProjectPool(this.properties, this.moduleFactory);
        for (E2EBuilderModule module : this.moduleFactory.getModules()) {
            module.setProjectPool(this.projectPool);
        }
    }

    public E2EBuilderProperties getProperties() {
        return this.properties;
    }

    public static File getApplicationHome() {
        return E2EBuilder.application.properties.getFile("application.home", new File(""));
    }

    public Frame getApplicationFrame() {
        return this.parentApplication.getApplicationFrame();
    }

    public ParentApplication getParentApplication() {
        return this.parentApplication;
    }

    public Window getDialogParent() {
        return this.parentWindow == null ? (this.parentFrame == null ? this.getApplicationFrame() : this.parentFrame) : this.parentWindow;
    }

    public void setParentFrame(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public Frame getParentFrame() {
        return this.parentFrame == null ? this.getApplicationFrame() : this.parentFrame;
    }

    public void setDialogParent(Window dialogParent) {
        this.parentWindow = dialogParent;
    }

    public ProjectPool getProjectPool() {
        return this.projectPool;
    }

    public E2EBuilderModule getActiveModule() {
        return this.activeModule;
    }

    public void setActiveModule(E2EBuilderModule activeModule) {
        this.activeModule = activeModule;
    }

    public void execute(EventObject event) {
        ApplicationWantsCloseEvent wantsCloseEvent = new ApplicationWantsCloseEvent(this);
        try {
            EventController.fire((EventObject)wantsCloseEvent);
            this.closeApplication();
        }
        catch (ApplicationClosingVetoException vetoEx) {
            logger.info("Application closing aborted: " + vetoEx.getMessage());
        }
    }

    public void saveState() {
        logger.entering(E2EBuilder.class.getName(), "saveState");
        logger.severe("saving builder properties");
        this.properties.saveProperties();
        logger.severe("saving module properties");
        this.moduleProperties.saveAllProperties();
        logger.severe("saving builder project");
        this.projectPool.saveProject();
    }

    public Icon getE2EBuilderLogo() {
        return E2EBuilderIcons.E2EBUILDER_LOGO;
    }

    public Icon getE2EBuilderLogoSmall() {
        return E2EBuilderIcons.E2EBUILDER_LOGO_SMALL;
    }

    public ArrayList<Image> getApplicationIcons() {
        return this.applicationIcons;
    }

    private void readApplicationIcons(Properties installInfo) {
        Image icon;
        this.applicationIcons = new ArrayList();
        if (installInfo.containsKey((Object)"application.icon.16x16") && (icon = ImageLoader.loadImage((String)installInfo.getString("application.icon.16x16"), (boolean)false, (ClassLoader)this.getClass().getClassLoader())) != null) {
            this.applicationIcons.add(icon);
        }
        if (installInfo.containsKey((Object)"application.icon.32x32") && (icon = ImageLoader.loadImage((String)installInfo.getString("application.icon.32x32"), (boolean)false, (ClassLoader)this.getClass().getClassLoader())) != null) {
            this.applicationIcons.add(icon);
        }
        if (installInfo.containsKey((Object)"application.icon.64x64") && (icon = ImageLoader.loadImage((String)installInfo.getString("application.icon.64x64"), (boolean)false, (ClassLoader)this.getClass().getClassLoader())) != null) {
            this.applicationIcons.add(icon);
        }
        if (this.applicationIcons.size() == 0) {
            this.applicationIcons.add(E2EBuilderIcons.APPLICATION_ICON);
        }
    }

    private void setModelProperties(Properties installInfo) {
        String url2;
        File applicationHome = new File(System.getProperty("ch.e2e.builder.application.home"));
        File folder = new File(applicationHome, installInfo.getString("model.templates.path", "templates/E2EBridge"));
        String path = folder.getAbsolutePath();
        System.setProperty("ch.e2e.builder.compiler.templates.folder", path);
        try {
            url2 = folder.toURI().toURL().toString().replace(" ", "%20");
            if (!url2.endsWith("/")) {
                url2 = url2.concat("/");
            }
            System.setProperty("ch.e2e.builder.compiler.templates.url", url2);
        }
        catch (MalformedURLException url2) {
            // empty catch block
        }
        folder = new File(applicationHome, installInfo.getString("model.profiles.path", "profiles"));
        try {
            url2 = folder.toURI().toURL().toString().replace(" ", "%20");
            if (!url2.endsWith("/")) {
                url2 = url2.concat("/");
            }
            System.setProperty("ch.e2e.builder.compiler.profiles.url", url2);
        }
        catch (MalformedURLException url3) {
            // empty catch block
        }
        folder = new File(applicationHome, installInfo.getString("model.libraries.path", "modelLibraries"));
        try {
            url2 = folder.toURI().toURL().toString().replace(" ", "%20");
            if (!url2.endsWith("/")) {
                url2 = url2.concat("/");
            }
            System.setProperty("ch.e2e.builder.compiler.model.libraries.url", url2);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void initializeLicenseManager() {
        EventController.fire((EventObject)new CheckLicenseEvent(this));
    }

    private void createDevelopmentProperty() {
        try {
            development = this.properties.getBoolean("development");
            System.setProperty("ch.e2e.builder.development", String.valueOf(development));
        }
        catch (MissingResourceException mrEx) {
            development = false;
            System.setProperty("ch.e2e.builder.development", "false");
        }
    }

    private void createDevCleanAllProperty() {
        try {
            boolean devCleanAll = this.properties.getBoolean("devCleanAll");
            System.setProperty("ch.e2e.builder.devCleanAll", String.valueOf(devCleanAll));
        }
        catch (MissingResourceException mrEx) {
            System.setProperty("ch.e2e.builder.devCleanAll", "false");
        }
    }

    private void createDevCleanTaskProperties() {
        Set keys = this.properties.keySet();
        for (Object key : keys) {
            if (!key.toString().contains("devCleanTask.")) continue;
            try {
                boolean devCleanTask = this.properties.getBoolean(key.toString());
                System.setProperty("ch.e2e.builder." + key.toString(), String.valueOf(devCleanTask));
            }
            catch (MissingResourceException mrEx) {
                System.setProperty("ch.e2e.builder." + key.toString(), "false");
            }
        }
    }

    private void checkTransactionhandler(ParentApplication parentApplication) throws InstantiationException {
        TransactionHandler transactionHandler = parentApplication.getTransactionHandler();
        if (transactionHandler == null) {
            throw new InstantiationException("Application must define a TransactionHandler.");
        }
    }

    private void checkMenuObserver(ParentApplication parentApplication) throws InstantiationException {
        MenuObserver menuObserver = parentApplication.getMenuObserver();
        if (menuObserver == null) {
            throw new InstantiationException("Application must define a MenuObserver.");
        }
    }

    private void checkStatusHandler(ParentApplication parentApplication) {
        StatusHandler statusHandler = parentApplication.getStatusHandler();
        if (statusHandler == null) {
            logger.warning("Application should define a StatusHandler.");
        }
    }

    private void closeApplication() {
        ApplicationClosingEvent closingEvent = new ApplicationClosingEvent(this);
        EventController.fire((EventObject)closingEvent);
        this.saveState();
        System.exit(0);
    }

    private void acceptUntrustedCertificate() {
        try {
            HttpsUtil.initialize();
            logger.finest("changed https settings");
        }
        catch (Exception e) {
            logger.finest(e.getMessage());
        }
    }

    public Object createObject(String parentApplication, String packageName, String classnameExtension) {
        String classname = packageName + "." + parentApplication + classnameExtension;
        Object result = null;
        try {
            Class<?> objectClass = Class.forName(classname);
            result = objectClass.newInstance();
        }
        catch (Exception ex) {
            logger.throwing(E2EBuilder.class.getName(), "createObject", ex);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object createModuleObject(String modulePackagePrefix, String packageName, String classnameExtension, E2EBuilderModule module) {
        String classname = packageName + "." + modulePackagePrefix + classnameExtension;
        Object result = null;
        try {
            Class<?> objectClass = Class.forName(classname);
            Class<?> moduleClass = module.getClass();
            while (moduleClass != null && result == null) {
                try {
                    Constructor<?> constructor = objectClass.getConstructor(moduleClass);
                    result = constructor.newInstance(module);
                }
                catch (NoSuchMethodException e) {
                    if ((moduleClass = moduleClass.getSuperclass()) != null) continue;
                    throw e;
                    return result;
                }
            }
        }
        catch (Exception ex) {
            logger.throwing(E2EBuilder.class.getName(), "createObject", ex);
        }
        return result;
    }

    public static void main(String[] args) {
        Lm.verifyLicense((String)COMPANY_NAME, (String)PROJECT_NAME, (String)JIDE_LICENSE_KEY);
        E2EBuilderStandalone parentApplication = new E2EBuilderStandalone(new ArgumentParser(args));
        try {
            E2EBuilder.initialize(parentApplication);
        }
        catch (InstantiationException e) {
            logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
            logger.throwing(E2EBuilder.class.getName(), "main", e);
        }
        parentApplication.start(E2EBuilder.getInstance().getProjectPool());
    }

    static {
        System.setProperty("ch.e2e.base.message.MessageGroupsPool.key", ModuleMessageGroupsPool.class.getName());
    }
}

